/*
 * Decompiled with CFR 0.152.
 */
package com.lutris.classloader;

import com.lutris.classloader.ClassPathEntry;
import com.lutris.classloader.Resource;
import com.lutris.logging.LogChannel;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public class RemoteDirResource
extends Resource {
    private URL url = null;

    private RemoteDirResource(String name, ClassPathEntry location, LogChannel loadLogChannel) throws FileNotFoundException {
        super(name, location, loadLogChannel);
        URLConnection connection;
        URL locURL = location.getURL();
        if (locURL == null) {
            throw new FileNotFoundException("The URL for location, " + location + ", is null");
        }
        try {
            this.url = new URL(locURL.toString() + name);
        }
        catch (MalformedURLException mue) {
            throw new FileNotFoundException("The URL can not be created from the name " + name + ", and location " + locURL + ": " + mue.getMessage());
        }
        try {
            connection = this.url.openConnection();
        }
        catch (IOException ioe) {
            throw new FileNotFoundException("URL, " + this.url + ", does not exist or can not be reached");
        }
        this.size = connection.getContentLength();
        this.lastModifiedTime = connection.getLastModified();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.url.openStream();
    }

    @Override
    public long getCurrentLastModifiedTime() {
        return -1L;
    }
}

