
/*
 * @(#)HashMapNode.java 1.36 02/03/21
 *
 * Copyright 2002 Sun Microsystems, Inc. All rights reserved.
 * SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package org.enhydra.xml;


/**
 * @author Tweety
 *
 * A class that describes format of the output xml file.
 *
 * @version 1.0
 */
public class Indent {

    /**
     * Default tab value.
     */
    public static String  DEFAULT_TAB = "    ";
        
    /**
     * Indent size.
     */
    private int indent;
    
    /**
     * Tab string, the value that is going to be treated as tab.
     */
    private String  tab;
    
    
    
    /**
     * Constructs new <code>Indent</code> with the given size of indentation and the tab string.
     * 
     * @param ind size of indentation.
     * @param tab tab string.
     */
    public Indent(int ind, String  tab) {
        this.indent = ind;
        this.tab = tab;
    }
    
    
    /**
     * toString method
     */
    public String  toString() {
        StringBuffer  buff = new StringBuffer ();
        for (int i = 0; i < indent; i++)
            buff.append(tab);
        return buff.toString();
    }   


    /**
     * Increments the indentation size.
     */
    public void increment() {
        indent++;
    }   


    /**
     * Decrements the indentation size.
     */
    public void decrement() {
        indent--;
    }   


    /**
     * Returns the tab string.
     */
    public String  getTab() {
        return tab;
    }   

    /**
     * Sets the tab string.
     */
    public void setTab(String  tab) {
        this.tab = tab;
    }   
    
}
