

/*
 * Enhydra Java Application Server Project
 *
 * The contents of this file are subject to the Enhydra Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License on
 * the Enhydra web site ( http://www.enhydra.org/ ).
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific terms governing rights and limitations
 * under the License.
 *
 * The Initial Developer of the Enhydra Application Server is Lutris
 * Technologies, Inc. The Enhydra Application Server and portions created
 * by Lutris Technologies, Inc. are Copyright Lutris Technologies, Inc.
 * All Rights Reserved.
 *
 * Contributor(s):
 *
 * $Id: ConfigFileInterface.java,v 1.1 2005/07/13 11:09:06 slobodan Exp $
 */

package org.enhydra.util;

import java.io.File ;
import java.io.FileNotFoundException ;
import java.io.IOException ;
import java.io.OutputStream ;

import com.lutris.util.Config;
import com.lutris.util.KeywordValueException;

/**
 * ConfigFileInterface is used to manipulate application's configuration files.
 *
 * @see Config
 * @version $Revision: 1.1 $
 */
public interface ConfigFileInterface {

/**
 * The key under which the trailing comment is stored.
 */
  public static final String  TRAILING_COMMENT = "ConfigFileTrailingComment";

/**
 * Returns the Config object representing the config data in the file.
 * @return The Config object for this ConfigFile.
 */
  public Config getConfig();

/**
 * Returns the comment associated with a given key, or <code>null</code> if
 * there is no comment. Pass in* <code>ConfigFileInterface.TRAILING_COMMENT</code> to get
 * the trailing comment.
 * @param key the key to look up.
 * @return the associated comment or <code>null</code>
 */
  public String  getComment (String  key);

/**
 * Add an entry to the config file.
 * @param key   The config element name.
 * @param values A string array of values.
 * @param comment   A string containing a properly commented config file comment.
 * @exception KeywordValueException
 */
  public void addEntry(String  key, String [] values, String  comment)
    throws KeywordValueException;

/**
 * Add an entry to the config file.
 * @param key   The config element name.
 * @param value A String value.
 * @param comment   A string containing a properly commented config file comment.
 * @exception KeywordValueException
 */
  public void addEntry(String  key, String  value, String  comment)
    throws KeywordValueException; 
  
/**
 * Remove an entry from the config file.
 * @param key   The config element name.
 * @exception KeywordValueException
 */
  public void removeEntry(String  key) throws KeywordValueException;
  
/**
 * Gets the associated file. If no file is associated with this config, <code>null</code> 
 * is returned.
 * @return associated file
 */
  public File  getFile(); 

/**
 * Sets the configuration file. This method can be useful in case when in
 * construction of ConfigFileInterface implementation object is not defined 
 * associated file.
 * @param file given reference to configuration file represented as File object.
 */
  public void  setFile(File  file);

/**
 * Writes this config to the associated file. If no file is associated with this 
 * config, throws a <code>FileNotFoundException</code>
 * @exception IOException
 * @exception FileNotFoundException
 */
  public void write() throws IOException , FileNotFoundException ;

/**
 * Writes out a config file to the OutputStream specified. Note that Objects
 * other than String or String[] will be converted into a String.
 * @param outputStream The output stream on which to write the config file.
 */
  public void write(OutputStream  outputStream);
 
}
