

/*
 * Enhydra Java Application Server Project
 * 
 * The contents of this file are subject to the Enhydra Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License on
 * the Enhydra web site ( http://www.enhydra.org/ ).
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See 
 * the License for the specific terms governing rights and limitations
 * under the License.
 * 
 * The Initial Developer of the Enhydra Application Server is Lutris
 * Technologies, Inc. The Enhydra Application Server and portions created
 * by Lutris Technologies, Inc. are Copyright Lutris Technologies, Inc.
 * All Rights Reserved.
 * 
 * Contributor(s):
 * 
 * $Id: KeywordValueException.java,v 1.1 2005/07/13 11:09:06 slobodan Exp $
 */





package com.lutris.util;

/**
 * Exception for errors accessing a KeywordValueTable object.  The errors can
 * include invalid keyword syntax and unknown keywords.
 * 
 * @version $Revision: 1.1 $
 * @author  Mark Diekhans
 * @since   Jolt1.0
 */
public class KeywordValueException extends Exception  {
    /**
     * Constructs a new exception with the detail message.
     *
     * @param msg A detailed message describing the expection.
     */
    public KeywordValueException (String  msg) {
        super (msg);
    }

    /**
     * Constructs a new exception with the specified cause.
     *
     * @param cause The cause (which is saved for later retrieval by the 
     * Throwable.getCause() method). 
     * A null value is permitted, and indicates that the cause is 
     * nonexistent or unknown.
     */
    public KeywordValueException (Throwable  cause) {
        super (cause.getMessage());
    }

    /**
     * Constructs a new exception with the specified cause and a detail message.
     *
     * @param msg A detailed message describing the expection.
     * @param cause The cause (which is saved for later retrieval by the 
     * Throwable.getCause() method). 
     * A null value is permitted, and indicates that the cause is 
     * nonexistent or unknown.
     */
    public KeywordValueException (String  msg, Throwable  cause) {
        super (msg);
    }

}
