
/*
 * @(#)HashMapNode.java 1.36 02/03/21
 *
 * Copyright 2002 Sun Microsystems, Inc. All rights reserved.
 * SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package org.enhydra.xml;

import org.w3c.dom.Attr ;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element ;
import org.w3c.dom.Node ;
import org.w3c.dom.TypeInfo ;
import org.w3c.dom.UserDataHandler ;


/**
 * @author Tweety
 *
 * A class representing a node in a meta-data tree, which implements
 * the <a HREF="../../../../api/org/w3c/dom/Attr.html">
 *
 * <p> Namespaces are ignored in this implementation.  The terms "tag
 * name" and "node name" are always considered to be synonymous.
 *
 * @version 1.0
 */
public class AttrImpl extends NodeImpl implements Attr  {

    /**
     * If this attribute was explicitly given a value in the original 
     * document, this is <code>true</code>; otherwise, it is 
     * <code>false</code>. 
     */
    boolean specified = true;

    /**
     * Document owner.
     */
    Element  owner;
    
    /**
     * Attribute name.
     */
    String  name;
    
    /**
     * Attribute value.
     */
    String  value;


    
    /**
     * Constructs an empty <code>AttrImpl</code>.
     * 
     * @param owner document owner.
     * @param name node name.
     * @param value node value.
     */
    public AttrImpl(Element  owner, String  name, String  value) {
        this.owner = owner;
        this.name = name;
        this.value = value;
    }

    /**
     * Constructs a <code>AttrImpl</code> from the given node.
     * 
     * @param node, as a <code>AttrImpl</code>.
     */
    public AttrImpl(Attr  attr) {
        this.owner = attr.getOwnerElement();
        this.name = attr.getName();
        this.value = attr.getValue();
    }

    /**
     * Returns the attribute name associated with this node.
     *
     * @return the attribute name, as a <code>String</code>.
     */
    public String  getName() {
        return name;
    }

    /**
     * Returns the name associated with this node.
     *
     * @return the name, as a <code>String</code>.
     */
    public String  getNodeName() {
        return name;
    }

    /**
     * Returns the node type.
     *
     * @return the <code>ATTRIBUTE_NODE</code> node type.
     */
    public short getNodeType() {
        return ATTRIBUTE_NODE;
    }


    /**
     * If this attribute was explicitly given a value in the original 
     * document, this is <code>true</code>; otherwise, it is 
     * <code>false</code>. Note that the implementation is in charge of this 
     * attribute, not the user. If the user changes the value of the 
     * attribute (even if it ends up having the same value as the default 
     * value) then the <code>specified</code> flag is automatically flipped 
     * to <code>true</code>. To re-specify the attribute as the default 
     * value from the DTD, the user must delete the attribute. The 
     * implementation will then make a new attribute available with 
     * <code>specified</code> set to <code>false</code> and the default 
     * value (if one exists).
     * <br>In summary: If the attribute has an assigned value in the document 
     * then <code>specified</code> is <code>true</code>, and the value is 
     * the assigned value.If the attribute has no assigned value in the 
     * document and has a default value in the DTD, then 
     * <code>specified</code> is <code>false</code>, and the value is the 
     * default value in the DTD.If the attribute has no assigned value in 
     * the document and has a value of #IMPLIED in the DTD, then the 
     * attribute does not appear in the structure model of the document.If 
     * the <code>ownerElement</code> attribute is <code>null</code> (i.e. 
     * because it was just created or was set to <code>null</code> by the 
     * various removal and cloning operations) <code>specified</code> is 
     * <code>true</code>. 
     * 
     * Retuns always <code>true</code>.
     */
    public boolean getSpecified() {
        return specified;
    }

    /**
     * Returns the value associated with this attributes.
     *
     * @return the node attributes, as a <code>String</code>.
     */
    public String  getValue() {
        return value;
    }

    /**
     * Returns the value associated with this node.
     *
     * @return the node value, as a <code>String</code>.
     */
    public String  getNodeValue() {
        return value;
    }

    /**
     * Sets the value of this attribute to the given one.
     *
     * @param value the new attribute value, as a <code>String</code>.
     */
    public void setValue(String  value) {
        this.value = value;
    }

    /**
     * Sets the value of this node to the given one.
     *
     * @return the node value, as a <code>String</code>.
     */
    public void setNodeValue(String  value) {
        this.value = value;
    }

    /**
     * Returns the owner of this attribute.
     *
     * @return the attribute owner node.
     */
    public Element  getOwnerElement() {
        return owner;
    }

    /* (non-Javadoc)
     * @see org.w3c.dom.Attr#getSchemaTypeInfo()
     */
    public TypeInfo  getSchemaTypeInfo() {
        // TODO Auto-generated method stub
 return null;
    }

    /* (non-Javadoc)
     * @see org.w3c.dom.Attr#isId()
     */
    public boolean isId() {
        // TODO Auto-generated method stub
 return false;
    }

    /* (non-Javadoc)
     * @see org.w3c.dom.Node#getNamespaceURI()
     */
    public String  getNamespaceURI() {
        // TODO Auto-generated method stub
 return null;
    }

    /* (non-Javadoc)
     * @see org.w3c.dom.Node#getBaseURI()
     */
    public String  getBaseURI() {
        // TODO Auto-generated method stub
 return null;
    }

    /* (non-Javadoc)
     * @see org.w3c.dom.Node#compareDocumentPosition(org.w3c.dom.Node)
     */
    public short compareDocumentPosition(Node  arg0) throws DOMException
    {
        // TODO Auto-generated method stub
 return 0;
    }

    /* (non-Javadoc)
     * @see org.w3c.dom.Node#getTextContent()
     */
    public String  getTextContent() throws DOMException  {
        // TODO Auto-generated method stub
 return null;
    }

    /* (non-Javadoc)
     * @see org.w3c.dom.Node#setTextContent(java.lang.String)
     */
    public void setTextContent(String  arg0) throws DOMException  {
        // TODO Auto-generated method stub

    }

    /* (non-Javadoc)
     * @see org.w3c.dom.Node#isSameNode(org.w3c.dom.Node)
     */
    public boolean isSameNode(Node  arg0) {
        // TODO Auto-generated method stub
 return false;
    }

    /* (non-Javadoc)
     * @see org.w3c.dom.Node#lookupPrefix(java.lang.String)
     */
    public String  lookupPrefix(String  arg0) {
        // TODO Auto-generated method stub
 return null;
    }

    /* (non-Javadoc)
     * @see org.w3c.dom.Node#isDefaultNamespace(java.lang.String)
     */
    public boolean isDefaultNamespace(String  arg0) {
        // TODO Auto-generated method stub
 return false;
    }

    /* (non-Javadoc)
     * @see org.w3c.dom.Node#lookupNamespaceURI(java.lang.String)
     */
    public String  lookupNamespaceURI(String  arg0) {
        // TODO Auto-generated method stub
 return null;
    }

    /* (non-Javadoc)
     * @see org.w3c.dom.Node#isEqualNode(org.w3c.dom.Node)
     */
    public boolean isEqualNode(Node  arg0) {
        // TODO Auto-generated method stub
 return false;
    }

    /* (non-Javadoc)
     * @see org.w3c.dom.Node#getFeature(java.lang.String, java.lang.String)
     */
    public Object  getFeature(String  arg0, String  arg1) {
        // TODO Auto-generated method stub
 return null;
    }

    /* (non-Javadoc)
     * @see org.w3c.dom.Node#setUserData(java.lang.String, java.lang.Object, org.w3c.dom.UserDataHandler)
     */
    public Object  setUserData(String  arg0, Object  arg1, UserDataHandler  arg2) {
        // TODO Auto-generated method stub
 return null;
    }

    /* (non-Javadoc)
     * @see org.w3c.dom.Node#getUserData(java.lang.String)
     */
    public Object  getUserData(String  arg0) {
        // TODO Auto-generated method stub
 return null;
    }
}