

/*
 * Enhydra Java Application Server Project
 * 
 * The contents of this file are subject to the Enhydra Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License on
 * the Enhydra web site ( http://www.enhydra.org/ ).
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See 
 * the License for the specific terms governing rights and limitations
 * under the License.
 * 
 * The Initial Developer of the Enhydra Application Server is Lutris
 * Technologies, Inc. The Enhydra Application Server and portions created
 * by Lutris Technologies, Inc. are Copyright Lutris Technologies, Inc.
 * All Rights Reserved.
 * 
 * Contributor(s):
 * 
 * $Id: FatalExceptionError.java,v 1.1 2005/07/13 11:09:06 slobodan Exp $
 */




package com.lutris.util;

/*
 * Class that encapsulates exceptions as runtime errors.  This is used when an
 * an exception is caught that really should be treated as a runtime error.
 * This should only be used for exceptions that really should be treated as
 * fatal errors; not as a way of by-passing Java error handling.
 */
public class FatalExceptionError extends Error  {
    /**
     * Encapsulated exception.
     */
    Exception  except;

    /**
     * Constucts with an existing exception or error.
     *
     * @param except - Exception to encapsulate.
     */
    public FatalExceptionError (Exception  except) {
        this.except = except;
    }

    /**
     * Get the exception that occured.
     *
     * @return A reference to the exception.
     */
    public Exception  getException () {
        return except;
    }

    /**
     * Get the detail message of the encapsulate exception.
     *
     * @return The detail message
     */
    public String  getMessage() {
    return except.getMessage();
    }

    /**
     * Get the localized message of the encapsulate exception.
     * 
     * @return The detail message
     */
    public String  getLocalizedMessage() {
    return except.getLocalizedMessage();
    }

    /**
     * Returns a string representation that includes this object and the
     * encapsulated object.
     *
     * @return  The string representation.
     */
    public String  toString() {
    String  str = getClass().getName() + ": " +
            except.getClass().getName();
    String  message = except.getMessage();

        if (message == null) 
            return str;
        return str + ": " + message;
    }

    /**
     * Call the encapsulated object printStackTrack method with output to the
     * standard error string.
     */
    public void printStackTrace() { 
        except.printStackTrace();
    }

    /**
     * Call the encapsulated object printStackTrack method with output to a
     * specified stream.
     */
    public void printStackTrace(java.io.PrintStream  str) { 
        except.printStackTrace(str);
    }

    /**
     * Call the encapsulated object printStackTrack method with output to a
     * specified stream print writer.
     */
    public void printStackTrace(java.io.PrintWriter  pw) {
    except.printStackTrace(pw);
    }
}
