

/*
 * Enhydra Java Application Server Project
 *
 * The contents of this file are subject to the Enhydra Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License on
 * the Enhydra web site ( http://www.enhydra.org/ ).
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific terms governing rights and limitations
 * under the License.
 *
 * The Initial Developer of the Enhydra Application Server is Lutris
 * Technologies, Inc. The Enhydra Application Server and portions created
 * by Lutris Technologies, Inc. are Copyright Lutris Technologies, Inc.
 * All Rights Reserved.
 *
 * Contributor(s):
 *
 * $Id: RemoteDirResource.java,v 1.2 2005/03/24 10:51:25 slobodan Exp $
 */





package com.lutris.classloader;

// lutris packages
// v. strahinja, 27 sep 2002
import java.io.FileNotFoundException ;
import java.io.IOException ;
import java.io.InputStream ;
import java.net.MalformedURLException ;
import java.net.URL ;
import java.net.URLConnection ;

import com.lutris.logging.LogChannel;

/**
 * <P>A <CODE>Resource</CODE> that is a file on a remote machine in
 * a specified directory.  The directory is represented by a
 * <CODE>ClassPathEntry</CODE>, and the filename is specified by a String.
 *
 * @author Kristen Pol, Lutris Technologies
 * @version $Revision : 1.1 $
 * @see com.lutris.classloader.MultiClassLoader
 * @see com.lutris.classloader.ClassPathEntry
 * @see com.lutris.classloader.Resource
 * @see java.io.File
 */
public class RemoteDirResource extends Resource {

    // data members

    private URL  url = null;

    // constructors

    // FIXME: Test and change to protected and add javadoc. (kp)
 private RemoteDirResource(String  name, ClassPathEntry location,
// v. strahinja, 27 sep 2002
 LogChannel loadLogChannel)
//                              Logger loadLogger)
 throws FileNotFoundException  {
// v. strahinja, 27 sep 2002
 super(name, location, loadLogChannel);
//  super(name, location, loadLogger);

    // Get location's URL
 URL  locURL = location.getURL();
        if (locURL == null) {
            throw new FileNotFoundException ( "The URL for location, "
                                             + location + ", is null");
        }

    // Create a new URL from location's URL and resource name
 try {
        url = new URL (locURL.toString() + name);
    } catch (MalformedURLException  mue) {
            throw new FileNotFoundException ("The URL can not be created from the name "
                                            + name + ", and location " + locURL
                                            + ": " +mue.getMessage());
    }

    // Get the URLConnection so size and time can be determined
 URLConnection  connection;
    try {
        connection = url.openConnection();
    } catch (IOException  ioe) {
            throw new FileNotFoundException ("URL, " + url
                                            + ", does not exist or can not be reached");
        }
        size = connection.getContentLength();
        lastModifiedTime = connection.getLastModified();
        //FIXME: Connection must be closed
    }

    // public methods

    public InputStream  getInputStream() throws IOException  {
    return url.openStream();
    }

    /**
     * Get current last-modification time of resource.  This is the
     * time on the disk file the resource is associated with.
     *
     * @return the last-modified time of the permanent copy of the resource
     * in milliseconds.
     */
    public long getCurrentLastModifiedTime() {
        return -1; //FIXME: IMPLEMENT
    }
}
