/*
 * Decompiled with CFR 0.152.
 */
package com.lutris.classloader;

import com.lutris.classloader.ClassPathEntry;
import com.lutris.classloader.Resource;
import com.lutris.logging.LogChannel;
import com.lutris.util.FatalExceptionError;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class RemoteZipResource
extends Resource {
    URL zipFileURL = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemoteZipResource(String name, ClassPathEntry location, LogChannel loadLogChannel) throws FileNotFoundException {
        super(name, location, loadLogChannel);
        this.zipFileURL = location.getURL();
        if (this.zipFileURL == null) {
            String error = "The URL for location, " + location + ", is null";
            this.logChannel.write(this.logLevel, error);
            throw new FileNotFoundException(error);
        }
        ZipInputStream zipStream = null;
        try {
            zipStream = this.getZipInputStream();
            if (zipStream == null) {
                String error = "URL \"" + this.zipFileURL + "\" does not exist, can not be reached, or is not a zip file; or the resource \"" + name + "\" is not in the zip file";
                this.logChannel.write(this.logLevel, error);
                throw new FileNotFoundException(error);
            }
        }
        finally {
            if (zipStream != null) {
                try {
                    zipStream.close();
                }
                catch (IOException ioe) {
                    String error = ioe.toString() + ": URL zip file \"" + this.zipFileURL + "\" is corrupt or the connection died";
                    this.logChannel.write(this.logLevel, error);
                    throw new FatalExceptionError(new IOException(error));
                }
            }
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        try {
            return this.getZipInputStream();
        }
        catch (FileNotFoundException fnfe) {
            String error = "URL zip file \"" + this.zipFileURL + "\" has disappeared or can no longer be reached; or the resource \"" + this.name + "\" is no longer in the zip file";
            this.logChannel.write(this.logLevel, error);
            throw new FatalExceptionError(new FileNotFoundException(error));
        }
    }

    private ZipInputStream getZipInputStream() throws FileNotFoundException {
        try {
            ZipInputStream zipStream = new ZipInputStream(this.zipFileURL.openStream());
            while (zipStream.available() > 0) {
                ZipEntry entry = zipStream.getNextEntry();
                if (entry == null) {
                    this.logChannel.write(this.logLevel, "Null zip entry.");
                    throw new IOException();
                }
                if (entry.getName().equals(this.name)) {
                    this.size = entry.getSize();
                    this.lastModifiedTime = entry.getTime();
                    return zipStream;
                }
                zipStream.closeEntry();
            }
        }
        catch (IOException e) {
            String error = "URL, " + this.zipFileURL + ", does not exist, can not be reached, is not a zip file, or the resource, " + this.name + ", is not in the zip file";
            this.logChannel.write(this.logLevel, error);
            throw new FileNotFoundException(error);
        }
        return null;
    }

    @Override
    public long getCurrentLastModifiedTime() {
        return -1L;
    }
}

