
package org.enhydra.xml;

import java.util.Properties ;

import org.w3c.dom.Document ;
import org.w3c.dom.Node ;

/**
 * @author Tweety
 *
 * A class representing 
 *
 * @version 1.0
 */
public class XMLConfig extends SearchElement {


    /**
     * Constructs an empty <code>SearchElement</code>.
     */
    public XMLConfig() {
    }


    /**
     * Constructs an <code>XMLConfig</code> with the given 
     * document owner and node name.
     *
     * @param ownerDoc the document owner of the node, as a <code>Document</code>.
     * @param nodeName the name of the node, as a <code>String</code>.
     */
    public XMLConfig(Document  ownerDoc, String  name) {
        super(ownerDoc, name);
    }


    /**
     * Constructs an <code>XMLConfig</code> from a given node 
     * (creates the children subtree too), as a <code>Node</code>
     *
     * @param node, as a <code>Node</code>.
     */
    public XMLConfig(Node  node) {
        super(node);
    }


    /**
     * Constructs a <code>XMLConfig</code> from the given node,
     * without creating entire children subtree.
     * 
     * @param element, as a <code>XMLConfig</code>.
     */
    public XMLConfig(XMLConfig node) {
        super((HashMapElement)node);
    }


    /**
     * Creates new instance of the XMLConfig class from the given <code>Node</code>.
     * 
     * @param node, as a <code>Node</code>.
     * 
     * @return new instance of the XMLConfig class.
     */
    protected Node  newElementInstance(Node  node) {
        return new XMLConfig(node);
    }


    /**
     * Creates new instance of <code>XMLConfig</code> from a given document
     * as a <code>Document</code>
     *
     * @param document document ant type of node.
     * 
     * @return new instance of <code>XMLConfig</code> from a given document.
     */
    public static XMLConfig newXMLConfigInstance(Document  document) {
        Node  root = document.getDocumentElement();
        return new XMLConfig(root);
    }


    /**
     * Returns <code>XMLConfig</code> as a subconfiguration with the given condition.
     *
     * @param document document ant type of node.
     */
    public XMLConfig getSection(String  name) {
        return (XMLConfig)getFirstSubElementsByCondition(name);
    }


//  /**
//   * .
//   */
//  public void setText(String namePath, String text, boolean create) {
//
//      if (!create) {
//         setText(namePath,text);
//         return;
//      }
//      NodeList nodes = this.getSubElementsByTagName(namePath);
//      if (nodes != null && nodes.getLength() > 0)
//           ((SearchElement) nodes.item(0)).setText(text);
//  }
//
//
//  /**
//   * @return recursive funtion that fullfills the <code>list</code>
//   * parameter with all the nodes in the given path.
//   */
//  private void createSubElementsByTag(String namePath) {
//
//      String[] keys = namePath.split(this.TAG_SEPARATOR, 2);
//      if (keys.length == 1) {
//          List fList = (List) this.children.get(tagName);
//          if (fList != null) {
//              for (int i = 0; i < fList.size(); i++) {
//                  HashMapElement elm = (HashMapElement) fList.get(i);
//                  String val = (String) elm.getText();
//                  if (val != null)
//                      if (val.equals(tagValue))
//                          list.add(elm);
//              }
//          } else {
//              Element newElement = new XMLConfig(this.ownerDocument,keys[0]);
//            this.appendChild(newElement);
//         }
//          return ;
//      }
//      NodeList tagChildren = this.getChildrenByTagName(keys[0]);
//      if (tagChildren != null) {
//          for (int i = 0; i < tagChildren.getLength(); i++)
//              ((SearchElement) tagChildren.item(i)).getSubElementsByTagText(keys[1], tagValue, list);
//      } else {
//          Element newElement = new XMLConfig(this.ownerDocument,keys[0]);
//         this.appendChild(newElement);
//     }
//  }



    public static void main(String [] args) {
        try {
            System.out.println("Reading document ...");
            Document  doc = XMLDocumentFactory.parse("input.xml");
            System.out.println("Creating node ...");
            XMLConfig node = XMLConfig.newXMLConfigInstance(doc);
            System.out.println("Serialize node ...");

            Properties  prop = new Properties ();
            prop.put(javax.xml.transform.OutputKeys.DOCTYPE_PUBLIC,"http:///enhydra.org");
            prop.put(javax.xml.transform.OutputKeys.VERSION,"1.1");
            XMLDocumentFactory.serialize(node, "output.xml ",prop);
            System.out.println("Searching ...");

            for (int i=0; i < 1000; i++) {
                if ( i%10 == 0)
                    System.out.print("\rprogress "+i/10+" %");
                XMLConfig section = node.getSection("database/package/package/package/package/package/package/table/column@id=EMAILADRESSE");
//                  node.getSubElementsByAttrValue("database/package/package/package/package/package/table@dbTableName","OLSERVER");
            }
            System.out.println("\rprogress 100 %");
            System.out.println();

//          NodeList nodeList = node.getSubElementsByAttrValue("database/package/package/package/package/package/table@dbTableName","OLSERVER");
 XMLConfig section = node.getSection("database/package/package/package/package/package/package/table/column@id=EMAILADRESSE");
            section.setAttr("type@javaType","Zoka");
            if (section == null)
                System.out.println("section = null");
            else {
                System.out.println("section = "+section);
            }


//          NodeList nodeList = node.getSubElementsByTagText("databaseManager/database/type","Oracle");
//            NodeList nodeList = node.getSubElementsByCondition("database/package/package/package/package/package/table@dbTableName=OLSERVER");
//          if (nodeList == null)
//              System.out.println("nodeList = null");
//          else {
//              for (int i=0; i<nodeList.getLength(); i++)
//                  System.out.println("node["+i+"] = "+nodeList.item(i));
//          }

        } catch(Exception  e) {
            e.printStackTrace();
            System.out.println("NOOOOOOOOOOOOO");
        }
    }
}
