/*
 * Decompiled with CFR 0.152.
 */
package com.lutris.classloader;

import com.lutris.classloader.ClassPathEntry;
import com.lutris.classloader.Resource;
import com.lutris.logging.LogChannel;
import com.lutris.util.FatalExceptionError;
import java.io.File;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;

class ClassPath {
    private Vector classPath = new Vector();
    private boolean loggingEnabled = false;
    private LogChannel logChannel;
    private int logLevel;

    public ClassPath(LogChannel loadLogChannel) {
        this((Vector)null, loadLogChannel);
    }

    public ClassPath(String[] entries, LogChannel loadLogChannel) {
        this(ClassPath.convertArrayToVector(entries, loadLogChannel), loadLogChannel);
    }

    public ClassPath(File[] entries, LogChannel loadLogChannel) {
        this(ClassPath.convertArrayToVector(entries, loadLogChannel), loadLogChannel);
    }

    public ClassPath(URL[] entries, LogChannel loadLogChannel) {
        this(ClassPath.convertArrayToVector(entries, loadLogChannel), loadLogChannel);
    }

    private ClassPath(Vector entries, LogChannel loadLogChannel) {
        this.set(entries);
        this.logChannel = loadLogChannel;
        if (this.logChannel != null) {
            this.logLevel = this.logChannel.getLevel("CLASSLOAD");
            this.loggingEnabled = this.logChannel.isEnabled(this.logLevel);
        }
    }

    public void set(String[] entries) {
        this.set(ClassPath.convertArrayToVector(entries, this.logChannel));
    }

    public void set(File[] entries) {
        this.set(ClassPath.convertArrayToVector(entries, this.logChannel));
    }

    public void set(URL[] entries) {
        this.set(ClassPath.convertArrayToVector(entries, this.logChannel));
    }

    public void add(String[] entries) {
        this.add(ClassPath.convertArrayToVector(entries, this.logChannel));
    }

    public void add(File[] entries) {
        this.add(ClassPath.convertArrayToVector(entries, this.logChannel));
    }

    public void add(URL[] entries) {
        this.add(ClassPath.convertArrayToVector(entries, this.logChannel));
    }

    public void clear() {
        this.classPath.removeAllElements();
    }

    public int getLength() {
        return this.classPath.size();
    }

    public Enumeration getPath() {
        return this.classPath.elements();
    }

    public Resource getResource(String name) {
        if (name == null) {
            throw new NullPointerException("Null resource name passed to getResource() for class path, " + this);
        }
        Resource resource = null;
        for (int i = 0; i < this.classPath.size(); ++i) {
            ClassPathEntry entry = null;
            entry = (ClassPathEntry)this.classPath.elementAt(i);
            if (this.loggingEnabled) {
                this.logChannel.write(this.logLevel, "  checking: \"" + entry.getName() + "\"");
            }
            if ((resource = entry.getResource(name)) == null) continue;
            if (this.loggingEnabled) {
                this.logChannel.write(this.logLevel, "  found: " + name);
            }
            return resource;
        }
        if (this.loggingEnabled) {
            this.logChannel.write(this.logLevel, "  not found: " + name);
        }
        return null;
    }

    private void set(Vector entries) {
        this.classPath.removeAllElements();
        this.add(entries);
    }

    private void add(Vector entries) {
        if (entries != null) {
            for (int i = 0; i < entries.size(); ++i) {
                this.classPath.insertElementAt(entries.elementAt(i), i);
            }
        }
    }

    private static Vector convertArrayToVector(Object[] array, LogChannel loadLogChannel) {
        if (array != null) {
            Vector<ClassPathEntry> vector = new Vector<ClassPathEntry>();
            for (int i = 0; i < array.length; ++i) {
                Object object = array[i];
                ClassPathEntry entry = null;
                if (object instanceof String) {
                    entry = new ClassPathEntry((String)object, loadLogChannel);
                } else if (object instanceof File) {
                    entry = new ClassPathEntry((File)object, loadLogChannel);
                } else if (object instanceof URL) {
                    entry = new ClassPathEntry((URL)object, loadLogChannel);
                } else {
                    throw new FatalExceptionError(new ClassCastException("Type, " + object.getClass() + ", is not supported. Expecting a String, File, or URL."));
                }
                if (entry == null || vector.contains(entry)) continue;
                vector.addElement(entry);
            }
            return vector;
        }
        return null;
    }
}

