
package org.enhydra.xml;

import org.w3c.dom.DOMException ;
import org.w3c.dom.Node ;
import org.w3c.dom.Text ;

/**
 * @author Tweety
 * 
 * A class representing a node in a meta-data tree, which implements
 * the <a HREF="../../../../api/org/w3c/dom/Element.html">
 *
 * <p> Namespaces are ignored in this implementation.  The terms "tag
 * name" and "node name" are always considered to be synonymous.
 *
 * @version 1.0
 */
public class TextImpl extends CharacterDataImpl implements Text  {


    /**
     * Constructs a <code>TextImpl</code> from the given node.
     * 
     * @param node, as a <code>TextImpl</code>.
     */
    public TextImpl(TextImpl node) {
        super((NodeImpl)node);
    }
    
    
    /**
     * Constructs a <code>TextImpl</code> from the given node value.
     * 
     * @param value, as a <code>String</code>.
     */
    public TextImpl(String  value) {
        nodeValue = value;
        type = Node.TEXT_NODE;
    }


    /**
     * Constructs a <code>TextImpl</code> from a given node,
     * as a <code>Node</code>
     *
     * @param node, as <code>Node</code>.
     */
    public TextImpl(Node  node) {
        super(node);
    }

    
    /**
     * Returns the node type.
     *
     * @return the <code>TEXT_NODE</code> node type.
     */
    public short getNodeType() {
        return Node.TEXT_NODE;
    }

    /**
     * Returns the name ("#text") associated with this node.
     *
     * @return the name, as a <code>String</code>.
     */
    public String  getNodeName() {
        return "#text";
    }
    
    
    /**
     * Returns the trimed node value associated with this node.
     *
     * @return the node value, as a <code>String</code>.
     */
    public String  getNodeValue() throws DOMException  {
        return nodeValue.trim();
    }
    
    
    /**
     * Method beginToString for this class writes the value
     * of this node (text).
     * 
     * @param sb string buffer to add resulting string.
     * @param indent used in formating the output.
     */
    protected void beginToString(StringBuffer  sb, Indent indent) {
        sb.append(this.nodeValue.trim());
    }
    
    /**
     * Method endToString does nothing.
     */
    protected void endToString(StringBuffer  sb, Indent indent) {
    }
    
    
    /**
     * @see org.w3c.dom.Text#splitText(int)
     *
     * Break a text node into two sibling nodes.  (Note that if the
     * current node has no parent, they won't wind up as "siblings" --
     * they'll both be orphans.)
     *
     * @param offset The offset at which to split. If offset is at the
     * end of the available data, the second node will be empty.
     *
     * @returns A reference to the new node (containing data after the
     * offset point). The original node will contain data up to that
     * point.
     *
     * @throws DOMException(INDEX_SIZE_ERR) if offset is <0 or >length.
     *
     * @throws DOMException(NO_MODIFICATION_ALLOWED_ERR) if node is read-only.
     */
    public Text  splitText(int offset) 
        throws DOMException  {

        if (offset < 0 || offset > nodeValue.length() ) {
            throw new DOMException (DOMException.INDEX_SIZE_ERR, "Index out of bounds");
        }
            
        // split text into two separate nodes
 TextImpl newText = new TextImpl(nodeValue.substring(offset));
        nodeValue = nodeValue.substring(0, offset);

        // insert new text node
 Node  parentNode = getParentNode();
        if (parentNode != null) {
            parentNode.insertBefore(newText, nextSibling);
        }

        return newText;

    }


    /* (non-Javadoc)
     * @see org.w3c.dom.Text#isElementContentWhitespace()
     */
    public boolean isElementContentWhitespace() {
        // TODO Auto-generated method stub
 return false;
    }


    /* (non-Javadoc)
     * @see org.w3c.dom.Text#getWholeText()
     */
    public String  getWholeText() {
        // TODO Auto-generated method stub
 return null;
    }


    /* (non-Javadoc)
     * @see org.w3c.dom.Text#replaceWholeText(java.lang.String)
     */
    public Text  replaceWholeText(String  arg0) throws DOMException  {
        // TODO Auto-generated method stub
 return null;
    }

}
