
/*
 * @(#)HashMapNode.java 1.36 02/03/21
 *
 * Copyright 2002 Sun Microsystems, Inc. All rights reserved.
 * SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package org.enhydra.xml;

import java.util.ArrayList ;
import java.util.List ;

import org.w3c.dom.Node ;
import org.w3c.dom.NodeList ;



/**
 * @author Tweety
 * 
 * A class representing a node in a meta-data tree, which implements
 * the <a HREF="../../../../api/org/w3c/dom/NodeList.html">
 *
 * <p> Namespaces are ignored in this implementation.  The terms "tag
 * name" and "node name" are always considered to be synonymous.
 *
 * @version 1.0
 */
public class NodeListImpl implements NodeList  {

    /**
     * List of <code>Node</code>s.
     */
    List  nodes;


    /**
     * Constructs an empty <code>NodeListImpl</code>.
     */
    public NodeListImpl() {
        this.nodes = new ArrayList ();
    }
    
    
    /**
     * Constructs <code>NodeListImpl</code> with the given list of nodes.
     * 
     * @param nodes list of nodes.
     */
    public NodeListImpl(List  nodes) {
        this.nodes = nodes;
    }


    /**
     * Returns the count of nodes.
     * 
     * @return the count of nodes.
     */
    public int getLength() {
        return nodes.size();
    }


    /**
     * Returns the <code>Node</code> with the given index.
     * 
     * @param index node index.
     * 
     * @return the <code>Node</code> with the given index.
     */
    public Node  item(int index) {
        if (index < 0 || index > nodes.size()) {
            return null;
        }
        return (Node ) nodes.get(index);
    }

    
    /**
     * Appends the given list to the end of the existing one.
     * 
     * @param list list to add, as <code>NodeListImpl</code>.
     * 
     * @return this as </code>NodeList</code>.
     */
    public NodeList  append(NodeListImpl list) {
        this.nodes.addAll(list.nodes);
        return this;
    }
    
}