
package org.enhydra.xml;

import org.w3c.dom.Comment ;
import org.w3c.dom.Node ;

/**
 * @author Tweety
 *
 * A class representing a node in a meta-data tree, which implements
 * the <a HREF="../../../../api/org/w3c/dom/Comment.html">
 *
 * <p> Namespaces are ignored in this implementation.  The terms "tag
 * name" and "node name" are always considered to be synonymous.
 *
 * @version 1.0
 */
public class CommentImpl extends CharacterDataImpl implements Comment  {

    /**
     * Constructs a <code>CommentImpl</code> from the given node.
     * 
     * @param node, as a <code>CommentImpl</code>.
     */
    public CommentImpl(CommentImpl node) {
        super((NodeImpl)node);
    }


    /**
     * Constructs a <code>CommentImpl</code> from the given node value.
     * 
     * @param value, as a <code>String</code>.
     */
    public CommentImpl(String  value) {
        nodeValue = value;
        type = Node.COMMENT_NODE;
    }
    
    
    /**
     * Constructs a <code>CommentImpl</code> from a given node,
     * as a <code>Node</code>
     *
     * @param node, as <code>Node</code>.
     */
    public CommentImpl(Node  node) {
        super(node);
    }


    /**
     * Returns the node type.
     *
     * @return the <code>COMMENT_NODE</code> node type.
     */
    public short getNodeType() {
        return Node.COMMENT_NODE;
    }

    /**
     * Returns the name ("#comment") associated with this node.
     *
     * @return the name, as a <code>String</code>.
     */
    public String  getNodeName() {
        return "#comment";
    }
    
    
    /**
     * Method beginToString for this class writes the xml
     * comment prefix string and the comment string.
     * 
     * @param sb string buffer to add resulting string.
     * @param indent used in formating the output.
     */
    protected void beginToString(StringBuffer  sb, Indent indent) {
        sb.append("\n" + indent + "<!-- " + this.nodeValue.trim());
    }
    
    
    /**
     * Method endToString writes the xml comment postfix string.
     */
    protected void endToString(StringBuffer  sb, Indent indent) {
        sb.append(" -->");
    }
    

}
