

/*
 * Enhydra Java Application Server Project
 *
 * The contents of this file are subject to the Enhydra Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License on
 * the Enhydra web site ( http://www.enhydra.org/ ).
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific terms governing rights and limitations
 * under the License.
 *
 * The Initial Developer of the Enhydra Application Server is Lutris
 * Technologies, Inc. The Enhydra Application Server and portions created
 * by Lutris Technologies, Inc. are Copyright Lutris Technologies, Inc.
 * All Rights Reserved.
 *
 * Contributor(s):
 *
 * $Id: RemoteZipResource.java,v 1.2 2005/03/24 10:51:25 slobodan Exp $
 */





package com.lutris.classloader;

// lutris packages
// v. strahinja, 27 sep 2002
import java.io.FileNotFoundException ;
import java.io.IOException ;
import java.io.InputStream ;
import java.net.URL ;
import java.util.zip.ZipEntry ;
import java.util.zip.ZipInputStream ;

import com.lutris.logging.LogChannel;
import com.lutris.util.FatalExceptionError;

/**
 * <P>A <CODE>Resource</CODE> that is an entry in
 * a specified zip file on a remote machine.  The zip file is represented by a
 * <CODE>ClassPathEntry</CODE>, and the filename is specified by a String.
 *
 * @author Kristen Pol, Lutris Technologies
 * @version $Revision : 1.1 $
 * @see com.lutris.classloader.MultiClassLoader
 * @see com.lutris.classloader.ClassPathEntry
 * @see com.lutris.classloader.Resource
 * @see java.io.File
 */
public class RemoteZipResource extends Resource {

    // data members

    URL  zipFileURL = null;

    // constructors

    // FIXME: Test and change to protected and add javadoc. (kp)
 private RemoteZipResource(String  name, ClassPathEntry location,
// v. strahinja, 27 sep 2002
 LogChannel loadLogChannel)
//      Logger loadLogger)
 throws FileNotFoundException  {
// v. strahinja, 27 sep 2002
 super(name, location, loadLogChannel);
//  super(name, location, loadLogger);

        // Get location's URL
        zipFileURL = location.getURL();
        if (zipFileURL == null) {
        String  error = "The URL for location, " + location + ", is null";
// v. strahinja, 27 sep 2002
        logChannel.write(logLevel, error);
//      logger.log(logLevel, error);
 throw new FileNotFoundException (error);
        }

    // Make sure the ZipEntry exists in the remote zip file
 // FileNotFoundException will be thrown if it is not found
 ZipInputStream  zipStream = null;
    try {
        zipStream = getZipInputStream();
        if (zipStream == null) {
        String  error = "URL \"" + zipFileURL + "\" does not exist, " +
            "can not be reached, or is not a zip file; or the " +
            "resource \"" + name + "\" is not in the zip file";
// v. strahinja, 27 sep 2002
        logChannel.write(logLevel, error);
//      logger.log(logLevel, error);
 throw new FileNotFoundException (error);
        }
    } finally {
        if (zipStream != null) {
        try {
            zipStream.close();
        } catch (IOException  ioe) {
            // This should not happen because it was already checked
 String  error = ioe.toString() + ": URL zip file \"" +
            zipFileURL + "\" is corrupt or the connection died";
// v. strahinja, 27 sep 2002
            logChannel.write(logLevel, error);
//          logger.log(logLevel, error);
 throw new FatalExceptionError(new IOException (error));
        }
        }
    }
    }

    // public methods

    /**
     * Gets the specified resource as an input stream.
     *
     * @return an <CODE>InputStream</CODE> representing the specified resource.
     * @exception an <CODE>IOException</CODE>
     */
    public InputStream  getInputStream() throws IOException  {
    try {
        return getZipInputStream();
    } catch (FileNotFoundException  fnfe) {
        // This should not happen because it was already checked
 String  error = "URL zip file \"" + zipFileURL +
        "\" has disappeared or can no longer be reached; or the " +
        "resource \"" + name + "\" is no longer in the zip file";
// v. strahinja, 27 sep 2002
        logChannel.write(logLevel, error);
//      logger.log(logLevel, error);
 throw new FatalExceptionError(new FileNotFoundException (error));
    }
    }

    // Get the input stream for the resource to if it exists.
 private ZipInputStream  getZipInputStream() throws FileNotFoundException  {
        ZipInputStream  zipStream;
        try {
            zipStream = new ZipInputStream (zipFileURL.openStream());
            while (zipStream.available() > 0) {
                ZipEntry  entry = zipStream.getNextEntry();
                if (entry == null) {
// v. strahinja, 27 sep 2002
           logChannel.write(logLevel, "Null zip entry.");
//         logger.log(logLevel, "Null zip entry.");
 throw new IOException ();
                }
                if (entry.getName().equals(name)) {
            size = entry.getSize();
            lastModifiedTime = entry.getTime();
                    return zipStream;
                }
                zipStream.closeEntry();
            }
        } catch (IOException  e) {
            String  error = "URL, " + zipFileURL + ", does not exist, " +
        "can not be reached, is not a zip file, or the resource, " +
        name + ", is not in the zip file";
// v. strahinja, 27 sep 2002
        logChannel.write(logLevel, error);
//      logger.log(logLevel, error);
 throw new FileNotFoundException (error);
        }
    return null;
    }

    /**
     * Get current last-modification time of resource.  This is the
     * time on the disk file the resource is associated with.
     *
     * @return the last-modified time of the permanent copy of the resource
     * in milliseconds.
     */
    public long getCurrentLastModifiedTime() {
        return -1; //FIXME: implement
    }
}
