/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.enhydra.xml.AttrImpl;
import org.enhydra.xml.HashMapNamedNodeMap;
import org.enhydra.xml.Indent;
import org.enhydra.xml.NodeDOMException;
import org.enhydra.xml.NodeImpl;
import org.enhydra.xml.NodeListImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.UserDataHandler;

public class ElementImpl
extends NodeImpl
implements Element {
    protected HashMap attributes = null;

    public ElementImpl() {
        this.attributes = new HashMap();
        this.type = 1;
    }

    public ElementImpl(ElementImpl element) {
        super(element);
        this.attributes = element.attributes;
        this.type = 1;
    }

    public ElementImpl(Document ownerDoc, String name) {
        super(ownerDoc, name, (short)1);
        this.attributes = new HashMap();
    }

    protected ElementImpl(Document ownerDoc, String nodeName, short type, String value) {
        super(ownerDoc, nodeName, type, value);
    }

    public ElementImpl(Node node) {
        this(node, true);
    }

    public ElementImpl(Node node, boolean deep) {
        super(node, false);
        this.attributes = new HashMap();
        NamedNodeMap attrs = node.getAttributes();
        if (attrs != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                AttrImpl attr = new AttrImpl((Attr)attrs.item(i));
                this.attributes.put(attr.getName(), attr);
            }
        }
        if (deep) {
            this.initNodeImplChildren(node);
        }
    }

    public static Element newInstance(Document document) {
        Element root = document.getDocumentElement();
        return new ElementImpl(root);
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) {
        super.insertBefore(newChild, refChild);
        return newChild;
    }

    @Override
    public Node replaceChild(Node newChild, Node oldChild) {
        super.replaceChild(newChild, oldChild);
        return oldChild;
    }

    @Override
    public Node removeChild(Node oldChild) {
        super.removeChild(oldChild);
        return oldChild;
    }

    @Override
    public Node cloneNode(boolean deep) {
        return new ElementImpl(this, deep);
    }

    @Override
    public String getTagName() {
        return this.nodeName;
    }

    @Override
    public NamedNodeMap getAttributes() {
        return new HashMapNamedNodeMap(this.attributes);
    }

    @Override
    public String getAttribute(String name) {
        Attr attr = this.getAttributeNode(name);
        if (attr == null) {
            return "";
        }
        return attr.getValue();
    }

    @Override
    public String getAttributeNS(String namespaceURI, String localName) {
        return this.getAttribute(localName);
    }

    @Override
    public void setAttribute(String name, String value) {
        this.attributes.put(name, new AttrImpl(this, name, value));
    }

    @Override
    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) {
        this.setAttribute(qualifiedName, value);
    }

    @Override
    public void removeAttribute(String name) {
        if (this.type != 1) {
            throw new NodeDOMException(9, "Node doesn't have attributes");
        }
        this.removeAttribute(name, true);
    }

    private void removeAttribute(String name, boolean checkPresent) {
        if (this.attributes.remove(name) != null) {
            return;
        }
        if (checkPresent) {
            throw new NodeDOMException(8, "No such attribute!");
        }
    }

    @Override
    public boolean hasAttributes() {
        return this.attributes.size() > 0;
    }

    @Override
    public boolean hasAttribute(String name) {
        return this.getAttributeNode(name) != null;
    }

    @Override
    public void removeAttributeNS(String namespaceURI, String localName) {
        this.removeAttribute(localName);
    }

    @Override
    public Attr getAttributeNode(String name) {
        return (Attr)this.attributes.get(name);
    }

    @Override
    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        return this.getAttributeNode(localName);
    }

    @Override
    public Attr setAttributeNode(Attr newAttr) throws DOMException {
        AttrImpl attr = newAttr instanceof AttrImpl ? (AttrImpl)newAttr : new AttrImpl(newAttr);
        this.attributes.put(attr.getName(), attr);
        return attr;
    }

    @Override
    public Attr setAttributeNodeNS(Attr newAttr) {
        return this.setAttributeNode(newAttr);
    }

    @Override
    public Attr removeAttributeNode(Attr oldAttr) {
        this.removeAttribute(oldAttr.getName());
        return oldAttr;
    }

    @Override
    public boolean hasAttributeNS(String namespaceURI, String localName) {
        return this.hasAttribute(localName);
    }

    @Override
    public NodeList getElementsByTagName(String name) {
        ArrayList list = new ArrayList();
        this.getElementsByTagName(name, list);
        return new NodeListImpl(list);
    }

    private void getElementsByTagName(String name, List list) {
        if (this.nodeName.equals(name)) {
            list.add(this);
        }
        for (Node child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            ((ElementImpl)child).getElementsByTagName(name, list);
        }
    }

    @Override
    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        return this.getElementsByTagName(localName);
    }

    public boolean hasElementChildNodes() {
        for (Node child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void beginToString(StringBuffer sb, Indent indent) {
        sb.append("\n" + indent + "<" + this.nodeName);
        for (Attr attr : this.attributes.values()) {
            sb.append(" " + attr.getNodeName() + "=\"" + attr.getNodeValue() + "\"");
        }
        sb.append(">");
        indent.increment();
    }

    @Override
    protected void endToString(StringBuffer sb, Indent indent) {
        indent.decrement();
        if (this.hasElementChildNodes()) {
            sb.append("\n" + indent + "</" + this.nodeName + ">");
        } else {
            sb.append("</" + this.nodeName + ">");
        }
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        return null;
    }

    @Override
    public void setIdAttribute(String arg0, boolean arg1) throws DOMException {
    }

    @Override
    public void setIdAttributeNS(String arg0, String arg1, boolean arg2) throws DOMException {
    }

    @Override
    public void setIdAttributeNode(Attr arg0, boolean arg1) throws DOMException {
    }

    @Override
    public String getNamespaceURI() {
        return null;
    }

    @Override
    public String getBaseURI() {
        return null;
    }

    @Override
    public short compareDocumentPosition(Node arg0) throws DOMException {
        return 0;
    }

    @Override
    public String getTextContent() throws DOMException {
        return null;
    }

    @Override
    public void setTextContent(String arg0) throws DOMException {
    }

    @Override
    public boolean isSameNode(Node arg0) {
        return false;
    }

    @Override
    public String lookupPrefix(String arg0) {
        return null;
    }

    @Override
    public boolean isDefaultNamespace(String arg0) {
        return false;
    }

    @Override
    public String lookupNamespaceURI(String arg0) {
        return null;
    }

    @Override
    public boolean isEqualNode(Node arg0) {
        return false;
    }

    @Override
    public Object getFeature(String arg0, String arg1) {
        return null;
    }

    @Override
    public Object setUserData(String arg0, Object arg1, UserDataHandler arg2) {
        return null;
    }

    @Override
    public Object getUserData(String arg0) {
        return null;
    }
}

