/*
 * Decompiled with CFR 0.152.
 */
package com.lutris.logging;

import com.lutris.logging.LogChannel;
import com.lutris.logging.LogWriter;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class LogAdapter
implements LogChannel {
    private static Logger logger = null;
    private static final int INT_ERROR = -1;

    public LogAdapter() {
    }

    public LogAdapter(Logger logger) {
        LogAdapter.logger = logger;
    }

    public void setLogger(Logger log) {
        logger = log;
    }

    public Logger getLogger() {
        return logger;
    }

    @Override
    public int getLevel(String level) {
        if (logger != null && logger.getLevel() != null) {
            return logger.getLevel().toInt();
        }
        return -1;
    }

    @Override
    public boolean isEnabled(int level) {
        return logger.isEnabledFor((Priority)this.intToLevel(level));
    }

    @Override
    public boolean isEnabled(String level) {
        return false;
    }

    @Override
    public void write(int level, String msg) {
        Level lev;
        if (logger == null) {
            logger = Logger.getLogger((String)LogAdapter.class.getName());
        }
        if ((lev = this.intToLevel(level)) == null) {
            lev = Level.INFO;
        }
        logger.log((Priority)lev, (Object)msg);
    }

    @Override
    public void write(int level, String msg, Throwable throwable) {
        Level lev;
        if (logger == null) {
            logger = Logger.getLogger((String)LogAdapter.class.getName());
        }
        if ((lev = this.intToLevel(level)) == null) {
            lev = Level.INFO;
        }
        logger.log((Priority)lev, (Object)msg, throwable);
    }

    @Override
    public void write(String level, String msg) {
        Level lev;
        if (logger == null) {
            logger = Logger.getLogger((String)LogAdapter.class.getName());
        }
        if ((lev = this.stringToLevel(level)) == null) {
            lev = Level.INFO;
        }
        logger.log((Priority)lev, (Object)msg);
    }

    @Override
    public void write(String level, String msg, Throwable throwable) {
        Level lev;
        if (logger == null) {
            logger = Logger.getLogger((String)LogAdapter.class.getName());
        }
        if ((lev = this.stringToLevel(level)) == null) {
            lev = Level.INFO;
        }
        logger.log((Priority)lev, (Object)msg);
    }

    private Level intToLevel(int level) {
        Level lev;
        switch (level) {
            case 0: 
            case 1: {
                lev = Level.FATAL;
                break;
            }
            case 2: 
            case 3: {
                lev = Level.ERROR;
                break;
            }
            case 4: {
                lev = Level.WARN;
                break;
            }
            case 5: 
            case 6: {
                lev = Level.INFO;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                lev = Level.DEBUG;
                break;
            }
            default: {
                lev = null;
            }
        }
        return lev;
    }

    private Level stringToLevel(String level) {
        Object lev = level.equalsIgnoreCase("EMERGENCY") || level.equalsIgnoreCase("ALERT") ? Level.FATAL : (level.equalsIgnoreCase("CRITICAL") || level.equalsIgnoreCase("ERROR") ? Level.ERROR : (level.equalsIgnoreCase("WARNING") ? Level.WARN : (level.equalsIgnoreCase("NOTICE") || level.equalsIgnoreCase("INFO") ? Level.INFO : (level.equalsIgnoreCase("DEBUG") || level.equalsIgnoreCase("DEBUG1") || level.equalsIgnoreCase("DEBUG2") || level.equalsIgnoreCase("DEBUG3") || level.equalsIgnoreCase("DEBUG4") || level.equalsIgnoreCase("DEBUG5") || level.equalsIgnoreCase("DEBUG6") || level.equalsIgnoreCase("DEBUG7") || level.equalsIgnoreCase("DEBUG8") || level.equalsIgnoreCase("DEBUG9") || level.equalsIgnoreCase("DEBUGTMP") ? Level.DEBUG : null))));
        return lev;
    }

    @Override
    public LogWriter getLogWriter(String level) {
        return null;
    }

    @Override
    public LogWriter getLogWriter(int level) {
        return null;
    }
}

