/*
 * Decompiled with CFR 0.152.
 */
package com.lutris.logging;

import com.lutris.logging.Log4jLogChannel;
import com.lutris.logging.LogChannel;
import com.lutris.logging.Logger;
import com.lutris.util.Config;
import com.lutris.util.ConfigException;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import javax.xml.parsers.FactoryConfigurationError;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.xml.DOMConfigurator;

public class Log4jLogger
extends Logger {
    private Hashtable levelNumbers = new Hashtable();
    protected String[] levelNames = new String[34];
    protected int numLevels = 0;
    protected boolean[] enabledLevelFlags = null;
    protected boolean[] logFileLevelFlags = null;
    protected boolean[] stderrLevelFlags = null;
    File activeLogFile;
    PrintWriter logFileStream;
    PrintWriter stderrStream;
    private Hashtable logChannels = new Hashtable();
    static String separatorLine = "";

    public Log4jLogger(boolean makeCentral) {
        int level;
        for (level = 0; level <= 17; ++level) {
            String name = standardLevelNames[level];
            this.levelNumbers.put(name, new Integer(level));
            this.levelNames[level] = name;
        }
        this.numLevels = level;
        if (makeCentral) {
            centralLogger = this;
        }
    }

    private int getMaxLevel(String[] levels) {
        int maxLevelNum = 0;
        for (int idx = 0; idx < levels.length; ++idx) {
            int levelNum = this.getLevel(levels[idx]);
            if (levelNum <= maxLevelNum) continue;
            maxLevelNum = levelNum;
        }
        return maxLevelNum;
    }

    private boolean[] getLevelStateArray(String[] levels, int maxLevelNum) {
        boolean[] levelNums = new boolean[maxLevelNum + 1];
        for (int idx = 0; idx < levels.length; ++idx) {
            levelNums[this.getLevel((String)levels[idx])] = true;
        }
        return levelNums;
    }

    @Override
    public synchronized void configure(String log4jConfFile) throws ConfigException {
        try {
            DOMConfigurator.configure((String)log4jConfFile);
        }
        catch (FactoryConfigurationError fce) {
            throw new ConfigException("Cannot configure Log4jLogger:", fce);
        }
    }

    private static void configureLogger() {
        BasicConfigurator.configure();
        org.apache.log4j.Logger root = org.apache.log4j.Logger.getRootLogger();
        root.removeAllAppenders();
        LoggerRepository repository = root.getLoggerRepository();
        repository.setThreshold(Level.INFO);
        RollingFileAppender multiserverAppender = null;
        RollingFileAppender accessAppender = null;
        ConsoleAppender conAppender = null;
        String enhydraLogs = System.getProperty("enhydra.home") + File.separator + "logs" + File.separator;
        String multiserverLogFile = enhydraLogs + "multiserver.log";
        String accessLogFile = enhydraLogs + "access.log";
        try {
            multiserverAppender = new RollingFileAppender((Layout)new PatternLayout("%d{ISO8601}: [%t], %C(1) %p, %c: %m%n"), multiserverLogFile);
            accessAppender = new RollingFileAppender((Layout)new PatternLayout("%m%n"), accessLogFile);
            conAppender = new ConsoleAppender((Layout)new PatternLayout("%d{ISO8601}: [%t], %C(1) %p, %c: %m%n"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        root.addAppender(multiserverAppender);
        org.apache.log4j.Logger requestLogger = org.apache.log4j.Logger.getLogger((String)"REQUEST");
        requestLogger.setAdditivity(false);
        requestLogger.addAppender(accessAppender);
        org.apache.log4j.Logger sysOutLogger = org.apache.log4j.Logger.getLogger((String)"SysOut");
        sysOutLogger.setAdditivity(false);
        sysOutLogger.addAppender(conAppender);
    }

    private synchronized Log4jLogChannel createChannel(String facility) {
        Log4jLogChannel channel = (Log4jLogChannel)this.logChannels.get(facility);
        if (channel == null) {
            channel = new Log4jLogChannel(facility, org.apache.log4j.Logger.getLogger((String)facility));
            this.logChannels.put(facility, channel);
        }
        return channel;
    }

    @Override
    public LogChannel getChannel(String facility) {
        Log4jLogChannel channel = (Log4jLogChannel)this.logChannels.get(facility);
        if (channel == null) {
            channel = this.createChannel(facility);
        }
        return channel;
    }

    private synchronized Integer createLevel(String level) {
        Integer intLevel = (Integer)this.levelNumbers.get(level);
        if (intLevel == null) {
            intLevel = new Integer(this.numLevels);
            this.levelNames[this.numLevels] = level;
            this.levelNumbers.put(level, intLevel);
            ++this.numLevels;
        }
        return intLevel;
    }

    public synchronized int getLevel(String level) {
        Integer intLevel = (Integer)this.levelNumbers.get(level);
        if (intLevel == null) {
            intLevel = this.createLevel(level);
        }
        return intLevel;
    }

    public String getLevelName(int level) {
        if (level >= 0 && level < this.numLevels) {
            return this.levelNames[level];
        }
        return null;
    }

    @Override
    public void configure(Config logConfig) throws ConfigException {
        String fileName = null;
        if (logConfig.containsKey("Log4j")) {
            fileName = logConfig.getString("Log4j");
        } else if (null != logConfig.getConfigFile()) {
            fileName = logConfig.getConfigFile().getFile().getParent();
            if (null != fileName) {
                fileName = fileName + File.separator + "log4j.xml";
            }
        } else {
            throw new ConfigException("Cannot configure logger. Config file is null.");
        }
        if (logConfig.containsKey("SeparatorLine")) {
            separatorLine = logConfig.getString("SeparatorLine");
        }
        this.configure(fileName);
    }
}

