/*
 * Decompiled with CFR 0.152.
 */
package com.lutris.logging;

import com.lutris.logging.Log4jLogWriter;
import com.lutris.logging.Log4jLogger;
import com.lutris.logging.LogAdapter;
import com.lutris.logging.LogChannel;
import com.lutris.logging.LogWriter;
import java.text.SimpleDateFormat;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Log4jLogChannel
implements LogChannel {
    private String facility;
    private static final int INT_ERROR = -1;
    private static final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
    private Logger logger;

    protected Log4jLogChannel(String chanFacility, Logger loggerObj) {
        this.facility = chanFacility;
        this.logger = loggerObj;
    }

    @Override
    public int getLevel(String level) {
        if (this.logger != null && this.logger.getLevel() != null) {
            return this.logger.getLevel().toInt();
        }
        return -1;
    }

    @Override
    public boolean isEnabled(int level) {
        return true;
    }

    @Override
    public boolean isEnabled(String level) {
        return true;
    }

    @Override
    public void write(int level, String msg) {
        Level lev;
        if (this.logger == null) {
            this.logger = Logger.getLogger((String)LogAdapter.class.getName());
        }
        if ((lev = this.intToLevel(level)) == null) {
            lev = Level.INFO;
        }
        this.logger.log((Priority)lev, (Object)(msg + Log4jLogger.separatorLine));
    }

    @Override
    public void write(int level, String msg, Throwable throwable) {
        Level lev;
        if (this.logger == null) {
            this.logger = Logger.getLogger((String)LogAdapter.class.getName());
        }
        if ((lev = this.intToLevel(level)) == null) {
            lev = Level.INFO;
        }
        this.logger.log((Priority)lev, (Object)(msg + Log4jLogger.separatorLine), throwable);
    }

    @Override
    public void write(String level, String msg) {
        Level lev;
        if (this.logger == null) {
            this.logger = Logger.getLogger((String)LogAdapter.class.getName());
        }
        if ((lev = this.stringToLevel(level)) == null) {
            lev = Level.INFO;
        }
        this.logger.log((Priority)lev, (Object)(msg + Log4jLogger.separatorLine));
    }

    @Override
    public void write(String level, String msg, Throwable throwable) {
        Level lev;
        if (this.logger == null) {
            this.logger = Logger.getLogger((String)LogAdapter.class.getName());
        }
        if ((lev = this.stringToLevel(level)) == null) {
            lev = Level.INFO;
        }
        this.logger.log((Priority)lev, (Object)(msg + Log4jLogger.separatorLine), throwable);
    }

    private Level intToLevel(int level) {
        Level lev;
        switch (level) {
            case 0: 
            case 1: {
                lev = Level.FATAL;
                break;
            }
            case 2: 
            case 3: {
                lev = Level.ERROR;
                break;
            }
            case 4: {
                lev = Level.WARN;
                break;
            }
            case 5: 
            case 6: {
                lev = Level.INFO;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                lev = Level.DEBUG;
                break;
            }
            default: {
                lev = Level.DEBUG;
            }
        }
        return lev;
    }

    private Level stringToLevel(String level) {
        Level lev = level.equalsIgnoreCase("EMERGENCY") || level.equalsIgnoreCase("ALERT") ? Level.FATAL : (level.equalsIgnoreCase("CRITICAL") || level.equalsIgnoreCase("ERROR") ? Level.ERROR : (level.equalsIgnoreCase("WARNING") ? Level.WARN : (level.equalsIgnoreCase("NOTICE") || level.equalsIgnoreCase("INFO") ? Level.INFO : (level.equalsIgnoreCase("DEBUG") || level.equalsIgnoreCase("DEBUG1") || level.equalsIgnoreCase("DEBUG2") || level.equalsIgnoreCase("DEBUG3") || level.equalsIgnoreCase("DEBUG4") || level.equalsIgnoreCase("DEBUG5") || level.equalsIgnoreCase("DEBUG6") || level.equalsIgnoreCase("DEBUG7") || level.equalsIgnoreCase("DEBUG8") || level.equalsIgnoreCase("DEBUG9") || level.equalsIgnoreCase("DEBUGTMP") ? Level.DEBUG : Level.DEBUG))));
        return lev;
    }

    @Override
    public LogWriter getLogWriter(String level) {
        return new Log4jLogWriter((LogChannel)this, level);
    }

    @Override
    public LogWriter getLogWriter(int level) {
        return new Log4jLogWriter((LogChannel)this, level);
    }
}

