/*
 * Decompiled with CFR 0.152.
 */
package com.lutris.logging;

import com.lutris.logging.LogChannel;
import java.io.Writer;

class ChannelWriter
extends Writer {
    private StringBuffer buffer = new StringBuffer();
    private LogChannel channel;
    private int level;
    private boolean enabled;

    public ChannelWriter(LogChannel logChannel, int logLevel) {
        this.channel = logChannel;
        this.level = logLevel;
        this.enabled = logChannel.isEnabled(this.level);
    }

    @Override
    public void write(char[] cbuf, int off, int len) {
        this.buffer.append(cbuf, off, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        if (this.enabled && this.buffer.length() > 0) {
            Object object = this.lock;
            synchronized (object) {
                this.channel.write(this.level, this.buffer.toString());
                this.buffer.setLength(0);
            }
        }
    }

    @Override
    public void close() {
    }
}

