/*
 * Decompiled with CFR 0.152.
 */
package com.lutris.classloader;

import com.lutris.classloader.ClassPathEntry;
import com.lutris.classloader.Resource;
import com.lutris.logging.LogChannel;
import com.lutris.util.FatalExceptionError;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class LocalDirResource
extends Resource {
    private File file = null;

    protected LocalDirResource(String name, ClassPathEntry location, LogChannel loadLogChannel) throws FileNotFoundException {
        super(name, location, loadLogChannel);
        String locName = location.getName();
        if (locName == null) {
            throw new FileNotFoundException("The name for location, " + location + ", is null");
        }
        this.file = new File(locName, name);
        if (!this.file.exists() || !this.file.canRead()) {
            File tmpFile = this.file;
            this.file = null;
            throw new FileNotFoundException("File, " + tmpFile.getAbsolutePath() + ", does not exist or does not have read permission");
        }
        String path = null;
        String parentPath = null;
        try {
            parentPath = new File(locName).getCanonicalPath();
        }
        catch (IOException e) {
            this.file = null;
            throw new FileNotFoundException("Classpath Directory " + locName + " cannot be resolved: " + e.toString());
        }
        try {
            path = this.file.getCanonicalPath();
        }
        catch (IOException e) {
            File tmpFile = this.file;
            this.file = null;
            throw new FileNotFoundException("File " + tmpFile.getAbsolutePath() + " cannot be resolved: " + e.toString());
        }
        if (!path.startsWith(parentPath)) {
            File tmpFile = this.file;
            this.file = null;
            throw new FileNotFoundException("File, " + tmpFile + " does not live under " + locName);
        }
        this.size = this.file.length();
        this.lastModifiedTime = this.file.lastModified();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw new FatalExceptionError(e);
        }
    }

    @Override
    public long getCurrentLastModifiedTime() throws FileNotFoundException {
        return this.file.lastModified();
    }

    public File getFile() {
        return this.file;
    }
}

