// commented out ue to
// lack of class org.enhydra.xml.xmlc.XMLCLogger
/*
 * Enhydra Java Application Server Project
 * 
 * The contents of this file are subject to the Enhydra Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License on
 * the Enhydra web site ( http://www.enhydra.org/ ).
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See 
 * the License for the specific terms governing rights and limitations
 * under the License.
 * 
 * The Initial Developer of the Enhydra Application Server is Lutris
 * Technologies, Inc. The Enhydra Application Server and portions created
 * by Lutris Technologies, Inc. are Copyright Lutris Technologies, Inc.
 * All Rights Reserved.
 * 
 * Contributor(s):
 * 
 * $Id: EnhydraXMLCLogger.java,v 1.2 2005/03/24 10:51:20 slobodan Exp $
 */

package com.lutris.logging;


import org.enhydra.xml.xmlc.XMLCLogger;

/**
 * XMLC logger interface to PrintWriter streams.
 */
public class EnhydraXMLCLogger implements XMLCLogger {

  //underlying implementation
 private final com.lutris.logging.LogChannel m_logChannel;

    /**
     * Constructor specifing a single stream to be used for both info
     * and error logging.
     */
    public EnhydraXMLCLogger(LogChannel logChannel) {
        
        m_logChannel = logChannel;
    }

    /**
     * Determine if info logging is enabled.
     */
    public boolean infoEnabled() {
        return m_logChannel.isEnabled(Logger.INFO);
    }

    /**
     * Login an info message.
     */
    public void logInfo(String  msg) {
      m_logChannel.write( Logger.INFO, msg );      
    }

    /**
     * Login an info message with exception.
     */
    public void logInfo(String  msg,
                        Throwable  except) {
      m_logChannel.write( Logger.INFO, msg, except );                                 
    }

    /**
     * Determine if error logging is enabled.
     */
    public boolean errorEnabled() {
        return m_logChannel.isEnabled(Logger.ERROR);
    }

    /**
     * Login an error message.
     */
    public void logError(String  msg) {
      m_logChannel.write( Logger.ERROR, msg );      
    }

    /**
     * Login an error message with exception.
     */
    public void logError(String  msg,
                         Throwable  except) {
      m_logChannel.write( Logger.ERROR, msg, except );                                 
    }

    /**
     * Determine if debug logging is enabled.
     */
    public boolean debugEnabled() {
        return m_logChannel.isEnabled(Logger.DEBUG);
    }

    /**
     * Login an debug message.
     */
    public void logDebug(String  msg) {
      m_logChannel.write( Logger.DEBUG, msg );      
    }

    /**
     * Login an debug message with exception.
     */
    public void logDebug(String  msg,
                         Throwable  except) {
      m_logChannel.write( Logger.DEBUG, msg, except );                                 
    }

}
