/*
 * Decompiled with CFR 0.152.
 */
package com.lutris.appserver.server.sql.standard;

import com.lutris.appserver.server.sql.CachedDBTransaction;
import com.lutris.appserver.server.sql.CoreDO;
import com.lutris.appserver.server.sql.DBConnection;
import com.lutris.appserver.server.sql.DBQuery;
import com.lutris.appserver.server.sql.DBRowUpdateException;
import com.lutris.appserver.server.sql.StandardDatabaseManager;
import com.lutris.appserver.server.sql.Transaction;
import com.lutris.appserver.server.sql.standard.StandardDBQuery;
import com.lutris.appserver.server.sql.standard.StandardLogicalDatabase;
import com.lutris.dods.builder.generator.dataobject.GenericDO;
import com.lutris.dods.builder.generator.query.DataObjectException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Vector;
import org.enhydra.dods.DODS;
import org.enhydra.dods.cache.DOCache;
import org.enhydra.dods.cache.TransactionCacheImpl;
import org.enhydra.dods.cache.Wrapper;
import org.enhydra.dods.exceptions.CacheObjectException;

public class StandardDBTransaction
implements CachedDBTransaction {
    protected int id;
    protected static int nextId;
    protected DBConnection conn;
    protected boolean released = false;
    protected boolean _preventCacheQueries = false;
    protected Set<CoreDO> vecAlreadyHidden = new LinkedHashSet<CoreDO>();
    protected Vector vecExecutedTransaction = new Vector();
    protected Vector vecSortedTransaction = new Vector();
    protected HashMap hmpObjectTransaction = new HashMap();
    protected Transaction[] trans = new Transaction[0];
    protected int[] transAction = new int[0];
    protected int transIdx = 0;
    protected int dbLockCounter = 0;
    protected final int SIZE_DELTA = 10;
    protected final int CACHE_SIZE = -1;
    protected final int COMPLEX_QUERY_CACHE_SIZE = 0;
    protected final int SIMPLE_QUERY_CACHE_SIZE = 0;
    protected DOCache cache = null;
    protected Set<String> deletedRefs = null;
    protected static final int INSERT = 1;
    protected static final int UPDATE = 2;
    protected static final int DELETE = 3;
    protected boolean isTransactionCaches;
    protected boolean isAutoWrite = false;
    protected boolean sqlBatch;
    protected boolean firstWrite = true;
    protected static final int NONE = 0;
    protected String databaseName;
    private long lockWaitTime;
    private int lockRetryCount;
    protected boolean aggregateModifications = true;

    protected StandardDBTransaction(DBConnection conn) throws SQLException {
        try {
            this.firstWrite = true;
            this.id = nextId++;
            this.logDebug("new instance");
            this.conn = conn;
            this.conn.setAutoCommit(false);
            this.setDatabaseName(conn.getDatabaseName());
            this.readConfigValues();
            if (this.isTransactionCaches) {
                this.cache = new TransactionCacheImpl(0, 0);
            }
        }
        catch (SQLException sqlExcept) {
            this.conn.handleException(sqlExcept);
            this.conn.release();
            throw sqlExcept;
        }
        catch (CacheObjectException cacheExcept) {
            DODS.getLogChannel().write(3, "Error during transacion cache initialization");
        }
    }

    protected StandardDBTransaction() {
    }

    public synchronized Transaction getDO(Transaction transaction) {
        return this.getDO(transaction, 0);
    }

    public synchronized Transaction getDO(Transaction transaction, int action) {
        String strOID;
        CoreDO foundDO = null;
        if (transaction instanceof CoreDO && this.hmpObjectTransaction.containsKey(strOID = ((CoreDO)transaction).get_OId().toString()) && (action == 0 || ((DOAction)this.hmpObjectTransaction.get(strOID)).getAction() == action)) {
            foundDO = (CoreDO)((DOAction)this.hmpObjectTransaction.get(strOID)).getDO();
        }
        return foundDO;
    }

    private synchronized void add(Transaction transaction, int action) {
        if (transaction instanceof CoreDO) {
            DOAction doa;
            String strOID = ((CoreDO)transaction).get_OId().toString();
            int iDOAction = 0;
            if (this.aggregateModifications && this.vecSortedTransaction.size() > 0 && ((CoreDO)(doa = (DOAction)this.vecSortedTransaction.lastElement()).getDO()).get_OId().toString().equals(strOID)) {
                iDOAction = ((DOAction)this.vecSortedTransaction.lastElement()).getAction();
                if (iDOAction == 2 && (action == 1 || action == 2)) {
                    return;
                }
                if (iDOAction == 1 && (action == 1 || action == 2)) {
                    return;
                }
                if (iDOAction == 3 && action == 3) {
                    return;
                }
            }
            if (this.isAutoWrite && this.vecSortedTransaction.size() > 0) {
                try {
                    this.write();
                }
                catch (SQLException sqle) {
                    sqle.printStackTrace();
                }
            }
            DOAction objDOAction = new DOAction(transaction, action);
            this.hmpObjectTransaction.put(strOID, objDOAction);
            this.vecSortedTransaction.add(objDOAction);
        }
    }

    public void update(Transaction transaction) {
        this.add(transaction, 2);
        this.aggregateModifications = true;
    }

    public void delete(Transaction transaction) {
        this.add(transaction, 3);
        this.aggregateModifications = true;
    }

    public void insert(Transaction transaction) {
        this.add(transaction, 1);
        this.aggregateModifications = true;
    }

    public void commit() throws SQLException, DBRowUpdateException {
        int retryCount = this.lockRetryCount;
        long wrapperHandle = 0L;
        Vector vecDOclass = new Vector();
        this.logDebug("commit");
        this.validate();
        if (!this.wasReadOnly()) {
            try {
                this.conn.incrRequestCount();
                this.write();
                while (0L == (wrapperHandle = Wrapper.getInstance().lock())) {
                    try {
                        Thread.sleep(this.lockWaitTime);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (retryCount-- != 0) continue;
                    throw new SQLException("Can't wait anymore.");
                }
                this.makeHiddenDoEntities(vecDOclass);
                Wrapper.getInstance().makeSimpleComplexQCachesInvisible(vecDOclass);
                Wrapper.getInstance().makeMultiJoinQCachesInvisible();
                Wrapper.getInstance().unlock(wrapperHandle);
                wrapperHandle = 0L;
                this.conn.commit();
                this.transactionNotify(true);
                Wrapper.getInstance().removeAllMultiJoinQueries();
            }
            catch (SQLException sqlExcept) {
                this.handleException(sqlExcept);
                this.rollback();
                throw sqlExcept;
            }
            finally {
                if (retryCount >= 0) {
                    while (0L == (wrapperHandle = Wrapper.getInstance().lock())) {
                        try {
                            Thread.sleep(this.lockWaitTime);
                        }
                        catch (InterruptedException interruptedException) {}
                        if (--retryCount != 0) continue;
                        this.logDebug("spent " + this.lockRetryCount + " times " + this.lockWaitTime + "miliseconds, but musn't give up.");
                        retryCount = this.lockRetryCount;
                    }
                    this.makeVisibleDoEntities();
                    Wrapper.getInstance().makeSimpleComplexQCachesVisible(vecDOclass);
                    Wrapper.getInstance().makeMultiJoinQCachesVisible();
                    Wrapper.getInstance().unlock(wrapperHandle);
                }
                this.hmpObjectTransaction = new HashMap();
                this.vecSortedTransaction = new Vector();
                this.vecExecutedTransaction = new Vector();
                this.vecAlreadyHidden = new LinkedHashSet<CoreDO>();
                this._preventCacheQueries = false;
            }
        }
        this.logDebug("Nothing to write.");
    }

    private void makeHiddenDoEntities(Vector vecDOclass) {
        Enumeration e = this.vecExecutedTransaction.elements();
        while (e.hasMoreElements()) {
            CoreDO cdo = (CoreDO)((DOAction)e.nextElement()).getDO();
            Class<?> doClass = cdo.getClass();
            if (!vecDOclass.contains(doClass)) {
                vecDOclass.add(doClass);
            }
            if (!this.vecAlreadyHidden.add(cdo)) continue;
            cdo.makeInvisible();
        }
    }

    private void makeVisibleDoEntities() {
        for (CoreDO coreDO : this.vecAlreadyHidden) {
            coreDO.makeVisible();
        }
    }

    public void rollback() throws SQLException {
        try {
            this.logDebug("rollback");
            this.validate();
            this.conn.rollback();
            for (int iCounter = 0; iCounter < this.vecSortedTransaction.size(); ++iCounter) {
                try {
                    DOAction objDOAction = (DOAction)this.vecSortedTransaction.get(iCounter);
                    ((CoreDO)objDOAction.getDO()).refresh();
                    continue;
                }
                catch (DataObjectException dataExept) {
                    if (dataExept.getMessage().indexOf("DO not found for id") != -1) {
                        DOAction objDOAction = (DOAction)this.vecSortedTransaction.get(iCounter);
                        ((CoreDO)objDOAction.getDO()).evict();
                        continue;
                    }
                    SQLException g = new SQLException("INTERNAL ERROR: unexpected DataObjectException");
                    throw g;
                }
            }
        }
        catch (SQLException sqlExcept) {
            this.handleException(sqlExcept);
            throw sqlExcept;
        }
        finally {
            this.transactionNotify(false);
            this.hmpObjectTransaction = new HashMap();
            this.vecSortedTransaction = new Vector();
        }
    }

    private synchronized void transactionNotify(boolean succeeded) {
        block5: for (int iCounter = 0; iCounter < this.vecExecutedTransaction.size(); ++iCounter) {
            DOAction objDOAction = (DOAction)this.vecExecutedTransaction.get(iCounter);
            switch (objDOAction.getAction()) {
                case 1: {
                    objDOAction.getDO().finalizeInsert(succeeded);
                    continue block5;
                }
                case 2: {
                    objDOAction.getDO().finalizeUpdate(succeeded);
                    continue block5;
                }
                case 3: {
                    objDOAction.getDO().finalizeDelete(succeeded);
                }
            }
        }
    }

    public synchronized void release() {
        try {
            this.logDebug("release");
            if (!this.released) {
                if (this.vecExecutedTransaction.size() > 0) {
                    this.rollback();
                }
                this.conn.reset();
            }
        }
        catch (SQLException sqlExcept) {
            this.handleException(sqlExcept);
        }
        finally {
            if (this.conn != null) {
                this.conn.release();
            }
            this.conn = null;
            this.released = true;
            this.cache = null;
            this.hmpObjectTransaction = new HashMap();
            this.vecSortedTransaction = new Vector();
            this.vecExecutedTransaction = new Vector();
        }
    }

    public synchronized boolean handleException(SQLException e) {
        this.logDebug("handle exception");
        return this.conn.handleException(e);
    }

    protected void validate() throws SQLException {
        if (this.released) {
            throw new SQLException("Cannot access DBTransaction object once it has been released.");
        }
    }

    public boolean isReleased() {
        return this.released;
    }

    protected void finalize() {
        if (!this.released) {
            this.release();
        }
    }

    protected void logDebug(String str) {
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String dbName) {
        this.databaseName = dbName;
    }

    public CoreDO[] getDOs() {
        return (CoreDO[])this.vecSortedTransaction.toArray();
    }

    public void saveDirtyDOs() {
        throw new RuntimeException("NOT implemented, yet!");
    }

    public void write() throws SQLException, DBRowUpdateException {
        this.logDebug("write");
        this.validate();
        if (this.firstWrite) {
            this.firstWrite = false;
            if (this.conn.getConnection().isClosed()) {
                this.logDebug("Write failed, connection are closed by driver");
                throw new SQLException("Write failed, connection are closed by driver");
            }
        }
        try {
            PreparedStatement stmt = null;
            ArrayList<PreparedStatement> batch = new ArrayList<PreparedStatement>();
            int iCounter = 0;
            while (iCounter < this.vecSortedTransaction.size()) {
                DOAction objNextDOAction;
                DOAction objDOAction = (DOAction)this.vecSortedTransaction.get(iCounter);
                int action = objDOAction.getAction();
                CoreDO aDO = (CoreDO)objDOAction.getDO();
                if (this.vecSortedTransaction.size() > 1 && 3 == (objNextDOAction = (DOAction)this.vecSortedTransaction.get(1 + iCounter)).getAction() && aDO.get_OId().equals(((CoreDO)objNextDOAction.getDO()).get_OId())) {
                    if (!aDO.isPersistent()) {
                        this.vecSortedTransaction.remove(objNextDOAction);
                    }
                    this.vecSortedTransaction.remove(objDOAction);
                    continue;
                }
                switch (action) {
                    case 1: {
                        if (this.isSQLbatch()) {
                            if (aDO instanceof GenericDO && !((GenericDO)aDO).isDirty()) break;
                            stmt = aDO.isPersistent() ? aDO.getUpdateStatement(this.conn) : aDO.getInsertStatement(this.conn);
                            stmt.addBatch();
                            aDO.setPersistent(true);
                            if (batch.contains(stmt)) break;
                            batch.add(stmt);
                            break;
                        }
                        aDO.executeInsert(this.conn);
                        break;
                    }
                    case 2: {
                        if (this.isSQLbatch()) {
                            if (aDO instanceof GenericDO && !((GenericDO)aDO).isDirty()) break;
                            stmt = aDO.getUpdateStatement(this.conn);
                            stmt.addBatch();
                            if (batch.contains(stmt)) break;
                            batch.add(stmt);
                            break;
                        }
                        aDO.executeUpdate(this.conn);
                        break;
                    }
                    case 3: {
                        if (this.isSQLbatch()) {
                            stmt = aDO.getDeleteStatement(this.conn);
                            stmt.addBatch();
                            if (batch.contains(stmt)) break;
                            batch.add(stmt);
                            break;
                        }
                        aDO.executeDelete(this.conn);
                    }
                }
                this._preventCacheQueries = true;
                this.vecExecutedTransaction.add(objDOAction);
                this.vecSortedTransaction.remove(iCounter);
            }
            if (this.isSQLbatch()) {
                for (PreparedStatement element : batch) {
                    int[] affected = element.executeBatch();
                    element.clearBatch();
                    for (int _i = 0; _i < affected.length; ++_i) {
                        if (affected[_i] > 0) continue;
                        throw new DBRowUpdateException("batch failed for " + element + " returned " + affected[_i]);
                    }
                }
            }
        }
        catch (SQLException e) {
            this.logDebug("Write failed, there are " + this.vecSortedTransaction.size() + " DOs unwritten.");
            throw e;
        }
    }

    public DOCache getTransactionCache() {
        return this.cache;
    }

    private void setTransactionCache(DOCache transCache) {
        this.cache = transCache;
    }

    public Set<String> getDeletedDOs() {
        return this.deletedRefs;
    }

    public void addDeletedDO(CoreDO DO) {
        if (this.deletedRefs == null) {
            this.deletedRefs = new HashSet<String>();
        }
        String handle = null;
        if (DO.get_OId() != null) {
            handle = this.getDatabaseName() + "." + DO.get_OId();
            this.deletedRefs.add(handle);
        }
    }

    public void resetDeletedDOs() {
        if (this.deletedRefs != null) {
            this.deletedRefs = new HashSet<String>();
        }
    }

    public void lockDO(Transaction cdo) throws SQLException {
        ((CoreDO)cdo).executeLockingStatement(this.conn);
    }

    public boolean preventCacheQueries() {
        return this._preventCacheQueries;
    }

    public DBQuery createQuery() throws SQLException {
        StandardDBQuery sdbq = new StandardDBQuery(this.conn);
        sdbq.setReleaseConnection(false);
        return sdbq;
    }

    public void dontAggregateDOModifications() {
        this.aggregateModifications = false;
    }

    protected void readConfigValues() {
        try {
            this.isTransactionCaches = ((StandardLogicalDatabase)DODS.getDatabaseManager().findLogicalDatabase(this.getDatabaseName())).getDatabaseConfiguration().getTransactionCaches();
        }
        catch (Exception ex) {
            this.isTransactionCaches = ((StandardDatabaseManager)DODS.getDatabaseManager()).getDatabaseManagerConfiguration().getTransactionCaches();
        }
        try {
            this.lockWaitTime = ((StandardLogicalDatabase)DODS.getDatabaseManager().findLogicalDatabase(this.getDatabaseName())).getDatabaseConfiguration().getDeadlockWaitTime();
        }
        catch (Exception ex) {
            this.lockWaitTime = ((StandardDatabaseManager)DODS.getDatabaseManager()).getDatabaseManagerConfiguration().getDeadlockWaitTime();
        }
        try {
            this.lockRetryCount = ((StandardLogicalDatabase)DODS.getDatabaseManager().findLogicalDatabase(this.getDatabaseName())).getDatabaseConfiguration().getDeadlockRetryCount();
        }
        catch (Exception ex) {
            this.lockRetryCount = ((StandardDatabaseManager)DODS.getDatabaseManager()).getDatabaseManagerConfiguration().getDeadlockRetryCount();
        }
        try {
            this.isAutoWrite = ((StandardLogicalDatabase)DODS.getDatabaseManager().findLogicalDatabase(this.getDatabaseName())).getDatabaseConfiguration().getAutoWrite();
        }
        catch (Exception ex) {
            this.isAutoWrite = ((StandardDatabaseManager)DODS.getDatabaseManager()).getDatabaseManagerConfiguration().getAutoWrite();
        }
        try {
            this.sqlBatch = ((StandardLogicalDatabase)DODS.getDatabaseManager().findLogicalDatabase(this.getDatabaseName())).getDatabaseConfiguration().isSqlBatch();
        }
        catch (Exception ex) {
            this.sqlBatch = ((StandardDatabaseManager)DODS.getDatabaseManager()).getDatabaseManagerConfiguration().isSqlBatch();
        }
    }

    public boolean getAutoWrite() {
        return this.isAutoWrite;
    }

    public boolean isSQLbatch() {
        return this.sqlBatch;
    }

    public boolean isFirstWrite() {
        return this.firstWrite;
    }

    public void setFirstWrite(boolean newfw) {
        this.firstWrite = newfw;
    }

    public boolean wasReadOnly() {
        return 0 == this.vecExecutedTransaction.size() + this.vecSortedTransaction.size();
    }

    protected class DOAction {
        private Transaction transDO;
        private int iAction;

        public DOAction(Transaction transDOIn, int iActionIn) {
            this.transDO = transDOIn;
            this.iAction = iActionIn;
        }

        public Transaction getDO() {
            return this.transDO;
        }

        public int getAction() {
            return this.iAction;
        }

        public void setAction(int action) {
            this.iAction = action;
        }

        public boolean equals(Object o) {
            return o instanceof DOAction && this.iAction == ((DOAction)o).iAction && this.transDO.equals(((DOAction)o).transDO);
        }
    }
}

