/*
 * Decompiled with CFR 0.152.
 */
package com.lutris.appserver.server.sql.standard;

import com.lutris.appserver.server.sql.AbstractDBConnectionFactory;
import com.lutris.appserver.server.sql.ConnectionAllocator;
import com.lutris.appserver.server.sql.DBConnection;
import com.lutris.appserver.server.sql.ExtendedConnectionAllocator;
import com.lutris.appserver.server.sql.ExtendedDBConnection;
import com.lutris.appserver.server.sql.LogicalDatabase;
import com.lutris.appserver.server.sql.SimpleDBConnectionFactory;
import com.lutris.util.Config;
import com.lutris.util.ConfigException;
import com.lutris.util.KeywordValueException;
import java.sql.SQLException;
import java.util.Date;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.enhydra.dods.DODS;

public class SimpleConnectionAllocator
implements ExtendedConnectionAllocator {
    protected LogicalDatabase logicalDatabase = null;
    protected String url;
    protected String user;
    protected String password;
    protected String shutDownStr;
    private int maxPoolSize;
    private int currentPoolSize;
    private long connectionIdileTimeout = -1L;
    private int biggestPoolSize;
    private Date biggestPoolDate;
    protected long numRequests;
    private LinkedList pool;
    private Hashtable connectionUsageCounter;
    protected int maxWaitingConnections;
    private int maxConnectionUsages = -1;
    protected boolean sqlLogging;
    private int timeOut;
    protected int queryTimeOut;
    protected int transactionTimeOut;
    protected int maxPreparedStatements;
    protected int generation = 1;
    private AbstractDBConnectionFactory dbConnectionFactory = null;
    private String dbConnectionFactoryName = null;

    protected DBConnection createConnection() throws SQLException {
        DBConnection dbConnection = this.dbConnectionFactory.createConnection((ConnectionAllocator)this, this.url, this.user, this.password, this.maxPreparedStatements, this.sqlLogging, this.generation);
        return dbConnection;
    }

    private AbstractDBConnectionFactory createDBConnectionFactory(String factoryName) {
        Class<?> connectionFactoryClass = null;
        Object connectionFactoryConstructor = null;
        Class[] methodTypes = new Class[]{};
        Object[] methodArgs = new Object[]{};
        SimpleDBConnectionFactory factory = null;
        if (factoryName != null) {
            try {
                connectionFactoryClass = Class.forName(factoryName);
                factory = (AbstractDBConnectionFactory)connectionFactoryClass.newInstance();
            }
            catch (Exception e) {
                DODS.getLogChannel().write(6, "Faild to make Connection Factory :" + factoryName + " creating StandardDBConnectionFactory insted");
                factory = null;
            }
        }
        if (factoryName == null || factory == null) {
            factory = new SimpleDBConnectionFactory();
        }
        return factory;
    }

    public SimpleConnectionAllocator(LogicalDatabase logicalDatabase, Config conConfig) throws ConfigException {
        this.logicalDatabase = logicalDatabase;
        try {
            this.url = conConfig.getString("Url");
            this.user = conConfig.getString("User");
            this.password = conConfig.getString("Password");
            this.timeOut = conConfig.getInt("AllocationTimeout", 1000);
            this.maxPoolSize = conConfig.getInt("MaxPoolSize", 0);
            this.sqlLogging = conConfig.getBoolean("Logging", false);
            this.queryTimeOut = conConfig.getInt("QueryTimeout", 0);
            this.transactionTimeOut = conConfig.getInt("TransactionTimeout", 0);
            this.connectionIdileTimeout = conConfig.getLong("ConnectionIdleTimeout", -1L);
            this.shutDownStr = conConfig.getString("ShutDownString", null);
            this.maxPreparedStatements = conConfig.getInt("MaxPreparedStatements", -1);
            this.maxConnectionUsages = conConfig.getInt("MaxConnectionUsages", -1);
            this.maxWaitingConnections = conConfig.getInt("MaxWaitingConnections", Integer.MAX_VALUE);
            this.dbConnectionFactoryName = conConfig.getString("ConnectionFactory", null);
            this.dbConnectionFactory = this.createDBConnectionFactory(this.dbConnectionFactoryName);
        }
        catch (KeywordValueException except) {
            throw new ConfigException("Bad DatabaseManager.DB." + logicalDatabase.getName() + ".Connection section defined in config file.");
        }
        this.currentPoolSize = 0;
        this.pool = new LinkedList();
        if (this.maxConnectionUsages > 0) {
            this.connectionUsageCounter = new Hashtable();
        }
        this.biggestPoolSize = 0;
        this.biggestPoolDate = new Date();
        this.numRequests = 0L;
    }

    public synchronized DBConnection allocate() throws SQLException {
        boolean createNewConn = true;
        DBConnection conn = null;
        while (conn == null) {
            while (this.pool.isEmpty()) {
                if (createNewConn && (this.currentPoolSize < this.maxPoolSize || this.maxPoolSize <= 0)) {
                    try {
                        DBConnection newConnection = this.createConnection();
                        if (this.connectionUsageCounter != null) {
                            this.connectionUsageCounter.put(newConnection, new Integer(this.maxConnectionUsages));
                        }
                        this.pool.addLast(newConnection);
                        ++this.currentPoolSize;
                        if (this.currentPoolSize <= this.biggestPoolSize) continue;
                        this.biggestPoolSize = this.currentPoolSize;
                        this.biggestPoolDate = new Date();
                        continue;
                    }
                    catch (SQLException e) {
                        if (this.currentPoolSize > 0) {
                            DODS.getLogChannel().write(6, "ConnectionAllocator: failed to allocate a new connection due to" + e.toString() + "Error code: " + e.getErrorCode() + "\nSQLState: " + e.getSQLState() + "\n\nCurrent pool size is: " + this.currentPoolSize + "\nMaximum configured pool size is now " + this.maxPoolSize + "\nContinuing...\n");
                            createNewConn = false;
                            continue;
                        }
                        DODS.getLogChannel().write(0, "ConnectionAllocator: failed to allocate a new connection\nThe connection pool is empty!\n");
                        throw e;
                    }
                }
                try {
                    if (this.timeOut > 0) {
                        this.wait(this.timeOut);
                        if (!this.pool.isEmpty()) continue;
                        DODS.getLogChannel().write(0, "ConnectionAllocator: allocation of a new connection timed out.Possible dead lock avoided.");
                        String msg = "Connections are currently unavailable.\nPossible dead lock avoided.";
                        throw new SQLException(msg);
                    }
                    this.wait();
                }
                catch (InterruptedException msg) {}
            }
            try {
                conn = (DBConnection)this.pool.removeFirst();
            }
            catch (NoSuchElementException msg) {
                // empty catch block
            }
            if (this.connectionUsageCounter != null) {
                Integer connUsages = (Integer)this.connectionUsageCounter.get(conn);
                if (connUsages != null && connUsages > 0) {
                    this.connectionUsageCounter.put(conn, new Integer(connUsages - 1));
                } else {
                    conn.close();
                    --this.currentPoolSize;
                    this.connectionUsageCounter.remove(conn);
                    DODS.getLogChannel().write(7, "ConnectionAllocator: connection closed due to usage counter. currentPoolSize=" + this.currentPoolSize + "\n");
                    conn = null;
                }
            }
            if (conn != null && conn.getConnection().isClosed()) {
                conn.close();
                --this.currentPoolSize;
                if (this.connectionUsageCounter != null && this.connectionUsageCounter.contains(conn)) {
                    this.connectionUsageCounter.remove(conn);
                }
                DODS.getLogChannel().write(7, "ConnectionAllocator: Inactiv connection closed due allocate() operation. Geting new one. currentPoolSize=" + this.currentPoolSize + "\n");
                conn = null;
            }
            if (conn == null || this.connectionIdileTimeout <= 0L || System.currentTimeMillis() - ((ExtendedDBConnection)conn).getConnectionEnterPoolTime() <= this.connectionIdileTimeout) continue;
            conn.close();
            --this.currentPoolSize;
            DODS.getLogChannel().write(7, "ConnectionAllocator: Connection closed due allocate() operation - long connection idile time. Geting new one. currentPoolSize=" + this.currentPoolSize + "\n");
            conn = null;
        }
        conn.allocate();
        return conn;
    }

    public synchronized void release(DBConnection dbConnection) {
        try {
            if (dbConnection.getGeneration() < this.generation || dbConnection.isMarkedForDrop() || dbConnection.getConnection().isClosed() || this.pool.size() >= this.maxWaitingConnections) {
                dbConnection.close();
                dbConnection = null;
                --this.currentPoolSize;
            } else {
                if (this.connectionIdileTimeout > 0L) {
                    ((ExtendedDBConnection)dbConnection).setConnectionEnterPoolTime(System.currentTimeMillis());
                }
                this.pool.addLast(dbConnection);
            }
        }
        catch (SQLException ex) {
            DODS.getLogChannel().write(7, "Eror relasing connection");
        }
        this.notify();
    }

    public synchronized void drop(DBConnection dbConnection) {
        if (this.generation <= dbConnection.getGeneration()) {
            ++this.generation;
        }
        LinkedList<DBConnection> newPool = new LinkedList<DBConnection>();
        try {
            while (!this.pool.isEmpty()) {
                DBConnection connect = (DBConnection)this.pool.removeFirst();
                if (connect.getGeneration() < this.generation) {
                    connect.close();
                    --this.currentPoolSize;
                    continue;
                }
                newPool.addLast(connect);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.pool = newPool;
        this.notify();
    }

    public synchronized void dropAllNow() {
        if (this.shutDownStr != null) {
            try {
                DBConnection tmpConn = this.allocate();
                tmpConn.execute(this.shutDownStr);
                tmpConn.release();
            }
            catch (SQLException tmpConn) {
                // empty catch block
            }
        }
        try {
            while (!this.pool.isEmpty()) {
                DBConnection connect = (DBConnection)this.pool.removeFirst();
                connect.close();
                --this.currentPoolSize;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public int getActiveCount() {
        return this.currentPoolSize;
    }

    public int getMaxCount() {
        return this.biggestPoolSize;
    }

    public Date getMaxCountDate() {
        return this.biggestPoolDate;
    }

    public void resetMaxCount() {
        this.biggestPoolSize = this.currentPoolSize;
        this.biggestPoolDate = new Date();
    }

    public long getRequestCount() {
        return this.numRequests;
    }

    protected void finalize() {
        this.dropAllNow();
    }

    public String getDatabaseName() {
        return this.logicalDatabase.getName();
    }

    public void IncrementRequesteCount() {
        ++this.numRequests;
    }
}

