/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.dods.cache.base;

import com.lutris.appserver.server.sql.DatabaseManagerException;
import com.lutris.appserver.server.sql.standard.StandardLogicalDatabase;
import org.enhydra.dods.DODS;
import org.enhydra.dods.cache.base.DODSCache;
import org.enhydra.dods.cache.base.DODSCacheAbstractFactory;

public class BaseCacheManager {
    private static DODSCacheAbstractFactory cacheFactory = null;

    public static boolean isCacheManagerConfigured() {
        return cacheFactory != null;
    }

    private static void configureCacheFactory() {
        block7: {
            String logicalDbName = null;
            String cacheFactoryClassName = null;
            Class<?> cacheFactoryClass = null;
            try {
                logicalDbName = DODS.getDatabaseManager().getDefaultDB();
                cacheFactoryClassName = ((StandardLogicalDatabase)DODS.getDatabaseManager().findLogicalDatabase(logicalDbName)).getDatabaseConfiguration().getDodsCacheFactory();
                if (cacheFactoryClassName != null) {
                    try {
                        cacheFactoryClass = Class.forName(cacheFactoryClassName);
                        cacheFactory = (DODSCacheAbstractFactory)cacheFactoryClass.newInstance();
                    }
                    catch (Exception e) {
                        DODS.getLogChannel().write(3, "Failed to make DODSCacheFactory  :" + cacheFactoryClassName + " creating " + "org.enhydra.dods.cache.lru.DODSLRUCacheFactory" + " instead");
                        cacheFactory = null;
                    }
                }
                if (cacheFactoryClassName != null && cacheFactory != null) break block7;
                try {
                    cacheFactoryClass = Class.forName("org.enhydra.dods.cache.lru.DODSLRUCacheFactory");
                    cacheFactory = (DODSCacheAbstractFactory)cacheFactoryClass.newInstance();
                }
                catch (Exception e) {
                    String str = "Failed to make org.enhydra.dods.cache.lru.DODSLRUCacheFactory";
                    DODS.getLogChannel().write(2, str);
                    throw new Error(str);
                }
            }
            catch (DatabaseManagerException e) {
                DODS.getLogChannel().write(2, "Failed to make DODSCacheFactory - CRITICAL ERROR");
            }
        }
    }

    public static DODSCache getDODSCache(int maxSize) {
        if (!BaseCacheManager.isCacheManagerConfigured()) {
            BaseCacheManager.configureCacheFactory();
        }
        return cacheFactory.newDODSCache(maxSize);
    }
}

