/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.dods.cache;

import com.lutris.appserver.server.sql.CoreDataStruct;
import com.lutris.appserver.server.sql.standard.DatabaseConfiguration;
import com.lutris.appserver.server.sql.standard.StandardLogicalDatabase;
import com.lutris.util.Config;
import java.util.HashMap;
import java.util.Map;
import org.enhydra.dods.DODS;
import org.enhydra.dods.cache.CacheAdministration;
import org.enhydra.dods.cache.DataStructCache;
import org.enhydra.dods.cache.TableConfiguration;
import org.enhydra.dods.cache.base.BaseCacheManager;
import org.enhydra.dods.cache.base.DODSCache;
import org.enhydra.dods.exceptions.CacheObjectException;
import org.enhydra.dods.statistics.CacheStatistics;
import org.enhydra.dods.statistics.Statistics;
import org.enhydra.dods.statistics.TableStatistics;

public class DataStructCacheImpl
extends DataStructCache {
    protected DODSCache cache = null;
    protected CacheAdministration cacheAdministration = null;
    protected TableConfiguration tableConf = new TableConfiguration();
    protected String initialQueryCache = null;
    protected boolean multi = false;
    protected boolean fullCachingOn = false;
    protected Statistics statistics = null;
    protected HashMap nonVisibleList = null;
    protected double reserveFactor = 0.0;
    protected double cachePercentage = -1.0;
    private boolean isDisabled = false;
    private int disabledMaxCacheSize = 0;
    private int initialCacheFetchSize = 0;
    private int initialDSCacheSize = -1;

    public DataStructCacheImpl(int maxCSize) throws CacheObjectException {
        if (this.isDisabled) {
            throw new CacheObjectException("Caching is disabled");
        }
        this.cache = BaseCacheManager.getDODSCache(maxCSize);
        this.statistics = new DataStructCacheImplStatistics();
        this.nonVisibleList = new HashMap();
        this.init();
    }

    public DataStructCacheImpl() throws CacheObjectException {
        this(0);
    }

    public CacheAdministration getCacheAdministration(int cacheType) {
        return this.cacheAdministration;
    }

    public String getInitialQueryCache() {
        return this.initialQueryCache;
    }

    protected void setInitialQueryCache(String initQ) {
        this.initialQueryCache = initQ;
    }

    public void makeInvisible(String cacheHandle) {
        Integer intObj = (Integer)this.nonVisibleList.get(cacheHandle);
        if (intObj != null) {
            int num = intObj;
            this.nonVisibleList.put(cacheHandle, new Integer(++num));
        } else {
            this.nonVisibleList.put(cacheHandle, new Integer(1));
        }
    }

    public void makeVisible(String cacheHandle) {
        Integer intObj = (Integer)this.nonVisibleList.get(cacheHandle);
        if (intObj != null) {
            int num = intObj;
            if (--num == 0) {
                this.nonVisibleList.remove(cacheHandle);
            } else {
                this.nonVisibleList.put(cacheHandle, new Integer(num));
            }
        }
    }

    public Statistics getStatistics() {
        this.statistics.stopTime();
        return this.statistics;
    }

    public void refreshStatistics() {
        this.statistics.clear();
    }

    public void checkFull() {
        this.fullCachingOn = this.cacheAdministration.getMaxCacheSize() < 0 && this.getInitialQueryCache() != null && this.getInitialQueryCache().equals("*");
    }

    public boolean isFull() {
        if (this.fullCachingOn) {
            this.checkFull();
        }
        return this.fullCachingOn;
    }

    public String getCacheType() {
        if (this.cacheAdministration.getMaxCacheSize() == 0) {
            return "none";
        }
        if (this.isFull()) {
            return "full";
        }
        return "lru";
    }

    public int getLevelOfCaching() {
        return 1;
    }

    public TableConfiguration getTableConfiguration() {
        return this.tableConf;
    }

    public double getReserveFactor() {
        return 0.0;
    }

    protected void setReserveFactor(double res) {
    }

    protected void setCachePercentage(double percent) {
        this.cachePercentage = percent;
    }

    public double getCachePercentage() {
        return this.cachePercentage;
    }

    public boolean isDisabled() {
        return this.isDisabled;
    }

    public void readConfiguration(Config tableConfig, Config cacheConfig, String dbName) throws CacheObjectException {
        DatabaseConfiguration dbConf;
        if (this.isDisabled) {
            throw new CacheObjectException("Caching is disabled");
        }
        int maxSize = 0;
        boolean initialAllCaches = false;
        Object defaultCacheConfig = null;
        this.tableConf.readTableConfiguration(tableConfig, dbName);
        try {
            dbConf = ((StandardLogicalDatabase)DODS.getDatabaseManager().findLogicalDatabase(dbName)).getDatabaseConfiguration();
        }
        catch (Exception ex) {
            throw new CacheObjectException("Error reading database configuration");
        }
        if (dbConf != null) {
            try {
                maxSize = dbConf.getMaxCacheSize();
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                this.reserveFactor = dbConf.getReserveFactor();
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                this.cachePercentage = dbConf.getCachePercentage();
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                initialAllCaches = dbConf.getInitAllCaches();
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                this.initialCacheFetchSize = dbConf.getInitialCacheFetchSize();
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                this.initialDSCacheSize = dbConf.getInitialDSCacheSize();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (cacheConfig != null) {
            block31: {
                try {
                    maxSize = cacheConfig.getInt("maxCacheSize");
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    this.initialQueryCache = cacheConfig.getString("initialCondition");
                }
                catch (Exception e) {
                    if (!initialAllCaches) break block31;
                    this.initialQueryCache = "*";
                }
            }
            try {
                this.reserveFactor = cacheConfig.getDouble("reserveFactor");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.cachePercentage = cacheConfig.getDouble("CachePercentage");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.initialCacheFetchSize = cacheConfig.getInt("InitialCacheFetchSize");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.initialDSCacheSize = cacheConfig.getInt("InitialDSCacheSize");
            }
            catch (Exception exception) {}
        } else if (initialAllCaches) {
            this.initialQueryCache = "*";
        }
        this.cacheAdministration.setMaxCacheSize(maxSize);
    }

    public DataStructCache newInstance() throws CacheObjectException {
        if (this.isDisabled) {
            throw new CacheObjectException("Caching is disabled");
        }
        return new DataStructCacheImpl();
    }

    protected void init() {
        this.cacheAdministration = new CacheAdministration(){

            public int getMaxCacheSize() {
                if (DataStructCacheImpl.this.cache != null) {
                    return DataStructCacheImpl.this.cache.getMaxEntries();
                }
                return 0;
            }

            public int getMaxCacheSize(boolean real) {
                int size = this.getMaxCacheSize();
                if (size < 0) {
                    if (real) {
                        return -1;
                    }
                    return this.getCacheSize();
                }
                return size;
            }

            public int getCacheSize() {
                if (DataStructCacheImpl.this.cache != null) {
                    return DataStructCacheImpl.this.cache.size();
                }
                return 0;
            }

            protected void setMaxCacheSize(int maxSize) throws CacheObjectException {
                if (DataStructCacheImpl.this.isDisabled) {
                    throw new CacheObjectException("Caching is disabled");
                }
                if (maxSize == 0) {
                    DataStructCacheImpl.this.cache = null;
                    DataStructCacheImpl.this.statistics.clear();
                    return;
                }
                if (DataStructCacheImpl.this.cache == null) {
                    DataStructCacheImpl.this.cache = BaseCacheManager.getDODSCache(maxSize);
                } else {
                    DataStructCacheImpl.this.cache.setMaxEntries(maxSize);
                }
            }

            public void refresh() {
                if (DataStructCacheImpl.this.cache != null) {
                    DataStructCacheImpl.this.cache = BaseCacheManager.getDODSCache(DataStructCacheImpl.this.cache.getMaxEntries());
                    DataStructCacheImpl.this.statistics.clear();
                }
            }

            public void disable() {
                if (!DataStructCacheImpl.this.isDisabled) {
                    DataStructCacheImpl.this.isDisabled = true;
                    if (DataStructCacheImpl.this.cache != null) {
                        DataStructCacheImpl.this.disabledMaxCacheSize = DataStructCacheImpl.this.cache.getMaxEntries();
                        DataStructCacheImpl.this.statistics.clear();
                    }
                }
            }

            public void enable() {
                if (DataStructCacheImpl.this.isDisabled) {
                    if (DataStructCacheImpl.this.disabledMaxCacheSize != 0) {
                        DataStructCacheImpl.this.cache = BaseCacheManager.getDODSCache(DataStructCacheImpl.this.disabledMaxCacheSize);
                    }
                    DataStructCacheImpl.this.statistics.clear();
                    DataStructCacheImpl.this.isDisabled = false;
                }
            }
        };
    }

    public Map getCacheContent() {
        return this.cache;
    }

    public boolean isMulti() {
        return this.multi;
    }

    public boolean toReconfigure() {
        return false;
    }

    public synchronized CoreDataStruct addDataStruct(CoreDataStruct newDS) {
        if (this.cache == null) {
            return newDS;
        }
        try {
            String handle = newDS.get_CacheHandle();
            this.cache.add(handle, newDS);
            return newDS;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public synchronized CoreDataStruct removeDataStruct(CoreDataStruct data) {
        if (this.cache != null) {
            try {
                String handle = data.get_CacheHandle();
                return (CoreDataStruct)this.cache.remove(handle);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public synchronized CoreDataStruct removeDataStruct(String handle) {
        if (this.cache != null) {
            try {
                return (CoreDataStruct)this.cache.remove(handle);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public CoreDataStruct updateDataStruct(CoreDataStruct data) {
        data = this.addDataStruct(data);
        return data;
    }

    public CoreDataStruct deleteDataStruct(CoreDataStruct data) {
        CoreDataStruct oldData = this.removeDataStruct(data);
        return oldData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoreDataStruct getDataStructByHandle(String handle) {
        if (this.cache == null) {
            return null;
        }
        CoreDataStruct cdt = null;
        if (this.cache.isNeedToSynchronize()) {
            DODSCache dODSCache = this.cache;
            synchronized (dODSCache) {
                cdt = this.getDataCacheItem(handle, cdt);
            }
        } else {
            cdt = this.getDataCacheItem(handle, cdt);
        }
        return cdt;
    }

    private CoreDataStruct getDataCacheItem(String handle, CoreDataStruct cdt) {
        if (!this.nonVisibleList.containsKey(handle)) {
            cdt = (CoreDataStruct)this.cache.get(handle);
        }
        return cdt;
    }

    public void show() {
        System.out.println("-------------------------------------------------");
        System.out.println(" maxCacheSize : " + this.cache.getMaxEntries());
        System.out.println(" cacheReadOnly : " + this.tableConf.isReadOnly());
        System.out.println(" initialQueryCache : " + this.initialQueryCache);
        System.out.println(" fullCaching : " + this.isFull());
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("\n DataStructCacheImpl: ");
        ret.append("\n cacheReadOnly : " + this.tableConf.isReadOnly());
        ret.append("\n initialQueryCache : " + this.initialQueryCache);
        ret.append("\n fullCaching : " + this.isFull());
        return ret.toString();
    }

    public int getInitialCacheFetchSize() {
        return this.initialCacheFetchSize;
    }

    public int getInitialDSCacheSize() {
        return this.initialDSCacheSize;
    }

    public void setInitialCacheFetchSize(int i) {
        this.initialCacheFetchSize = i;
    }

    public void setInitialDSCacheSize(int i) {
        this.initialDSCacheSize = i;
    }

    class DataStructCacheImplStatistics
    extends TableStatistics {
        public int getStatisticsType() {
            return 1;
        }

        public CacheStatistics getCacheStatistics(int type) {
            switch (type) {
                case 0: {
                    return DataStructCacheImpl.this.cache;
                }
            }
            return null;
        }
    }
}

