/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.dods.cache.lru;

import org.enhydra.dods.cache.base.DODSCache;
import org.enhydra.dods.cache.lru.LRUCache;

public class DODSLRUCache
extends LRUCache
implements DODSCache {
    protected int cacheAccessNum = 0;
    protected int cacheHitsNum = 0;

    DODSLRUCache(int maxSize) {
        super(maxSize);
        this.clearStatistics();
    }

    public int getCacheAccessNum() {
        return this.cacheAccessNum;
    }

    public void setCacheAccessNum(int num) {
        this.cacheAccessNum = num;
    }

    public void incrementCacheAccessNum(int num) {
        this.cacheAccessNum += num;
    }

    public int getCacheHitsNum() {
        return this.cacheHitsNum;
    }

    public void setCacheHitsNum(int cacheHitsNum) {
        this.cacheHitsNum = cacheHitsNum;
    }

    public void incrementCacheHitsNum(int num) {
        this.cacheHitsNum += num;
    }

    public double getUsedPercents() {
        int maxCacheSize = this.maxEntries;
        if (maxCacheSize == 0) {
            return 0.0;
        }
        if (maxCacheSize < 0) {
            return 100.0;
        }
        int temp = this.size() * 10000;
        double res = temp / maxCacheSize;
        return res / 100.0;
    }

    public double getCacheHitsPercents() {
        if (this.cacheAccessNum == 0) {
            return 0.0;
        }
        int temp = this.cacheHitsNum * 10000;
        double res = temp / this.cacheAccessNum;
        return res / 100.0;
    }

    public void clearStatistics() {
        this.cacheAccessNum = 0;
        this.cacheHitsNum = 0;
    }

    @Override
    public boolean isNeedToSynchronize() {
        return true;
    }
}

