/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.dods.cache;

import com.lutris.appserver.server.sql.CoreDataStruct;
import com.lutris.appserver.server.sql.DatabaseManagerException;
import com.lutris.appserver.server.sql.standard.DatabaseConfiguration;
import com.lutris.appserver.server.sql.standard.StandardLogicalDatabase;
import com.lutris.util.Config;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.enhydra.dods.DODS;
import org.enhydra.dods.cache.CacheAdministration;
import org.enhydra.dods.cache.DataStructCache;
import org.enhydra.dods.cache.QueryCache;
import org.enhydra.dods.cache.QueryCacheItem;
import org.enhydra.dods.cache.QueryCacheItemImpl;
import org.enhydra.dods.cache.QueryResult;
import org.enhydra.dods.cache.TableConfiguration;
import org.enhydra.dods.cache.base.BaseCacheManager;
import org.enhydra.dods.cache.base.DODSCache;
import org.enhydra.dods.exceptions.CacheObjectException;
import org.enhydra.dods.statistics.CacheStatistics;
import org.enhydra.dods.statistics.Statistics;
import org.enhydra.dods.statistics.TableStatistics;

public class QueryCacheImpl
extends QueryCache {
    protected DODSCache cache = null;
    protected DODSCache simpleQCache = null;
    protected DODSCache complexQCache = null;
    protected DODSCache multiJoinQCache = null;
    protected CacheAdministration[] cacheAdministration = new CacheAdministration[4];
    protected TableConfiguration tableConf = new TableConfiguration();
    protected String initialQueryCache = null;
    protected boolean multi = false;
    protected boolean fullCachingOn = false;
    protected Statistics statistics = null;
    protected HashMap nonVisibleList = null;
    protected int oldSimpleMaxCacheSize;
    protected int oldComplexMaxCacheSize;
    protected int oldMultiJoinMaxCacheSize;
    protected double reserveFactor = 0.0;
    private boolean isDisabled = false;
    private boolean isDisabledSimple = false;
    private boolean isDisabledComplex = false;
    private boolean isDisabledMultiJoin = false;
    private double cachePercentage = -1.0;
    private int initialCacheFetchSize = 0;
    private int initialDSCacheSize = -1;
    private int disabledMaxCacheSize = 0;
    private int disabledMaxSimpleQueryCacheSize = 0;
    private int disabledMaxComplexQueryCacheSize = 0;
    private int disabledMaxMultiJoinQueryCacheSize = 0;

    public QueryCacheImpl(int maxCSize) throws CacheObjectException {
        if (this.isDisabled) {
            throw new CacheObjectException("Caching is disabled");
        }
        this.cache = BaseCacheManager.getDODSCache(maxCSize);
        if (this.cache != null) {
            this.simpleQCache = BaseCacheManager.getDODSCache(0);
            this.complexQCache = BaseCacheManager.getDODSCache(0);
            this.multiJoinQCache = BaseCacheManager.getDODSCache(0);
        }
        this.statistics = new QueryCacheImplStatistics();
        this.nonVisibleList = new HashMap();
        this.init();
    }

    public QueryCacheImpl() throws CacheObjectException {
        this(0);
    }

    public CacheAdministration getCacheAdministration(int cacheType) {
        if (cacheType < 0 || cacheType > 3) {
            return null;
        }
        return this.cacheAdministration[cacheType];
    }

    public String getInitialQueryCache() {
        return this.initialQueryCache;
    }

    protected void setInitialQueryCache(String initQ) {
        this.initialQueryCache = initQ;
    }

    public void makeInvisible(String cacheHandle) {
        if (this.getCacheAdministration(0).getMaxCacheSize() != 0) {
            Integer intObj = (Integer)this.nonVisibleList.get(cacheHandle);
            if (intObj != null) {
                int num = intObj;
                this.nonVisibleList.put(cacheHandle, new Integer(++num));
            } else {
                this.nonVisibleList.put(cacheHandle, new Integer(1));
            }
        }
    }

    public void makeVisible(String cacheHandle) {
        Integer intObj;
        if (this.getCacheAdministration(0).getMaxCacheSize() != 0 && (intObj = (Integer)this.nonVisibleList.get(cacheHandle)) != null) {
            int num = intObj;
            if (--num == 0) {
                this.nonVisibleList.remove(cacheHandle);
            } else {
                this.nonVisibleList.put(cacheHandle, new Integer(num));
            }
        }
    }

    public Statistics getStatistics() {
        this.statistics.stopTime();
        return this.statistics;
    }

    public void refreshStatistics() {
        this.statistics.clear();
    }

    public void checkFull() {
        this.fullCachingOn = this.cacheAdministration[0].getMaxCacheSize() < 0 && this.getInitialQueryCache() != null && this.getInitialQueryCache().equalsIgnoreCase("*");
    }

    public boolean isFull() {
        if (this.fullCachingOn) {
            this.checkFull();
        }
        return this.fullCachingOn;
    }

    public String getCacheType() {
        if (this.cacheAdministration[0].getMaxCacheSize() == 0) {
            return "none";
        }
        if (this.isFull()) {
            return "full";
        }
        return "lru";
    }

    public int getLevelOfCaching() {
        return 2;
    }

    public TableConfiguration getTableConfiguration() {
        return this.tableConf;
    }

    public double getReserveFactor() {
        return this.reserveFactor;
    }

    protected void setReserveFactor(double res) {
        this.reserveFactor = res;
    }

    protected void setCachePercentage(double percent) {
        this.cachePercentage = percent;
    }

    public double getCachePercentage() {
        return this.cachePercentage;
    }

    public boolean isDisabled() {
        return this.isDisabled;
    }

    public void readConfiguration(Config tableConfig, Config cacheConfig, String dbName) throws CacheObjectException {
        DatabaseConfiguration dbConf;
        if (this.isDisabled) {
            throw new CacheObjectException("Caching is disabled");
        }
        boolean initialAllCaches = false;
        int maxSize = 0;
        int maxSimple = 0;
        int maxComplex = 0;
        int maxMultiJoin = 0;
        Object defaultCacheConfig = null;
        this.tableConf.readTableConfiguration(tableConfig, dbName);
        try {
            dbConf = ((StandardLogicalDatabase)DODS.getDatabaseManager().findLogicalDatabase(dbName)).getDatabaseConfiguration();
        }
        catch (Exception ex) {
            throw new CacheObjectException("Error reading database configuration");
        }
        if (dbConf != null) {
            try {
                maxSize = dbConf.getMaxCacheSize();
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                maxSimple = dbConf.getMaxSimpleCacheSize();
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                maxComplex = dbConf.getMaxComplexCacheSize();
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                maxMultiJoin = dbConf.getMaxMultiJoinCacheSize();
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                this.reserveFactor = dbConf.getReserveFactor();
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                this.cachePercentage = dbConf.getCachePercentage();
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                initialAllCaches = dbConf.getInitAllCaches();
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                this.initialCacheFetchSize = dbConf.getInitialCacheFetchSize();
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                this.initialDSCacheSize = dbConf.getInitialDSCacheSize();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (cacheConfig != null) {
            block43: {
                try {
                    maxSize = cacheConfig.getInt("maxCacheSize");
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    maxSimple = cacheConfig.getInt("maxSimpleCacheSize");
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    maxComplex = cacheConfig.getInt("maxComplexCacheSize");
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    maxMultiJoin = cacheConfig.getInt("maxMultiJoinCacheSize");
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    this.initialQueryCache = cacheConfig.getString("initialCondition");
                }
                catch (Exception e) {
                    if (!initialAllCaches) break block43;
                    this.initialQueryCache = "*";
                }
            }
            try {
                this.reserveFactor = cacheConfig.getDouble("reserveFactor");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.cachePercentage = cacheConfig.getDouble("CachePercentage");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.initialCacheFetchSize = cacheConfig.getInt("InitialCacheFetchSize");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.initialDSCacheSize = cacheConfig.getInt("InitialDSCacheSize");
            }
            catch (Exception exception) {}
        } else if (initialAllCaches) {
            this.initialQueryCache = "*";
        }
        this.cacheAdministration[0].setMaxCacheSize(maxSize);
        this.cacheAdministration[1].setMaxCacheSize(maxSimple);
        this.cacheAdministration[2].setMaxCacheSize(maxComplex);
        this.cacheAdministration[3].setMaxCacheSize(maxMultiJoin);
    }

    public DataStructCache newInstance() throws CacheObjectException {
        if (this.isDisabled) {
            throw new CacheObjectException("Caching is disabled");
        }
        return new QueryCacheImpl();
    }

    protected void init() {
        this.cacheAdministration[1] = new CacheAdministration(){

            public int getMaxCacheSize() {
                if (QueryCacheImpl.this.simpleQCache != null) {
                    return QueryCacheImpl.this.simpleQCache.getMaxEntries();
                }
                return 0;
            }

            public int getMaxCacheSize(boolean real) {
                int size = this.getMaxCacheSize();
                if (size < 0) {
                    if (real) {
                        return -1;
                    }
                    return this.getCacheSize();
                }
                return size;
            }

            protected void setMaxCacheSize(int maxSize) throws CacheObjectException {
                try {
                    if (QueryCacheImpl.this.isDisabled) {
                        throw new CacheObjectException("Caching is disabled");
                    }
                    if (maxSize == 0) {
                        if (QueryCacheImpl.this.simpleQCache != null) {
                            QueryCacheImpl.this.statistics.getCacheStatistics(1).clearStatistics();
                            QueryCacheImpl.this.simpleQCache = null;
                        }
                        return;
                    }
                    if (QueryCacheImpl.this.simpleQCache == null) {
                        if (QueryCacheImpl.this.cache != null) {
                            QueryCacheImpl.this.simpleQCache = BaseCacheManager.getDODSCache(maxSize);
                        }
                    } else {
                        QueryCacheImpl.this.simpleQCache.setMaxEntries(maxSize);
                    }
                }
                catch (Exception ex) {
                    System.out.println("Error in setMaxCacheSize - simple cache");
                }
            }

            public int getCacheSize() {
                if (QueryCacheImpl.this.simpleQCache != null) {
                    return QueryCacheImpl.this.simpleQCache.size();
                }
                return 0;
            }

            public void refresh() {
                if (QueryCacheImpl.this.cache != null && QueryCacheImpl.this.simpleQCache != null) {
                    QueryCacheImpl.this.simpleQCache = BaseCacheManager.getDODSCache(QueryCacheImpl.this.simpleQCache.getMaxEntries());
                    QueryCacheImpl.this.statistics.getCacheStatistics(1).setCacheHitsNum(0);
                }
            }

            public void disable() {
                if (!QueryCacheImpl.this.isDisabledSimple) {
                    QueryCacheImpl.this.isDisabledSimple = true;
                    if (QueryCacheImpl.this.simpleQCache != null) {
                        QueryCacheImpl.this.disabledMaxSimpleQueryCacheSize = QueryCacheImpl.this.simpleQCache.getMaxEntries();
                        QueryCacheImpl.this.simpleQCache = null;
                    } else {
                        QueryCacheImpl.this.disabledMaxSimpleQueryCacheSize = 0;
                    }
                }
            }

            public void enable() {
                try {
                    DODSCache obj;
                    if (QueryCacheImpl.this.isDisabledSimple) {
                        if (QueryCacheImpl.this.disabledMaxSimpleQueryCacheSize != 0 && QueryCacheImpl.this.disabledMaxCacheSize != 0) {
                            QueryCacheImpl.this.simpleQCache = BaseCacheManager.getDODSCache(QueryCacheImpl.this.disabledMaxSimpleQueryCacheSize);
                        }
                        QueryCacheImpl.this.isDisabledSimple = false;
                    }
                    if ((obj = (DODSCache)QueryCacheImpl.this.statistics.getCacheStatistics(1)) != null) {
                        obj.clearStatistics();
                    }
                }
                catch (Exception ex) {
                    System.out.println("Error in enable simple");
                }
            }
        };
        this.cacheAdministration[2] = new CacheAdministration(){

            public int getMaxCacheSize() {
                if (QueryCacheImpl.this.complexQCache != null) {
                    return QueryCacheImpl.this.complexQCache.getMaxEntries();
                }
                return 0;
            }

            public int getMaxCacheSize(boolean real) {
                int size = this.getMaxCacheSize();
                if (size < 0) {
                    if (real) {
                        return -1;
                    }
                    return this.getCacheSize();
                }
                return size;
            }

            protected void setMaxCacheSize(int maxSize) throws CacheObjectException {
                try {
                    if (QueryCacheImpl.this.isDisabled) {
                        throw new CacheObjectException("Caching is disabled");
                    }
                    if (maxSize == 0) {
                        if (QueryCacheImpl.this.complexQCache != null) {
                            QueryCacheImpl.this.statistics.getCacheStatistics(2).clearStatistics();
                            QueryCacheImpl.this.complexQCache = null;
                        }
                        return;
                    }
                    if (QueryCacheImpl.this.complexQCache == null) {
                        if (QueryCacheImpl.this.cache != null) {
                            QueryCacheImpl.this.complexQCache = BaseCacheManager.getDODSCache(maxSize);
                        }
                    } else {
                        QueryCacheImpl.this.complexQCache.setMaxEntries(maxSize);
                    }
                }
                catch (Exception ex) {
                    System.out.println("Error in setMaxCacheSize - complex cache");
                }
            }

            public int getCacheSize() {
                if (QueryCacheImpl.this.complexQCache != null) {
                    return QueryCacheImpl.this.complexQCache.size();
                }
                return 0;
            }

            public void refresh() {
                if (QueryCacheImpl.this.cache != null && QueryCacheImpl.this.complexQCache != null) {
                    QueryCacheImpl.this.complexQCache = BaseCacheManager.getDODSCache(QueryCacheImpl.this.complexQCache.getMaxEntries());
                    QueryCacheImpl.this.statistics.getCacheStatistics(2).setCacheHitsNum(0);
                }
            }

            public void disable() {
                if (!QueryCacheImpl.this.isDisabledComplex) {
                    QueryCacheImpl.this.isDisabledComplex = true;
                    if (QueryCacheImpl.this.complexQCache != null) {
                        QueryCacheImpl.this.disabledMaxComplexQueryCacheSize = QueryCacheImpl.this.complexQCache.getMaxEntries();
                        QueryCacheImpl.this.complexQCache = null;
                    } else {
                        QueryCacheImpl.this.disabledMaxComplexQueryCacheSize = 0;
                    }
                }
            }

            public void enable() {
                try {
                    DODSCache obj;
                    if (QueryCacheImpl.this.isDisabledComplex) {
                        if (QueryCacheImpl.this.disabledMaxComplexQueryCacheSize != 0 && QueryCacheImpl.this.disabledMaxCacheSize != 0) {
                            QueryCacheImpl.this.complexQCache = BaseCacheManager.getDODSCache(QueryCacheImpl.this.disabledMaxComplexQueryCacheSize);
                        }
                        QueryCacheImpl.this.isDisabledComplex = false;
                    }
                    if ((obj = (DODSCache)QueryCacheImpl.this.statistics.getCacheStatistics(2)) != null) {
                        obj.clearStatistics();
                    }
                }
                catch (Exception ex) {
                    System.out.println("Error in enable complex");
                }
            }
        };
        this.cacheAdministration[3] = new CacheAdministration(){

            public int getMaxCacheSize() {
                if (QueryCacheImpl.this.multiJoinQCache != null) {
                    return QueryCacheImpl.this.multiJoinQCache.getMaxEntries();
                }
                return 0;
            }

            public int getMaxCacheSize(boolean real) {
                int size = this.getMaxCacheSize();
                if (size < 0) {
                    if (real) {
                        return -1;
                    }
                    return this.getCacheSize();
                }
                return size;
            }

            protected void setMaxCacheSize(int maxSize) throws CacheObjectException {
                try {
                    if (QueryCacheImpl.this.isDisabled) {
                        throw new CacheObjectException("Caching is disabled");
                    }
                    if (maxSize == 0) {
                        if (QueryCacheImpl.this.multiJoinQCache != null) {
                            QueryCacheImpl.this.statistics.getCacheStatistics(3).clearStatistics();
                            QueryCacheImpl.this.multiJoinQCache = null;
                        }
                        return;
                    }
                    if (QueryCacheImpl.this.multiJoinQCache == null) {
                        if (QueryCacheImpl.this.cache != null) {
                            QueryCacheImpl.this.multiJoinQCache = BaseCacheManager.getDODSCache(maxSize);
                        }
                    } else {
                        QueryCacheImpl.this.multiJoinQCache.setMaxEntries(maxSize);
                    }
                }
                catch (Exception ex) {
                    System.out.println("Error in setMaxCacheSize - complex cache");
                }
            }

            public int getCacheSize() {
                if (QueryCacheImpl.this.multiJoinQCache != null) {
                    return QueryCacheImpl.this.multiJoinQCache.size();
                }
                return 0;
            }

            public void refresh() {
                if (QueryCacheImpl.this.cache != null && QueryCacheImpl.this.multiJoinQCache != null) {
                    QueryCacheImpl.this.multiJoinQCache = BaseCacheManager.getDODSCache(QueryCacheImpl.this.multiJoinQCache.getMaxEntries());
                    QueryCacheImpl.this.statistics.getCacheStatistics(3).setCacheHitsNum(0);
                }
            }

            public void disable() {
                if (!QueryCacheImpl.this.isDisabledMultiJoin) {
                    QueryCacheImpl.this.isDisabledMultiJoin = true;
                    if (QueryCacheImpl.this.multiJoinQCache != null) {
                        QueryCacheImpl.this.disabledMaxMultiJoinQueryCacheSize = QueryCacheImpl.this.multiJoinQCache.getMaxEntries();
                        QueryCacheImpl.this.multiJoinQCache = null;
                    } else {
                        QueryCacheImpl.this.disabledMaxMultiJoinQueryCacheSize = 0;
                    }
                }
            }

            public void enable() {
                try {
                    DODSCache obj;
                    if (QueryCacheImpl.this.isDisabledMultiJoin) {
                        if (QueryCacheImpl.this.disabledMaxMultiJoinQueryCacheSize != 0 && QueryCacheImpl.this.disabledMaxCacheSize != 0) {
                            QueryCacheImpl.this.multiJoinQCache = BaseCacheManager.getDODSCache(QueryCacheImpl.this.disabledMaxMultiJoinQueryCacheSize);
                        }
                        QueryCacheImpl.this.isDisabledMultiJoin = false;
                    }
                    if ((obj = (DODSCache)QueryCacheImpl.this.statistics.getCacheStatistics(3)) != null) {
                        obj.clearStatistics();
                    }
                }
                catch (Exception ex) {
                    System.out.println("Error in enable complex");
                }
            }
        };
        this.cacheAdministration[0] = new CacheAdministration(){

            public int getMaxCacheSize() {
                if (QueryCacheImpl.this.cache != null) {
                    return QueryCacheImpl.this.cache.getMaxEntries();
                }
                return 0;
            }

            public int getMaxCacheSize(boolean real) {
                int size = this.getMaxCacheSize();
                if (size < 0) {
                    if (real) {
                        return -1;
                    }
                    return this.getCacheSize();
                }
                return size;
            }

            public int getCacheSize() {
                if (QueryCacheImpl.this.cache != null) {
                    return QueryCacheImpl.this.cache.size();
                }
                return 0;
            }

            protected void setMaxCacheSize(int maxSize) throws CacheObjectException {
                try {
                    if (QueryCacheImpl.this.isDisabled) {
                        throw new CacheObjectException("Caching is disabled");
                    }
                    if (maxSize == 0) {
                        QueryCacheImpl.this.cache = null;
                        if (QueryCacheImpl.this.simpleQCache != null) {
                            QueryCacheImpl.this.oldSimpleMaxCacheSize = QueryCacheImpl.this.getCacheAdministration(1).getMaxCacheSize();
                            QueryCacheImpl.this.simpleQCache = null;
                        } else {
                            QueryCacheImpl.this.oldSimpleMaxCacheSize = 0;
                        }
                        if (QueryCacheImpl.this.complexQCache != null) {
                            QueryCacheImpl.this.oldComplexMaxCacheSize = QueryCacheImpl.this.getCacheAdministration(2).getMaxCacheSize();
                            QueryCacheImpl.this.complexQCache = null;
                        } else {
                            QueryCacheImpl.this.oldComplexMaxCacheSize = 0;
                        }
                        if (QueryCacheImpl.this.multiJoinQCache != null) {
                            QueryCacheImpl.this.oldMultiJoinMaxCacheSize = QueryCacheImpl.this.getCacheAdministration(3).getMaxCacheSize();
                            QueryCacheImpl.this.multiJoinQCache = null;
                        } else {
                            QueryCacheImpl.this.oldMultiJoinMaxCacheSize = 0;
                        }
                        QueryCacheImpl.this.statistics.clear();
                        return;
                    }
                    if (QueryCacheImpl.this.cache == null) {
                        QueryCacheImpl.this.cache = BaseCacheManager.getDODSCache(maxSize);
                        if (QueryCacheImpl.this.oldSimpleMaxCacheSize != 0) {
                            QueryCacheImpl.this.simpleQCache = BaseCacheManager.getDODSCache(QueryCacheImpl.this.oldSimpleMaxCacheSize);
                        }
                        if (QueryCacheImpl.this.oldComplexMaxCacheSize != 0) {
                            QueryCacheImpl.this.complexQCache = BaseCacheManager.getDODSCache(QueryCacheImpl.this.oldComplexMaxCacheSize);
                        }
                        if (QueryCacheImpl.this.oldMultiJoinMaxCacheSize != 0) {
                            QueryCacheImpl.this.multiJoinQCache = BaseCacheManager.getDODSCache(QueryCacheImpl.this.oldMultiJoinMaxCacheSize);
                        }
                    } else {
                        QueryCacheImpl.this.cache.setMaxEntries(maxSize);
                    }
                }
                catch (Exception ex) {
                    System.out.println("Error in setMaxCacheSize - DO cache");
                }
            }

            public void refresh() {
                if (QueryCacheImpl.this.cache != null) {
                    QueryCacheImpl.this.cache = BaseCacheManager.getDODSCache(QueryCacheImpl.this.cache.getMaxEntries());
                }
                if (QueryCacheImpl.this.simpleQCache != null) {
                    QueryCacheImpl.this.simpleQCache = BaseCacheManager.getDODSCache(QueryCacheImpl.this.simpleQCache.getMaxEntries());
                }
                if (QueryCacheImpl.this.complexQCache != null) {
                    QueryCacheImpl.this.complexQCache = BaseCacheManager.getDODSCache(QueryCacheImpl.this.complexQCache.getMaxEntries());
                }
                if (QueryCacheImpl.this.multiJoinQCache != null) {
                    QueryCacheImpl.this.multiJoinQCache = BaseCacheManager.getDODSCache(QueryCacheImpl.this.multiJoinQCache.getMaxEntries());
                }
                QueryCacheImpl.this.statistics.clear();
            }

            public void disable() {
                if (!QueryCacheImpl.this.isDisabled) {
                    QueryCacheImpl.this.isDisabled = true;
                    if (QueryCacheImpl.this.cache != null) {
                        QueryCacheImpl.this.disabledMaxCacheSize = QueryCacheImpl.this.cache.getMaxEntries();
                        QueryCacheImpl.this.cache = null;
                        if (QueryCacheImpl.this.simpleQCache != null) {
                            QueryCacheImpl.this.getCacheAdministration(1).disable();
                        }
                        if (QueryCacheImpl.this.complexQCache != null) {
                            QueryCacheImpl.this.cacheAdministration[2].disable();
                        }
                        if (QueryCacheImpl.this.multiJoinQCache != null) {
                            QueryCacheImpl.this.cacheAdministration[3].disable();
                        }
                        QueryCacheImpl.this.statistics.clear();
                    }
                }
            }

            public void enable() {
                try {
                    if (QueryCacheImpl.this.isDisabled) {
                        if (QueryCacheImpl.this.disabledMaxCacheSize != 0) {
                            QueryCacheImpl.this.cache = BaseCacheManager.getDODSCache(QueryCacheImpl.this.disabledMaxCacheSize);
                        }
                        if (QueryCacheImpl.this.isDisabledSimple) {
                            QueryCacheImpl.this.getCacheAdministration(1).enable();
                        }
                        if (QueryCacheImpl.this.isDisabledComplex) {
                            QueryCacheImpl.this.getCacheAdministration(2).enable();
                        }
                        if (QueryCacheImpl.this.isDisabledMultiJoin) {
                            QueryCacheImpl.this.getCacheAdministration(3).enable();
                        }
                        QueryCacheImpl.this.statistics.clear();
                        QueryCacheImpl.this.isDisabled = false;
                    }
                }
                catch (Exception ex) {
                    System.out.println("Error in enable DO");
                }
            }
        };
    }

    public Map getCacheContent() {
        return this.cache;
    }

    public boolean isMulti() {
        return this.multi;
    }

    public boolean toReconfigure() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoreDataStruct addDataStruct(CoreDataStruct newDS) {
        block8: {
            String handle;
            try {
                handle = newDS.get_CacheHandle();
            }
            catch (Exception e) {
                handle = null;
            }
            if (this.cache == null) {
                return newDS;
            }
            try {
                if (null == handle) break block8;
                DODSCache e = this.cache;
                synchronized (e) {
                    this.cache.add(handle, newDS);
                }
                return newDS;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoreDataStruct removeDataStruct(CoreDataStruct data) {
        try {
            String handle = data.get_CacheHandle();
            if (this.cache != null) {
                DODSCache dODSCache = this.cache;
                synchronized (dODSCache) {
                    return (CoreDataStruct)this.cache.remove(handle);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoreDataStruct removeDataStruct(String handle) {
        if (this.cache != null) {
            DODSCache dODSCache = this.cache;
            synchronized (dODSCache) {
                try {
                    return (CoreDataStruct)this.cache.remove(handle);
                }
                catch (Exception exception) {
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoreDataStruct updateDataStruct(CoreDataStruct data) {
        block21: {
            try {
                DODSCache dODSCache;
                HashSet<QueryCacheItem> del;
                data = this.addDataStruct(data);
                QueryCacheItem queryItem2 = null;
                Iterator<Object> iter = null;
                if (this.complexQCache != null) {
                    del = new HashSet<QueryCacheItem>();
                    dODSCache = this.complexQCache;
                    synchronized (dODSCache) {
                        for (QueryCacheItem queryItem2 : this.complexQCache.values()) {
                            if (!data.get_Database().equals(queryItem2.get_OriginDatabase())) continue;
                            del.add(queryItem2);
                        }
                    }
                    iter = null;
                    iter = del.iterator();
                    while (iter.hasNext()) {
                        this.removeComplexQuery((QueryCacheItem)iter.next());
                    }
                }
                if (this.multiJoinQCache != null) {
                    del = new HashSet();
                    dODSCache = this.multiJoinQCache;
                    synchronized (dODSCache) {
                        for (QueryCacheItem queryItem2 : this.multiJoinQCache.values()) {
                            if (!data.get_Database().equals(queryItem2.get_OriginDatabase())) continue;
                            del.add(queryItem2);
                        }
                    }
                    iter = null;
                    iter = del.iterator();
                    while (iter.hasNext()) {
                        this.removeMultiJoinQuery((QueryCacheItem)iter.next());
                    }
                }
                if (this.simpleQCache == null) break block21;
                iter = null;
                dODSCache = this.simpleQCache;
                synchronized (dODSCache) {
                    for (QueryCacheItem queryItem2 : this.simpleQCache.values()) {
                        String db = data.get_Database();
                        if (!db.equals(queryItem2.get_OriginDatabase())) continue;
                        if (queryItem2.checkConditions(data)) {
                            if (queryItem2.getOIds().contains(data.get_Handle())) {
                                queryItem2.setModifiedQuery(true);
                                continue;
                            }
                            if (queryItem2.isCompleteResult()) {
                                queryItem2.add(data);
                            }
                            queryItem2.setModifiedQuery(true);
                            continue;
                        }
                        if (!queryItem2.getOIds().contains(data.get_Handle())) continue;
                        queryItem2.delete(data);
                        queryItem2.setModifiedQuery(true);
                    }
                }
            }
            catch (DatabaseManagerException databaseManagerException) {
                // empty catch block
            }
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoreDataStruct deleteDataStruct(CoreDataStruct data) {
        if (data != null) {
            String db;
            DODSCache dODSCache;
            CoreDataStruct oldDS = this.removeDataStruct(data);
            Iterator iter = null;
            QueryCacheItem queryItem2 = null;
            if (this.simpleQCache != null) {
                dODSCache = this.simpleQCache;
                synchronized (dODSCache) {
                    for (QueryCacheItem queryItem2 : this.simpleQCache.values()) {
                        try {
                            db = data.get_Database();
                            if (!db.equals(queryItem2.get_OriginDatabase()) || !queryItem2.getOIds().contains(data.get_Handle())) continue;
                            queryItem2.delete(data);
                            queryItem2.setModifiedQuery(true);
                        }
                        catch (Exception e) {
                            System.out.println("Error in deleteDataStruct of QueryCacheImpl");
                        }
                    }
                }
            }
            iter = null;
            if (this.complexQCache != null) {
                dODSCache = this.complexQCache;
                synchronized (dODSCache) {
                    for (QueryCacheItem queryItem2 : this.complexQCache.values()) {
                        try {
                            db = data.get_Database();
                            if (!db.equals(queryItem2.get_OriginDatabase()) || !queryItem2.getOIds().contains(data.get_Handle())) continue;
                            queryItem2.delete(data);
                            queryItem2.setModifiedQuery(true);
                        }
                        catch (Exception e) {
                            System.out.println("Error in deleteDataStruct of QueryCacheImpl");
                        }
                    }
                }
            }
            if (this.multiJoinQCache != null) {
                dODSCache = this.multiJoinQCache;
                synchronized (dODSCache) {
                    for (QueryCacheItem queryItem2 : this.multiJoinQCache.values()) {
                        try {
                            db = data.get_Database();
                            if (!db.equals(queryItem2.get_OriginDatabase()) || !queryItem2.getOIds().contains(data.get_Handle())) continue;
                            queryItem2.delete(data);
                            queryItem2.setModifiedQuery(true);
                        }
                        catch (Exception e) {
                            System.out.println("Error in deleteDataStruct of QueryCacheImpl");
                        }
                    }
                }
            }
            return oldDS;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoreDataStruct getDataStructByHandle(String cacheHandle) {
        if (this.cache == null) {
            return null;
        }
        if (this.isLocked()) {
            return null;
        }
        CoreDataStruct tmpDO = null;
        if (this.cache.isNeedToSynchronize()) {
            DODSCache dODSCache = this.cache;
            synchronized (dODSCache) {
                tmpDO = this.getCacheItem(cacheHandle, tmpDO);
            }
        } else {
            tmpDO = this.getCacheItem(cacheHandle, tmpDO);
        }
        return tmpDO;
    }

    private CoreDataStruct getCacheItem(String cacheHandle, CoreDataStruct tmpDO) {
        this.cache.incrementCacheAccessNum(1);
        if (!this.nonVisibleList.containsKey(cacheHandle) && (tmpDO = (CoreDataStruct)this.cache.get(cacheHandle)) != null) {
            this.cache.incrementCacheHitsNum(1);
        }
        return tmpDO;
    }

    public QueryCacheItem newQueryCacheItemInstance(String dbName) {
        return new QueryCacheItemImpl(dbName);
    }

    public QueryCacheItem getSimpleQueryCacheItem(String dbName, String query) {
        if (this.simpleQCache != null && !this.isLockedSimpleComplexQCache()) {
            return this._getItem(this.simpleQCache, dbName + "." + query);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueryCacheItem _getItem(DODSCache whereFrom, String whichOne) {
        if (whereFrom.isNeedToSynchronize()) {
            DODSCache dODSCache = whereFrom;
            synchronized (dODSCache) {
                return (QueryCacheItem)whereFrom.get(whichOne);
            }
        }
        return (QueryCacheItem)whereFrom.get(whichOne);
    }

    public QueryCacheItem getComplexQueryCacheItem(String dbName, String query) {
        if (this.complexQCache != null && !this.isLockedSimpleComplexQCache()) {
            return this._getItem(this.complexQCache, dbName + "." + query);
        }
        return null;
    }

    public QueryCacheItem getMultiJoinQueryCacheItem(String dbName, String query) {
        if (this.multiJoinQCache != null && !this.isLockedMultiJoinQCache()) {
            return this._getItem(this.multiJoinQCache, dbName + "." + query);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryCacheItem addSimpleQuery(QueryCacheItem queryItem) {
        if (this.simpleQCache != null) {
            DODSCache dODSCache = this.simpleQCache;
            synchronized (dODSCache) {
                return (QueryCacheItem)this.simpleQCache.add(queryItem.get_OriginDatabase() + "." + queryItem.getQueryId(), queryItem);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryCacheItem removeSimpleQuery(QueryCacheItem queryItem) {
        if (this.simpleQCache != null) {
            DODSCache dODSCache = this.simpleQCache;
            synchronized (dODSCache) {
                return (QueryCacheItem)this.simpleQCache.remove(queryItem.get_OriginDatabase() + "." + queryItem.getQueryId());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryCacheItem addComplexQuery(QueryCacheItem queryItem) {
        if (this.complexQCache != null) {
            DODSCache dODSCache = this.complexQCache;
            synchronized (dODSCache) {
                return (QueryCacheItem)this.complexQCache.add(queryItem.get_OriginDatabase() + "." + queryItem.getQueryId(), queryItem);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryCacheItem removeComplexQuery(QueryCacheItem queryItem) {
        if (this.complexQCache != null) {
            DODSCache dODSCache = this.complexQCache;
            synchronized (dODSCache) {
                return (QueryCacheItem)this.complexQCache.remove(queryItem.get_OriginDatabase() + "." + queryItem.getQueryId());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryCacheItem addMultiJoinQuery(QueryCacheItem queryItem) {
        if (this.multiJoinQCache != null) {
            DODSCache dODSCache = this.multiJoinQCache;
            synchronized (dODSCache) {
                return (QueryCacheItem)this.multiJoinQCache.add(queryItem.get_OriginDatabase() + "." + queryItem.getQueryId(), queryItem);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryCacheItem removeMultiJoinQuery(QueryCacheItem queryItem) {
        if (this.multiJoinQCache != null) {
            DODSCache dODSCache = this.multiJoinQCache;
            synchronized (dODSCache) {
                return (QueryCacheItem)this.multiJoinQCache.remove(queryItem.get_OriginDatabase() + "." + queryItem.getQueryId());
            }
        }
        return null;
    }

    public QueryResult getSimpleQueryResults(String dbName, String query) {
        return this.getSimpleQueryResults(dbName, query, 0, 0, false);
    }

    public QueryResult getSimpleQueryResults(String dbName, String query, int limit, int maxdb) {
        return this.getSimpleQueryResults(dbName, query, limit, maxdb, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryResult getSimpleQueryResults(String dbName, String query, int limit, int maxdb, boolean unique) {
        int i;
        if (this.simpleQCache == null || this.isLockedSimpleComplexQCache()) {
            return null;
        }
        QueryResult result = null;
        String queryHandle = dbName + "." + query;
        QueryCacheItem queryItem = this._getItem(this.simpleQCache, queryHandle);
        if (queryItem != null) {
            QueryCacheItem queryCacheItem = queryItem;
            synchronized (queryCacheItem) {
                result = new QueryResult();
                result.database = queryItem.get_OriginDatabase();
                String handle = null;
                String cachePrefix = queryItem.get_OriginDatabase() + ".";
                Iterator iter = queryItem.getOIds().iterator();
                if (unique) {
                    HashSet<String> allResultOids = new HashSet<String>();
                    int skippedNum = 0;
                    for (i = 0; !(maxdb != 0 && i >= maxdb || !iter.hasNext() || limit != 0 && result.DOs.size() >= limit); ++i) {
                        handle = (String)iter.next();
                        if (allResultOids.contains(handle)) {
                            ++skippedNum;
                            continue;
                        }
                        allResultOids.add(handle);
                        result.DOs.add(handle);
                    }
                    result.skippedUnique = skippedNum;
                } else {
                    while (!(maxdb != 0 && i >= maxdb || !iter.hasNext() || limit != 0 && result.DOs.size() >= limit)) {
                        handle = (String)iter.next();
                        result.DOs.add(handle);
                        ++i;
                    }
                }
            }
        }
        if (result.DOs.size() < limit && (maxdb == 0 || i < maxdb)) {
            result = null;
        }
        return result;
    }

    public QueryResult getComplexQueryResults(String dbName, String query) {
        return this.getComplexQueryResults(dbName, query, 0, 0, false);
    }

    public QueryResult getComplexQueryResults(String dbName, String query, int limit, int maxdb) {
        return this.getComplexQueryResults(dbName, query, limit, maxdb, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryResult getComplexQueryResults(String dbName, String query, int limit, int maxdb, boolean unique) {
        int i;
        if (this.complexQCache == null || this.isLockedSimpleComplexQCache()) {
            return null;
        }
        QueryResult result = null;
        String queryHandle = dbName + "." + query;
        QueryCacheItem queryItem = this._getItem(this.complexQCache, queryHandle);
        if (queryItem != null) {
            QueryCacheItem queryCacheItem = queryItem;
            synchronized (queryCacheItem) {
                result = new QueryResult();
                result.database = queryItem.get_OriginDatabase();
                String handle = null;
                String cachePrefix = queryItem.get_OriginDatabase() + ".";
                Iterator iter = queryItem.getOIds().iterator();
                if (unique) {
                    HashSet<String> allResultOids = new HashSet<String>();
                    int skippedNum = 0;
                    for (i = 0; !(maxdb != 0 && i >= maxdb || !iter.hasNext() || limit != 0 && result.DOs.size() >= limit); ++i) {
                        handle = (String)iter.next();
                        if (allResultOids.contains(handle)) {
                            ++skippedNum;
                            continue;
                        }
                        allResultOids.add(handle);
                        result.DOs.add(handle);
                    }
                    result.skippedUnique = skippedNum;
                } else {
                    while (!(maxdb != 0 && i >= maxdb || !iter.hasNext() || limit != 0 && result.DOs.size() >= limit)) {
                        handle = (String)iter.next();
                        result.DOs.add(handle);
                        ++i;
                    }
                }
            }
        }
        if (result.DOs.size() < limit && (maxdb == 0 || i < maxdb)) {
            result = null;
        }
        return result;
    }

    public QueryResult getMultiJoinQueryResults(String dbName, String query) {
        return this.getMultiJoinQueryResults(dbName, query, 0, 0, false);
    }

    public QueryResult getMultiJoinQueryResults(String dbName, String query, int limit, int maxdb) {
        return this.getMultiJoinQueryResults(dbName, query, limit, maxdb, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryResult getMultiJoinQueryResults(String dbName, String query, int limit, int maxdb, boolean unique) {
        int i;
        if (this.multiJoinQCache == null || this.isLockedMultiJoinQCache()) {
            return null;
        }
        QueryResult result = null;
        String queryHandle = dbName + "." + query;
        QueryCacheItem queryItem = this._getItem(this.multiJoinQCache, queryHandle);
        if (queryItem != null) {
            QueryCacheItem queryCacheItem = queryItem;
            synchronized (queryCacheItem) {
                result = new QueryResult();
                result.database = queryItem.get_OriginDatabase();
                String handle = null;
                String cachePrefix = queryItem.get_OriginDatabase() + ".";
                Iterator iter = queryItem.getOIds().iterator();
                if (unique) {
                    HashSet<String> allResultOids = new HashSet<String>();
                    int skippedNum = 0;
                    for (i = 0; !(maxdb != 0 && i >= maxdb || !iter.hasNext() || limit != 0 && result.DOs.size() >= limit); ++i) {
                        handle = (String)iter.next();
                        if (allResultOids.contains(handle)) {
                            ++skippedNum;
                            continue;
                        }
                        allResultOids.add(handle);
                        result.DOs.add(handle);
                    }
                    result.skippedUnique = skippedNum;
                } else {
                    while (!(maxdb != 0 && i >= maxdb || !iter.hasNext() || limit != 0 && result.DOs.size() >= limit)) {
                        handle = (String)iter.next();
                        result.DOs.add(handle);
                        ++i;
                    }
                }
            }
        }
        if (result.DOs.size() < limit && (maxdb == 0 || i < maxdb)) {
            result = null;
        }
        return result;
    }

    public QueryResult getQueryResults(String dbName, String query) {
        QueryResult result = this.getSimpleQueryResults(dbName, query);
        if (result == null) {
            result = this.getComplexQueryResults(dbName, query);
        }
        if (result == null) {
            result = this.getMultiJoinQueryResults(dbName, query);
        }
        return result;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("\n QueryCacheImpl: ");
        ret.append("\n cache: " + this.cache);
        ret.append("\n simpleQCache : " + this.simpleQCache);
        ret.append("\n complexQCache : " + this.complexQCache);
        ret.append("\n multiJoinQCache : " + this.multiJoinQCache);
        ret.append("\n cacheReadOnly : " + this.tableConf.isReadOnly());
        ret.append("\n initialQueryCache : " + this.initialQueryCache);
        ret.append("\n fullCaching : " + this.isFull());
        return ret.toString();
    }

    public void removeEntries(Vector vec) {
        this._refreshSimpleQuery();
        this._refreshComplexQuery();
        this._refreshMultiJoinQuery();
        if (this.cache.size() > vec.size()) {
            Enumeration e = vec.elements();
            while (e.hasMoreElements()) {
                this.removeDataStruct((String)e.nextElement());
            }
        } else {
            Iterator it = this.cache.values().iterator();
            Vector<CoreDataStruct> vecToRemove = new Vector<CoreDataStruct>();
            while (it.hasNext()) {
                CoreDataStruct obj = (CoreDataStruct)it.next();
                try {
                    if (!vec.contains(obj.get_CacheHandle())) continue;
                    vecToRemove.add(obj);
                }
                catch (DatabaseManagerException databaseManagerException) {}
            }
            Enumeration e = vecToRemove.elements();
            while (e.hasMoreElements()) {
                this.removeDataStruct((String)e.nextElement());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEntries() {
        this._refreshSimpleQuery();
        this._refreshComplexQuery();
        this._refreshMultiJoinQuery();
        if (this.cache != null) {
            DODSCache dODSCache = this.cache;
            synchronized (dODSCache) {
                this.cache.clear();
                this.cache.clearStatistics();
            }
        }
    }

    public void emptyEntries(Vector vec, boolean incrementVersion) {
        this._refreshSimpleQuery();
        this._refreshComplexQuery();
        this._refreshMultiJoinQuery();
        Enumeration e = vec.elements();
        while (e.hasMoreElements()) {
            String cacheHandle = (String)e.nextElement();
            CoreDataStruct ds = (CoreDataStruct)this.cache.get(cacheHandle);
            if (ds == null) continue;
            this.updateDataStruct(ds.dumpData(incrementVersion));
        }
    }

    public void emptyEntries() {
        this._refreshSimpleQuery();
        this._refreshComplexQuery();
        this._refreshMultiJoinQuery();
        Collection c = this.cache.values();
        for (CoreDataStruct ds : c) {
            this.updateDataStruct(ds.dumpData(false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _refreshSimpleQuery() {
        if (this.simpleQCache != null) {
            DODSCache dODSCache = this.simpleQCache;
            synchronized (dODSCache) {
                this.simpleQCache.clear();
                this.simpleQCache.clearStatistics();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _refreshComplexQuery() {
        if (this.complexQCache != null) {
            DODSCache dODSCache = this.complexQCache;
            synchronized (dODSCache) {
                this.complexQCache.clear();
                this.complexQCache.clearStatistics();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _refreshMultiJoinQuery() {
        if (this.multiJoinQCache != null) {
            DODSCache dODSCache = this.multiJoinQCache;
            synchronized (dODSCache) {
                this.multiJoinQCache.clear();
                this.multiJoinQCache.clearStatistics();
            }
        }
    }

    public int getInitialCacheFetchSize() {
        return this.initialCacheFetchSize;
    }

    public int getInitialDSCacheSize() {
        return this.initialDSCacheSize;
    }

    public void setInitialCacheFetchSize(int i) {
        this.initialCacheFetchSize = i;
    }

    public void setInitialDSCacheSize(int i) {
        this.initialDSCacheSize = i;
    }

    private class QueryCacheImplStatistics
    extends TableStatistics {
        public QueryCacheImplStatistics() {
            try {
                this.reset();
                if (QueryCacheImpl.this.cache != null) {
                    this.getCacheStatistics(0).clearStatistics();
                }
                if (QueryCacheImpl.this.simpleQCache != null) {
                    this.getCacheStatistics(1).clearStatistics();
                }
                if (QueryCacheImpl.this.complexQCache != null) {
                    this.getCacheStatistics(2).clearStatistics();
                }
                if (QueryCacheImpl.this.multiJoinQCache != null) {
                    this.getCacheStatistics(3).clearStatistics();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void reset() {
            this.insertNum = 0;
            this.updateNum = 0;
            this.deleteNum = 0;
            this.lazyLoadingNum = 0;
            this.startTime = new Date();
            this.stopTime = new Date();
            this.queryNum = 0;
            this.queryByOIdNum = 0;
            this.averageQueryTime = 0;
            this.averageQueryByOIdTime = 0;
        }

        public int getStatisticsType() {
            return 2;
        }

        public void clear() {
            this.reset();
            if (QueryCacheImpl.this.cache != null) {
                this.getCacheStatistics(0).clearStatistics();
            }
            if (QueryCacheImpl.this.simpleQCache != null) {
                this.getCacheStatistics(1).clearStatistics();
            }
            if (QueryCacheImpl.this.complexQCache != null) {
                this.getCacheStatistics(2).clearStatistics();
            }
            if (QueryCacheImpl.this.multiJoinQCache != null) {
                this.getCacheStatistics(3).clearStatistics();
            }
        }

        public CacheStatistics getCacheStatistics(int type) {
            switch (type) {
                case 0: {
                    return QueryCacheImpl.this.cache;
                }
                case 1: {
                    return QueryCacheImpl.this.simpleQCache;
                }
                case 2: {
                    return QueryCacheImpl.this.complexQCache;
                }
                case 3: {
                    return QueryCacheImpl.this.multiJoinQCache;
                }
            }
            return null;
        }
    }
}

