/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.dods.cache;

import com.lutris.appserver.server.sql.DatabaseManagerException;
import com.lutris.dods.builder.generator.dataobject.GenericDO;
import com.lutris.util.Config;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.enhydra.dods.cache.CacheAdministration;
import org.enhydra.dods.cache.DOCache;
import org.enhydra.dods.cache.DODSHashMap;
import org.enhydra.dods.cache.DOShell;
import org.enhydra.dods.cache.QueryCacheItem;
import org.enhydra.dods.cache.QueryCacheItemImpl;
import org.enhydra.dods.cache.QueryResult;
import org.enhydra.dods.cache.TableConfiguration;
import org.enhydra.dods.cache.TransactionQueryCache;
import org.enhydra.dods.cache.base.BaseCacheManager;
import org.enhydra.dods.cache.base.DODSCache;
import org.enhydra.dods.cache.lru.DODSLRUCache;
import org.enhydra.dods.exceptions.CacheObjectException;
import org.enhydra.dods.statistics.CacheStatistics;
import org.enhydra.dods.statistics.Statistics;
import org.enhydra.dods.statistics.TableStatistics;

public class TransactionCacheImpl
extends TransactionQueryCache {
    protected DODSHashMap cache = null;
    protected DODSCache simpleQCache = null;
    protected DODSCache complexQCache = null;
    protected CacheAdministration[] cacheAdministration = new CacheAdministration[3];
    protected TableConfiguration tableConf = new TableConfiguration();
    protected String initialQueryCache = null;
    protected boolean fullCachingOn = false;
    protected boolean multi = false;
    protected Statistics statistics = null;
    protected int oldSimpleMaxCacheSize;
    protected int oldComplexMaxCacheSize;
    protected double reserveFactor = 0.0;
    protected double cachePercentage = -1.0;
    private int initialCacheFetchSize = 0;
    private int initialDSCacheSize = -1;
    private boolean isDisabled = false;
    private boolean isDisabledSimple = false;
    private boolean isDisabledComplex = false;
    private int disabledMaxCacheSize = 0;
    private int disabledMaxSimpleQueryCacheSize = 0;
    private int disabledMaxComplexQueryCacheSize = 0;

    public TransactionCacheImpl(int maxSQSize, int maxCQSize) throws CacheObjectException {
        if (this.isDisabled) {
            throw new CacheObjectException("Caching is disabled");
        }
        this.cache = new DODSHashMap();
        this.simpleQCache = BaseCacheManager.getDODSCache(maxSQSize);
        this.complexQCache = BaseCacheManager.getDODSCache(maxCQSize);
        this.statistics = new QueryCacheImplStatistics();
        this.init();
    }

    public TransactionCacheImpl() throws CacheObjectException {
        if (this.isDisabled) {
            throw new CacheObjectException("Caching is disabled");
        }
        this.cache = new DODSHashMap();
        this.simpleQCache = BaseCacheManager.getDODSCache(0);
        this.complexQCache = BaseCacheManager.getDODSCache(0);
        this.statistics = new QueryCacheImplStatistics();
        this.init();
    }

    public CacheAdministration getCacheAdministration(int cacheType) {
        if (cacheType < 0 || cacheType > 2) {
            return null;
        }
        return this.cacheAdministration[cacheType];
    }

    public String getInitialQueryCache() {
        return this.initialQueryCache;
    }

    protected void setInitialQueryCache(String initQ) {
        this.initialQueryCache = initQ;
    }

    public Statistics getStatistics() {
        this.statistics.stopTime();
        return this.statistics;
    }

    public void refreshStatistics() {
        this.statistics.clear();
    }

    public void checkFull() {
        this.fullCachingOn = this.cacheAdministration[0].getMaxCacheSize() < 0 && this.getInitialQueryCache() != null && this.getInitialQueryCache().equals("*");
    }

    public boolean isFull() {
        if (this.fullCachingOn) {
            this.checkFull();
        }
        return this.fullCachingOn;
    }

    public String getCacheType() {
        if (this.cacheAdministration[0].getMaxCacheSize() == 0) {
            return "none";
        }
        if (this.isFull()) {
            return "full";
        }
        return "lru";
    }

    public int getLevelOfCaching() {
        return 2;
    }

    public TableConfiguration getTableConfiguration() {
        return this.tableConf;
    }

    public double getReserveFactor() {
        return this.reserveFactor;
    }

    protected void setReserveFactor(double res) {
        this.reserveFactor = res;
    }

    protected void setCachePercentage(double percent) {
        this.cachePercentage = percent;
    }

    public double getCachePercentage() {
        return this.cachePercentage;
    }

    public boolean isDisabled() {
        return this.isDisabled;
    }

    public void readConfiguration(Config tableConfig, Config cacheConfig, String dbName) throws CacheObjectException {
        if (this.isDisabled) {
            throw new CacheObjectException("Caching is disabled");
        }
        int maxSize = -1;
        int maxSimple = 0;
        int maxComplex = 0;
        this.cacheAdministration[0].setMaxCacheSize(maxSize);
        this.cacheAdministration[1].setMaxCacheSize(maxSimple);
        this.cacheAdministration[2].setMaxCacheSize(maxComplex);
    }

    public DOCache newInstance() throws CacheObjectException {
        if (this.isDisabled) {
            throw new CacheObjectException("Caching is disabled");
        }
        return new TransactionCacheImpl();
    }

    protected void init() {
        this.cacheAdministration[1] = new CacheAdministration(){

            public int getMaxCacheSize() {
                if (TransactionCacheImpl.this.simpleQCache != null) {
                    return TransactionCacheImpl.this.simpleQCache.getMaxEntries();
                }
                return 0;
            }

            public int getMaxCacheSize(boolean real) {
                int size = this.getMaxCacheSize();
                if (size < 0) {
                    if (real) {
                        return -1;
                    }
                    return this.getCacheSize();
                }
                return size;
            }

            protected void setMaxCacheSize(int maxSize) throws CacheObjectException {
                try {
                    if (TransactionCacheImpl.this.isDisabled) {
                        throw new CacheObjectException("Caching is disabled");
                    }
                    if (maxSize == 0) {
                        if (TransactionCacheImpl.this.simpleQCache != null) {
                            TransactionCacheImpl.this.statistics.getCacheStatistics(1).clearStatistics();
                            TransactionCacheImpl.this.simpleQCache = null;
                        }
                        return;
                    }
                    if (TransactionCacheImpl.this.simpleQCache == null) {
                        if (TransactionCacheImpl.this.cache != null) {
                            TransactionCacheImpl.this.simpleQCache = BaseCacheManager.getDODSCache(maxSize);
                        }
                    } else {
                        TransactionCacheImpl.this.simpleQCache.setMaxEntries(maxSize);
                    }
                }
                catch (Exception ex) {
                    System.out.println("Error in setMaxCacheSize - simple cache");
                }
            }

            public int getCacheSize() {
                if (TransactionCacheImpl.this.simpleQCache != null) {
                    return TransactionCacheImpl.this.simpleQCache.size();
                }
                return 0;
            }

            public void refresh() {
                if (TransactionCacheImpl.this.cache != null && TransactionCacheImpl.this.simpleQCache != null) {
                    TransactionCacheImpl.this.simpleQCache = BaseCacheManager.getDODSCache(TransactionCacheImpl.this.simpleQCache.getMaxEntries());
                    TransactionCacheImpl.this.statistics.getCacheStatistics(1).setCacheHitsNum(0);
                }
            }

            public void disable() {
                if (!TransactionCacheImpl.this.isDisabledSimple) {
                    TransactionCacheImpl.this.isDisabledSimple = true;
                    if (TransactionCacheImpl.this.simpleQCache != null) {
                        TransactionCacheImpl.this.disabledMaxSimpleQueryCacheSize = TransactionCacheImpl.this.simpleQCache.getMaxEntries();
                        TransactionCacheImpl.this.simpleQCache = null;
                    } else {
                        TransactionCacheImpl.this.disabledMaxSimpleQueryCacheSize = 0;
                    }
                }
            }

            public void enable() {
                try {
                    DODSLRUCache obj;
                    if (TransactionCacheImpl.this.isDisabledSimple) {
                        if (TransactionCacheImpl.this.disabledMaxSimpleQueryCacheSize != 0 && TransactionCacheImpl.this.disabledMaxCacheSize != 0) {
                            TransactionCacheImpl.this.simpleQCache = BaseCacheManager.getDODSCache(TransactionCacheImpl.this.disabledMaxSimpleQueryCacheSize);
                        }
                        TransactionCacheImpl.this.isDisabledSimple = false;
                    }
                    if ((obj = (DODSLRUCache)TransactionCacheImpl.this.statistics.getCacheStatistics(1)) != null) {
                        obj.clearStatistics();
                    }
                }
                catch (Exception ex) {
                    System.out.println("Error in enable simple");
                }
            }
        };
        this.cacheAdministration[2] = new CacheAdministration(){

            public int getMaxCacheSize() {
                if (TransactionCacheImpl.this.complexQCache != null) {
                    return TransactionCacheImpl.this.complexQCache.getMaxEntries();
                }
                return 0;
            }

            public int getMaxCacheSize(boolean real) {
                int size = this.getMaxCacheSize();
                if (size < 0) {
                    if (real) {
                        return -1;
                    }
                    return this.getCacheSize();
                }
                return size;
            }

            protected void setMaxCacheSize(int maxSize) throws CacheObjectException {
                try {
                    if (TransactionCacheImpl.this.isDisabled) {
                        throw new CacheObjectException("Caching is disabled");
                    }
                    if (maxSize == 0) {
                        if (TransactionCacheImpl.this.complexQCache != null) {
                            TransactionCacheImpl.this.statistics.getCacheStatistics(2).clearStatistics();
                            TransactionCacheImpl.this.complexQCache = null;
                        }
                        return;
                    }
                    if (TransactionCacheImpl.this.complexQCache == null) {
                        if (TransactionCacheImpl.this.cache != null) {
                            TransactionCacheImpl.this.complexQCache = BaseCacheManager.getDODSCache(maxSize);
                        }
                    } else {
                        TransactionCacheImpl.this.complexQCache.setMaxEntries(maxSize);
                    }
                }
                catch (Exception ex) {
                    System.out.println("Error in setMaxCacheSize - complex cache");
                }
            }

            public int getCacheSize() {
                if (TransactionCacheImpl.this.complexQCache != null) {
                    return TransactionCacheImpl.this.complexQCache.size();
                }
                return 0;
            }

            public void refresh() {
                if (TransactionCacheImpl.this.cache != null && TransactionCacheImpl.this.complexQCache != null) {
                    TransactionCacheImpl.this.complexQCache = BaseCacheManager.getDODSCache(TransactionCacheImpl.this.complexQCache.getMaxEntries());
                    TransactionCacheImpl.this.statistics.getCacheStatistics(2).setCacheHitsNum(0);
                }
            }

            public void disable() {
                if (!TransactionCacheImpl.this.isDisabledComplex) {
                    TransactionCacheImpl.this.isDisabledComplex = true;
                    if (TransactionCacheImpl.this.complexQCache != null) {
                        TransactionCacheImpl.this.disabledMaxComplexQueryCacheSize = TransactionCacheImpl.this.complexQCache.getMaxEntries();
                        TransactionCacheImpl.this.complexQCache = null;
                    } else {
                        TransactionCacheImpl.this.disabledMaxComplexQueryCacheSize = 0;
                    }
                }
            }

            public void enable() {
                try {
                    DODSLRUCache obj;
                    if (TransactionCacheImpl.this.isDisabledComplex) {
                        if (TransactionCacheImpl.this.disabledMaxComplexQueryCacheSize != 0 && TransactionCacheImpl.this.disabledMaxCacheSize != 0) {
                            TransactionCacheImpl.this.complexQCache = BaseCacheManager.getDODSCache(TransactionCacheImpl.this.disabledMaxComplexQueryCacheSize);
                        }
                        TransactionCacheImpl.this.isDisabledComplex = false;
                    }
                    if ((obj = (DODSLRUCache)TransactionCacheImpl.this.statistics.getCacheStatistics(2)) != null) {
                        obj.clearStatistics();
                    }
                }
                catch (Exception ex) {
                    System.out.println("Error in enable complex");
                }
            }
        };
        this.cacheAdministration[0] = new CacheAdministration(){

            public int getMaxCacheSize() {
                return -1;
            }

            public int getMaxCacheSize(boolean real) {
                if (real) {
                    return this.getMaxCacheSize();
                }
                return this.getCacheSize();
            }

            public int getCacheSize() {
                if (TransactionCacheImpl.this.cache != null) {
                    return TransactionCacheImpl.this.cache.size();
                }
                return 0;
            }

            protected void setMaxCacheSize(int maxSize) throws CacheObjectException {
            }

            public void refresh() {
                if (TransactionCacheImpl.this.cache != null) {
                    TransactionCacheImpl.this.cache = new DODSHashMap();
                }
                if (TransactionCacheImpl.this.simpleQCache != null) {
                    TransactionCacheImpl.this.simpleQCache = BaseCacheManager.getDODSCache(TransactionCacheImpl.this.simpleQCache.getMaxEntries());
                }
                if (TransactionCacheImpl.this.complexQCache != null) {
                    TransactionCacheImpl.this.complexQCache = BaseCacheManager.getDODSCache(TransactionCacheImpl.this.complexQCache.getMaxEntries());
                }
                TransactionCacheImpl.this.statistics.clear();
            }

            public void disable() {
                if (!TransactionCacheImpl.this.isDisabled) {
                    TransactionCacheImpl.this.isDisabled = true;
                    if (TransactionCacheImpl.this.cache != null) {
                        TransactionCacheImpl.this.cache = null;
                        if (TransactionCacheImpl.this.simpleQCache != null) {
                            TransactionCacheImpl.this.getCacheAdministration(1).disable();
                        }
                        if (TransactionCacheImpl.this.complexQCache != null) {
                            TransactionCacheImpl.this.cacheAdministration[2].disable();
                        }
                        TransactionCacheImpl.this.statistics.clear();
                    }
                }
            }

            public void enable() {
                try {
                    if (TransactionCacheImpl.this.isDisabled) {
                        TransactionCacheImpl.this.cache = new DODSHashMap();
                        if (TransactionCacheImpl.this.isDisabledSimple) {
                            TransactionCacheImpl.this.getCacheAdministration(1).enable();
                        }
                        if (TransactionCacheImpl.this.isDisabledComplex) {
                            TransactionCacheImpl.this.getCacheAdministration(2).enable();
                        }
                        TransactionCacheImpl.this.statistics.clear();
                        TransactionCacheImpl.this.isDisabled = false;
                    }
                }
                catch (Exception ex) {
                    System.out.println("Error in enable DO");
                }
            }
        };
    }

    public Map getCacheContent() {
        return this.cache;
    }

    public boolean isMulti() {
        return this.multi;
    }

    public boolean toReconfigure() {
        return false;
    }

    public synchronized GenericDO addDO(GenericDO newDO) {
        if (this.cache == null) {
            return newDO;
        }
        try {
            String handle = newDO.get_CacheHandle();
            GenericDO ret = (GenericDO)this.cache.put((Object)handle, (Object)newDO);
            return newDO;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public synchronized GenericDO removeDO(GenericDO DO) {
        if (this.cache != null) {
            try {
                String handle = DO.get_CacheHandle();
                return (GenericDO)this.cache.remove((Object)handle);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public synchronized GenericDO removeDO(String handle) {
        if (this.cache != null) {
            try {
                return (GenericDO)this.cache.remove((Object)handle);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public GenericDO updateDO(GenericDO DO) {
        HashSet<QueryCacheItem> del;
        DO = this.addDO(DO);
        QueryCacheItem queryItem2 = null;
        Iterator<Object> iter = null;
        if (this.complexQCache != null) {
            del = new HashSet<QueryCacheItem>();
            for (QueryCacheItem queryItem2 : this.complexQCache.values()) {
                if (!DO.get_OriginDatabase().equals(queryItem2.get_OriginDatabase())) continue;
                del.add(queryItem2);
            }
            iter = null;
            iter = del.iterator();
            while (iter.hasNext()) {
                this.removeComplexQuery((QueryCacheItem)iter.next());
            }
        }
        if (this.simpleQCache != null) {
            del = new HashSet();
            iter = null;
            for (QueryCacheItem queryItem2 : this.simpleQCache.values()) {
                if (queryItem2.isCompleteResult()) {
                    queryItem2.update(DO);
                    continue;
                }
                del.add(queryItem2);
            }
            iter = null;
            iter = del.iterator();
            while (iter.hasNext()) {
                this.removeSimpleQuery((QueryCacheItem)iter.next());
            }
        }
        return DO;
    }

    public GenericDO deleteDO(GenericDO DO) {
        GenericDO oldDO = this.removeDO(DO);
        Iterator iter = null;
        QueryCacheItem queryItem2 = null;
        if (this.simpleQCache != null) {
            for (QueryCacheItem queryItem2 : this.simpleQCache.values()) {
                queryItem2.delete(DO);
            }
        }
        iter = null;
        if (this.complexQCache != null) {
            for (QueryCacheItem queryItem2 : this.complexQCache.values()) {
                queryItem2.delete(DO);
            }
        }
        return oldDO;
    }

    public synchronized GenericDO getDOByHandle(String handle) {
        if (this.cache == null) {
            return null;
        }
        return (GenericDO)this.cache.get((Object)handle);
    }

    public QueryCacheItem newQueryCacheItemInstance(String dbName) {
        return new QueryCacheItemImpl(dbName);
    }

    public QueryCacheItem getSimpleQueryCacheItem(String dbName, String query) {
        if (this.simpleQCache != null) {
            return (QueryCacheItem)this.simpleQCache.get(dbName + "." + query);
        }
        return null;
    }

    public QueryCacheItem getComplexQueryCacheItem(String dbName, String query) {
        if (this.complexQCache != null) {
            return (QueryCacheItem)this.complexQCache.get(dbName + "." + query);
        }
        return null;
    }

    public synchronized QueryCacheItem addSimpleQuery(QueryCacheItem queryItem) {
        if (this.simpleQCache != null) {
            return (QueryCacheItem)this.simpleQCache.add(queryItem.get_OriginDatabase() + "." + queryItem.getQueryId(), queryItem);
        }
        return null;
    }

    public synchronized QueryCacheItem removeSimpleQuery(QueryCacheItem queryItem) {
        if (this.simpleQCache != null) {
            return (QueryCacheItem)this.simpleQCache.remove(queryItem.get_OriginDatabase() + "." + queryItem.getQueryId());
        }
        return null;
    }

    public synchronized QueryCacheItem addComplexQuery(QueryCacheItem queryItem) {
        if (this.complexQCache != null) {
            return (QueryCacheItem)this.complexQCache.add(queryItem.get_OriginDatabase() + "." + queryItem.getQueryId(), queryItem);
        }
        return null;
    }

    public synchronized QueryCacheItem removeComplexQuery(QueryCacheItem queryItem) {
        if (this.complexQCache != null) {
            return (QueryCacheItem)this.complexQCache.remove(queryItem.get_OriginDatabase() + "." + queryItem.getQueryId());
        }
        return null;
    }

    public QueryResult getSimpleQueryResults(String dbName, String query) {
        return this.getSimpleQueryResults(dbName, query, 0, 0, false);
    }

    public QueryResult getSimpleQueryResults(String dbName, String query, int limit, int maxdb) {
        return this.getSimpleQueryResults(dbName, query, limit, maxdb, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryResult getSimpleQueryResults(String dbName, String query, int limit, int maxdb, boolean unique) {
        int i;
        if (this.simpleQCache == null) {
            return null;
        }
        QueryResult result = null;
        String queryHandle = dbName + "." + query;
        QueryCacheItem queryItem = (QueryCacheItem)this.simpleQCache.get(queryHandle);
        if (queryItem != null) {
            result = new QueryResult();
            result.database = queryItem.get_OriginDatabase();
            DOShell shell = null;
            String handle = null;
            String cachePrefix = queryItem.get_OriginDatabase() + ".";
            GenericDO cacheDO = null;
            Collection collection = queryItem.getOIds();
            synchronized (collection) {
                Iterator iter = queryItem.getOIds().iterator();
                if (unique) {
                    HashSet<String> allResultOids = new HashSet<String>();
                    int skippedNum = 0;
                    for (i = 0; !(maxdb != 0 && i >= maxdb || !iter.hasNext() || limit != 0 && result.DOs.size() >= limit); ++i) {
                        handle = (String)iter.next();
                        if (allResultOids.contains(handle)) {
                            ++skippedNum;
                            continue;
                        }
                        allResultOids.add(handle);
                        try {
                            cacheDO = (GenericDO)this.cache.get((Object)(cachePrefix + handle));
                            shell = new DOShell(handle);
                            if (cacheDO != null) {
                                shell.dataObject = cacheDO;
                            } else {
                                result.lazy.add(shell);
                            }
                            result.DOs.add(shell);
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    result.skippedUnique = skippedNum;
                } else {
                    while (!(maxdb != 0 && i >= maxdb || !iter.hasNext() || limit != 0 && result.DOs.size() >= limit)) {
                        handle = (String)iter.next();
                        try {
                            cacheDO = (GenericDO)this.cache.get((Object)(cachePrefix + handle));
                            shell = new DOShell(handle);
                            if (cacheDO != null) {
                                shell.dataObject = cacheDO;
                            } else {
                                result.lazy.add(shell);
                            }
                            result.DOs.add(shell);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ++i;
                    }
                }
            }
        }
        if (result.DOs.size() < limit && (maxdb == 0 || i < maxdb)) {
            result = null;
        }
        return result;
    }

    public QueryResult getComplexQueryResults(String dbName, String query) {
        return this.getComplexQueryResults(dbName, query, 0, 0, false);
    }

    public QueryResult getComplexQueryResults(String dbName, String query, int limit, int maxdb) {
        return this.getComplexQueryResults(dbName, query, limit, maxdb, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryResult getComplexQueryResults(String dbName, String query, int limit, int maxdb, boolean unique) {
        int i;
        if (this.complexQCache == null) {
            return null;
        }
        QueryResult result = null;
        String queryHandle = dbName + "." + query;
        QueryCacheItem queryItem = (QueryCacheItem)this.complexQCache.get(queryHandle);
        if (queryItem != null) {
            result = new QueryResult();
            result.database = queryItem.get_OriginDatabase();
            DOShell shell = null;
            String handle = null;
            String cachePrefix = queryItem.get_OriginDatabase() + ".";
            GenericDO cacheDO = null;
            Collection collection = queryItem.getOIds();
            synchronized (collection) {
                Iterator iter = queryItem.getOIds().iterator();
                if (unique) {
                    HashSet<String> allResultOids = new HashSet<String>();
                    int skippedNum = 0;
                    for (i = 0; !(maxdb != 0 && i >= maxdb || !iter.hasNext() || limit != 0 && result.DOs.size() >= limit); ++i) {
                        handle = (String)iter.next();
                        if (allResultOids.contains(handle)) {
                            ++skippedNum;
                            continue;
                        }
                        allResultOids.add(handle);
                        try {
                            cacheDO = (GenericDO)this.cache.get((Object)(cachePrefix + handle));
                            shell = new DOShell(handle);
                            if (cacheDO != null) {
                                shell.dataObject = cacheDO;
                            } else {
                                result.lazy.add(shell);
                            }
                            result.DOs.add(shell);
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    result.skippedUnique = skippedNum;
                } else {
                    while (!(maxdb != 0 && i >= maxdb || !iter.hasNext() || limit != 0 && result.DOs.size() >= limit)) {
                        handle = (String)iter.next();
                        try {
                            cacheDO = (GenericDO)this.cache.get((Object)(cachePrefix + handle));
                            shell = new DOShell(handle);
                            if (cacheDO != null) {
                                shell.dataObject = cacheDO;
                            } else {
                                result.lazy.add(shell);
                            }
                            result.DOs.add(shell);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ++i;
                    }
                }
            }
        }
        if (result.DOs.size() < limit && (maxdb == 0 || i < maxdb)) {
            result = null;
        }
        return result;
    }

    public QueryResult getQueryResults(String dbName, String query) {
        QueryResult result = this.getSimpleQueryResults(dbName, query);
        if (result == null) {
            result = this.getComplexQueryResults(dbName, query);
        }
        return result;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("\n TransactionCacheImpl: ");
        ret.append("\n cache: " + this.cache);
        ret.append("\n simpleQCache : " + this.simpleQCache);
        ret.append("\n complexQCache : " + this.complexQCache);
        ret.append("\n cacheReadOnly : " + this.tableConf.isReadOnly());
        ret.append("\n initialQueryCache : " + this.initialQueryCache);
        ret.append("\n fullCaching : " + this.isFull());
        return ret.toString();
    }

    public void removeEntries(Vector vec) {
        if (this.cache.size() > vec.size()) {
            Enumeration e = vec.elements();
            while (e.hasMoreElements()) {
                String cacheHandle = (String)e.nextElement();
                this.removeDO(cacheHandle);
            }
        } else {
            Iterator it = this.cache.values().iterator();
            Vector<GenericDO> vecToRemove = new Vector<GenericDO>();
            while (it.hasNext()) {
                GenericDO obj = (GenericDO)it.next();
                try {
                    if (!vec.contains(obj.get_CacheHandle())) continue;
                    vecToRemove.add(obj);
                }
                catch (DatabaseManagerException databaseManagerException) {}
            }
            Enumeration e = vecToRemove.elements();
            while (e.hasMoreElements()) {
                this.removeDO((GenericDO)e.nextElement());
            }
        }
    }

    public void removeEntries(Class tableClass) {
        Iterator it = this.cache.values().iterator();
        Vector<GenericDO> vecToRemove = new Vector<GenericDO>();
        while (it.hasNext()) {
            GenericDO obj = (GenericDO)it.next();
            if (!tableClass.equals(obj.getClass())) continue;
            vecToRemove.add(obj);
        }
        Enumeration e = vecToRemove.elements();
        while (e.hasMoreElements()) {
            this.removeDO((GenericDO)e.nextElement());
        }
    }

    public void emptyEntries(Vector vec, boolean incrementVersion) {
        Enumeration e = vec.elements();
        while (e.hasMoreElements()) {
            String cacheHandle = (String)e.nextElement();
            GenericDO obj = (GenericDO)this.cache.get((Object)cacheHandle);
            if (obj == null) continue;
            obj.dumpData(incrementVersion);
        }
    }

    public void emptyEntries(Class tableClass) {
        Collection c = this.cache.values();
        for (GenericDO obj : c) {
            if (!tableClass.equals(obj.getClass())) continue;
            obj.dumpData(false);
        }
    }

    public int getInitialCacheFetchSize() {
        return this.initialCacheFetchSize;
    }

    public int getInitialDSCacheSize() {
        return this.initialDSCacheSize;
    }

    public void setInitialCacheFetchSize(int i) {
        this.initialCacheFetchSize = i;
    }

    public void setInitialDSCacheSize(int i) {
        this.initialDSCacheSize = i;
    }

    private class QueryCacheImplStatistics
    extends TableStatistics {
        public QueryCacheImplStatistics() {
            try {
                this.reset();
                if (TransactionCacheImpl.this.cache != null) {
                    this.getCacheStatistics(0).clearStatistics();
                }
                if (TransactionCacheImpl.this.simpleQCache != null) {
                    this.getCacheStatistics(1).clearStatistics();
                }
                if (TransactionCacheImpl.this.complexQCache != null) {
                    this.getCacheStatistics(2).clearStatistics();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void reset() {
            this.insertNum = 0;
            this.updateNum = 0;
            this.deleteNum = 0;
            this.lazyLoadingNum = 0;
            this.startTime = new Date();
            this.stopTime = new Date();
            this.queryNum = 0;
            this.queryByOIdNum = 0;
            this.averageQueryTime = 0;
            this.averageQueryByOIdTime = 0;
        }

        public int getStatisticsType() {
            return 2;
        }

        public void clear() {
            this.reset();
            if (TransactionCacheImpl.this.cache != null) {
                this.getCacheStatistics(0).clearStatistics();
            }
            if (TransactionCacheImpl.this.simpleQCache != null) {
                this.getCacheStatistics(1).clearStatistics();
            }
            if (TransactionCacheImpl.this.complexQCache != null) {
                this.getCacheStatistics(2).clearStatistics();
            }
        }

        public CacheStatistics getCacheStatistics(int type) {
            switch (type) {
                case 0: {
                    return TransactionCacheImpl.this.cache;
                }
                case 1: {
                    return TransactionCacheImpl.this.simpleQCache;
                }
                case 2: {
                    return TransactionCacheImpl.this.complexQCache;
                }
            }
            return null;
        }
    }
}

