/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.dods.cache.hash;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class LinkedHashCache
implements Map {
    private Map impl;
    protected int maxEntries = 1024;

    private static Map createMap(int initialCapacity, float loadFactor, boolean flag) {
        Map ret = null;
        try {
            ret = (Map)Class.forName("java.util.LinkedHashMap").getConstructor(Integer.TYPE, Float.TYPE, Boolean.TYPE).newInstance(new Integer(initialCapacity), new Float(loadFactor), new Boolean(flag));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ret;
    }

    public LinkedHashCache(int initialCapacity, float loadFactor, int maxEnt) {
        this.impl = LinkedHashCache.createMap(initialCapacity, loadFactor, false);
        this.maxEntries = maxEnt;
    }

    public LinkedHashCache(int initialCapacity, float loadFactor) {
        this.impl = LinkedHashCache.createMap(initialCapacity, loadFactor, false);
    }

    public LinkedHashCache(int maxEnt) {
        this.impl = LinkedHashCache.createMap(16, 0.75f, false);
        this.maxEntries = maxEnt;
    }

    public LinkedHashCache() {
        this.impl = LinkedHashCache.createMap(16, 0.75f, false);
    }

    public LinkedHashCache(Map m, int maxEnt) {
        this.impl = LinkedHashCache.createMap(16, 0.75f, false);
        this.maxEntries = maxEnt;
        this.impl.putAll(m);
    }

    public LinkedHashCache(Map m) {
        this.impl = LinkedHashCache.createMap(16, 0.75f, false);
        this.impl.putAll(m);
    }

    public Object add(Object key, Object value) {
        Object ret = this.impl.put(key, value);
        if (ret == null && this.maxEntries < this.size() && this.maxEntries > 0) {
            Iterator iter = this.impl.keySet().iterator();
            Object rem = iter.next();
            ret = this.impl.remove(rem);
        }
        return ret;
    }

    public int getMaxEntries() {
        return this.maxEntries;
    }

    public void setMaxEntries(int max) {
        if (max < this.size() && max > 0) {
            Iterator iter = new HashSet(this.impl.keySet()).iterator();
            int dif = this.size() - max;
            for (int i = 0; i < dif; ++i) {
                this.impl.remove(iter.next());
            }
        }
        this.maxEntries = max;
    }

    public String toString() {
        Object[] v = this.impl.entrySet().toArray();
        String ret = "LRU content:\n";
        for (int i = 0; i < v.length; ++i) {
            Map.Entry map = (Map.Entry)v[i];
            ret = ret + i + ". key = " + map.getKey() + "  value = " + map.getValue() + "\n";
        }
        return ret;
    }

    @Override
    public int size() {
        return this.impl.size();
    }

    @Override
    public boolean isEmpty() {
        return this.impl.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) throws ClassCastException, NullPointerException {
        return this.impl.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) throws ClassCastException, NullPointerException {
        return this.impl.containsValue(value);
    }

    public Object get(Object key) throws ClassCastException, NullPointerException {
        return this.impl.get(key);
    }

    public Object put(Object key, Object value) throws ClassCastException, NullPointerException, UnsupportedOperationException, IllegalArgumentException {
        return this.impl.put(key, value);
    }

    public synchronized Object remove(Object key) throws ClassCastException, NullPointerException, UnsupportedOperationException {
        return this.impl.remove(key);
    }

    public void putAll(Map t) throws ClassCastException, NullPointerException, UnsupportedOperationException, IllegalArgumentException {
        this.impl.putAll(t);
    }

    @Override
    public void clear() throws UnsupportedOperationException {
        this.impl.clear();
    }

    public Set keySet() {
        return this.impl.keySet();
    }

    public Collection values() {
        return this.impl.values();
    }

    public Set entrySet() {
        return this.impl.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof LinkedHashCache && this.impl.equals(((LinkedHashCache)o).impl);
    }

    @Override
    public int hashCode() {
        return this.impl.hashCode();
    }
}

