
/*
 * Created on May 18, 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.enhydra.dods.cache.base;

import org.enhydra.dods.DODS;
import org.enhydra.dods.cache.CacheConstants;

import com.lutris.appserver.server.sql.DatabaseManagerException;
import com.lutris.appserver.server.sql.standard.StandardLogicalDatabase;
import com.lutris.logging.Logger;

/**
 * @author P.Djojic May 18, 2005 11:47:11 PM
 *
 * TODO BaseCacheManager
 */
public class BaseCacheManager {
    
    private static DODSCacheAbstractFactory cacheFactory = null;
    
    public static boolean isCacheManagerConfigured() {
        return cacheFactory!=null;
    }
    
    private static void configureCacheFactory() {
        String  logicalDbName = null;
        String  cacheFactoryClassName = null;
        Class   cacheFactoryClass = null;
        try {
            logicalDbName = DODS.getDatabaseManager().getDefaultDB();
            cacheFactoryClassName = ((StandardLogicalDatabase)DODS
                                                .getDatabaseManager()
                                                .findLogicalDatabase(logicalDbName))
                                                .getDatabaseConfiguration()
                                                .getDodsCacheFactory();
            if (cacheFactoryClassName != null) {
                try {
                    cacheFactoryClass = Class.forName(cacheFactoryClassName);
                    cacheFactory = (DODSCacheAbstractFactory)cacheFactoryClass.newInstance();
                } catch (Exception  e) {
                    DODS.getLogChannel()
                        .write(Logger.ERROR,
                        "Failed to make DODSCacheFactory  :"
                        + cacheFactoryClassName
                        + " creating " 
                        + CacheConstants.DEFAULT_DODS_CACHE_FACTORY
                        + " instead");
                    cacheFactory = null;
                }
            }
            if (cacheFactoryClassName == null || cacheFactory == null) {
                try {
                    cacheFactoryClass = Class.forName(CacheConstants.DEFAULT_DODS_CACHE_FACTORY);
                    cacheFactory = (DODSCacheAbstractFactory) cacheFactoryClass.newInstance();
                } catch (Exception  e) {
                    String  str = "Failed to make "+CacheConstants.DEFAULT_DODS_CACHE_FACTORY;
                    DODS.getLogChannel().write(Logger.CRITICAL, str);
                    throw new Error (str);
                }
            }
        } catch (DatabaseManagerException e){
            DODS.getLogChannel().write(Logger.CRITICAL,"Failed to make DODSCacheFactory - CRITICAL ERROR");
        }
    }
    
    public static DODSCache getDODSCache(int maxSize) {
        if(!isCacheManagerConfigured()) {
            configureCacheFactory();
        }
            return cacheFactory.newDODSCache(maxSize);
    }
}
