/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.xpdl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xerces.util.XMLChar;
import org.enhydra.shark.xpdl.PackageValidator;
import org.enhydra.shark.xpdl.ParsingErrors;
import org.enhydra.shark.xpdl.XMLAttribute;
import org.enhydra.shark.xpdl.XMLCollection;
import org.enhydra.shark.xpdl.XMLCollectionElement;
import org.enhydra.shark.xpdl.XMLComplexChoice;
import org.enhydra.shark.xpdl.XMLComplexElement;
import org.enhydra.shark.xpdl.XMLElement;
import org.enhydra.shark.xpdl.XMLInterface;
import org.enhydra.shark.xpdl.XMLInterfaceForJDK13;
import org.enhydra.shark.xpdl.XMLSimpleElement;
import org.enhydra.shark.xpdl.elements.Activities;
import org.enhydra.shark.xpdl.elements.Activity;
import org.enhydra.shark.xpdl.elements.ActivitySet;
import org.enhydra.shark.xpdl.elements.ActivitySets;
import org.enhydra.shark.xpdl.elements.ActualParameter;
import org.enhydra.shark.xpdl.elements.ActualParameters;
import org.enhydra.shark.xpdl.elements.BasicType;
import org.enhydra.shark.xpdl.elements.BlockActivity;
import org.enhydra.shark.xpdl.elements.Condition;
import org.enhydra.shark.xpdl.elements.DataType;
import org.enhydra.shark.xpdl.elements.DataTypes;
import org.enhydra.shark.xpdl.elements.Deadlines;
import org.enhydra.shark.xpdl.elements.DeclaredType;
import org.enhydra.shark.xpdl.elements.EnumerationType;
import org.enhydra.shark.xpdl.elements.EnumerationValue;
import org.enhydra.shark.xpdl.elements.ExtendedAttribute;
import org.enhydra.shark.xpdl.elements.ExtendedAttributes;
import org.enhydra.shark.xpdl.elements.FinishMode;
import org.enhydra.shark.xpdl.elements.FormalParameter;
import org.enhydra.shark.xpdl.elements.FormalParameters;
import org.enhydra.shark.xpdl.elements.Join;
import org.enhydra.shark.xpdl.elements.Manual;
import org.enhydra.shark.xpdl.elements.Namespace;
import org.enhydra.shark.xpdl.elements.Namespaces;
import org.enhydra.shark.xpdl.elements.Package;
import org.enhydra.shark.xpdl.elements.RedefinableHeader;
import org.enhydra.shark.xpdl.elements.Responsible;
import org.enhydra.shark.xpdl.elements.Responsibles;
import org.enhydra.shark.xpdl.elements.SchemaType;
import org.enhydra.shark.xpdl.elements.Split;
import org.enhydra.shark.xpdl.elements.StartMode;
import org.enhydra.shark.xpdl.elements.SubFlow;
import org.enhydra.shark.xpdl.elements.Tools;
import org.enhydra.shark.xpdl.elements.Transition;
import org.enhydra.shark.xpdl.elements.TransitionRef;
import org.enhydra.shark.xpdl.elements.TransitionRefs;
import org.enhydra.shark.xpdl.elements.TransitionRestriction;
import org.enhydra.shark.xpdl.elements.TransitionRestrictions;
import org.enhydra.shark.xpdl.elements.Transitions;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class XMLUtil {
    public static final String XMLNS = "http://www.wfmc.org/2002/XPDL1.0";
    public static final String XMLNS_XPDL = "http://www.wfmc.org/2002/XPDL1.0";
    public static final String XMLNS_XSI = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String XSI_SCHEMA_LOCATION = "http://www.wfmc.org/2002/XPDL1.0 http://wfmc.org/standards/docs/TC-1025_schema_10_xpdl.xsd";
    private static ResourceBundle defaultResources;
    private static ResourceBundle choosenResources;
    private static Properties properties;
    private static boolean logging;

    public static void setDefaultResources(ResourceBundle defaultR) {
        defaultResources = defaultR;
    }

    public static void setChoosenResources(ResourceBundle choosenR) {
        choosenResources = choosenR;
    }

    public static void setProperties(Properties props) {
        properties = props;
    }

    public static String getLanguageDependentString(String nm) {
        String str;
        try {
            str = choosenResources.getString(nm);
        }
        catch (MissingResourceException mre) {
            try {
                str = defaultResources.getString(nm);
            }
            catch (MissingResourceException mre1) {
                str = null;
            }
            catch (NullPointerException npe) {
                str = null;
            }
        }
        catch (NullPointerException npe) {
            ResourceBundle orig = ResourceBundle.getBundle("org.enhydra.shark.xpdl.resources.SharkXPDL");
            try {
                str = orig.getString(nm);
            }
            catch (Exception ex) {
                str = null;
            }
        }
        return str;
    }

    public static URL getResource(String key) {
        try {
            String name = properties.getProperty(key);
            if (name != null) {
                URL url = XMLUtil.class.getClassLoader().getResource(name);
                return url;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static int howManyStringsWithinString(String toSearch, String toFind) {
        try {
            int fnd;
            int startAt = 0;
            int howMany = 0;
            while ((fnd = toSearch.indexOf(toFind, startAt)) != -1) {
                ++howMany;
                startAt = fnd + toFind.length();
            }
            return howMany;
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public static String getCanonicalPath(String relpath, String basedir, boolean canBeDirectory) {
        File f = new File(relpath);
        if (!f.isAbsolute() && !(f = f.getAbsoluteFile()).exists()) {
            f = new File(XMLUtil.createPath(basedir, relpath));
        }
        if (!f.exists() || f.isDirectory() && !canBeDirectory) {
            System.err.println("The file " + f.getAbsolutePath() + " does not exist");
            return null;
        }
        return XMLUtil.getCanonicalPath(f);
    }

    public static String getCanonicalPath(String path, boolean canBeDirectory) {
        File f = new File(path);
        if (!f.isAbsolute()) {
            f = new File(System.getProperty("user.dir") + File.separator + path);
        }
        if (!f.exists() || f.isDirectory() && !canBeDirectory) {
            System.err.println("The file " + f.getAbsolutePath() + " does not exist");
            return null;
        }
        return XMLUtil.getCanonicalPath(f);
    }

    private static String getCanonicalPath(File f) {
        try {
            return f.getCanonicalPath();
        }
        catch (Exception ex) {
            return f.getAbsolutePath();
        }
    }

    public static void fromXML(Element node, Package pkg) {
        NamedNodeMap attribs = node.getAttributes();
        Namespaces nss = pkg.getNamespaces();
        for (int i = 0; i < attribs.getLength(); ++i) {
            Node n = attribs.item(i);
            String nn = n.getNodeName();
            if (!nn.startsWith("xmlns:") || nn.equals("xmlns:xsi")) continue;
            Namespace ns = (Namespace)nss.generateNewElement();
            ns.setName(nn.substring(6, nn.length()));
            XMLUtil.fromXML(n, (XMLAttribute)ns.get("location"));
            nss.add(ns);
        }
        XMLUtil.fromXML((Node)node, (XMLComplexElement)pkg);
    }

    public static void fromXML(Node node, XMLCollection cel) {
        if (node == null || !node.hasChildNodes()) {
            return;
        }
        String nameSpacePrefix = XMLUtil.getNameSpacePrefix(node);
        XMLElement newOne = cel.generateNewElement();
        String elName = newOne.toName();
        NodeList children = node.getChildNodes();
        int lng = children.getLength();
        if (logging) {
            System.out.println("FROMXML for " + cel.toName() + ", c=" + cel.getClass().getName());
        }
        for (int i = 0; i < lng; ++i) {
            Node child = children.item(i);
            if (!child.getNodeName().equals(nameSpacePrefix + elName)) continue;
            newOne = cel.generateNewElement();
            if (newOne instanceof XMLComplexElement) {
                XMLUtil.fromXML(children.item(i), (XMLComplexElement)newOne);
            } else {
                XMLUtil.fromXML(children.item(i), (XMLSimpleElement)newOne);
            }
            cel.add(newOne);
        }
    }

    public static void fromXML(Node node, XMLComplexElement cel) {
        if (node == null || !node.hasChildNodes() && !node.hasAttributes()) {
            return;
        }
        String nameSpacePrefix = node.getPrefix();
        nameSpacePrefix = nameSpacePrefix != null ? nameSpacePrefix + ":" : "";
        if (logging) {
            System.out.println("FROMXML for " + cel.toName() + ", c=" + cel.getClass().getName());
        }
        if (node.hasAttributes()) {
            NamedNodeMap attribs = node.getAttributes();
            for (int i = 0; i < attribs.getLength(); ++i) {
                Node attrib = attribs.item(i);
                try {
                    XMLUtil.fromXML(attrib, (XMLAttribute)cel.get(attrib.getNodeName()));
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
        if (node.hasChildNodes()) {
            String newVal;
            if (cel instanceof Condition && (newVal = node.getChildNodes().item(0).getNodeValue()) != null) {
                cel.setValue(newVal);
            }
            if (cel instanceof SchemaType) {
                NodeList nl = node.getChildNodes();
                for (int j = 0; j < nl.getLength(); ++j) {
                    Node sn = nl.item(j);
                    if (!(sn instanceof Element)) continue;
                    cel.setValue(XMLUtil.getContent(sn, true));
                    break;
                }
            }
            if (cel instanceof ExtendedAttribute) {
                cel.setValue(XMLUtil.getChildNodesContent(node));
            }
            for (XMLElement el : cel.getXMLElements()) {
                Node child;
                String elName = el.toName();
                if (el instanceof XMLComplexElement) {
                    child = XMLUtil.getChildByName(node, nameSpacePrefix + elName);
                    XMLUtil.fromXML(child, (XMLComplexElement)el);
                    continue;
                }
                if (el instanceof Deadlines) {
                    XMLUtil.fromXML(node, (XMLCollection)el);
                    continue;
                }
                if (el instanceof XMLCollection) {
                    child = XMLUtil.getChildByName(node, nameSpacePrefix + elName);
                    XMLUtil.fromXML(child, (XMLCollection)el);
                    continue;
                }
                if (el instanceof XMLComplexChoice) {
                    XMLUtil.fromXML(node, (XMLComplexChoice)el);
                    continue;
                }
                if (!(el instanceof XMLSimpleElement)) continue;
                child = XMLUtil.getChildByName(node, nameSpacePrefix + elName);
                XMLUtil.fromXML(child, (XMLSimpleElement)el);
            }
        }
    }

    public static void fromXML(Node node, XMLComplexChoice el) {
        String nameSpacePrefix = XMLUtil.getNameSpacePrefix(node);
        ArrayList ch = el.getChoices();
        if (logging) {
            System.out.println("FROMXML for " + el.toName() + ", c=" + el.getClass().getName());
        }
        for (int i = 0; i < ch.size(); ++i) {
            Node child;
            XMLElement chc = (XMLElement)ch.get(i);
            String chname = chc.toName();
            if (chname.equals("Tools")) {
                chname = "Tool";
            }
            if ((child = XMLUtil.getChildByName(node, nameSpacePrefix + chname)) == null) continue;
            if (chc instanceof XMLComplexElement) {
                XMLUtil.fromXML(child, (XMLComplexElement)chc);
            } else if (chc instanceof Tools) {
                XMLUtil.fromXML(node, (XMLCollection)chc);
            } else {
                XMLUtil.fromXML(child, (XMLCollection)chc);
            }
            el.setChoosen(chc);
            break;
        }
    }

    public static void fromXML(Node node, XMLSimpleElement el) {
        XMLUtil.fromXMLBasic(node, el);
    }

    public static void fromXML(Node node, XMLAttribute el) {
        XMLUtil.fromXMLBasic(node, el);
    }

    public static void fromXMLBasic(Node node, XMLElement el) {
        if (node != null) {
            String newVal;
            if (logging) {
                System.out.println("FROMXML for " + el.toName() + ", c=" + el.getClass().getName());
            }
            if (node.hasChildNodes()) {
                newVal = node.getChildNodes().item(0).getNodeValue();
                if (logging) {
                    System.out.println("11111");
                }
            } else {
                if (logging) {
                    System.out.println("22222");
                }
                newVal = node.getNodeValue();
            }
            if (logging) {
                System.out.println("NV=" + newVal);
            }
            if (newVal != null) {
                el.setValue(newVal);
            }
        }
    }

    public static void toXML(Document parent, Package pkg) {
        Element node = parent.createElement(pkg.toName());
        node.setAttribute("xmlns", "http://www.wfmc.org/2002/XPDL1.0");
        for (Namespace ns : pkg.getNamespaces().toElements()) {
            node.setAttribute("xmlns:" + ns.getName(), ns.getLocation());
        }
        node.setAttribute("xmlns:xsi", XMLNS_XSI);
        node.setAttribute("xsi:schemaLocation", XSI_SCHEMA_LOCATION);
        XMLUtil.toXML((Node)node, (XMLComplexElement)pkg);
        parent.appendChild(node);
    }

    public static void toXML(Node parent, XMLCollection cel) {
        if ((!cel.isEmpty() || cel.isRequired()) && parent != null) {
            String elName = cel.toName();
            Node node = parent;
            if (!elName.equals("Deadlines") && !elName.equals("Tools")) {
                node = parent.getOwnerDocument().createElement(elName);
            }
            for (XMLElement el : cel.toElements()) {
                if (el instanceof XMLSimpleElement) {
                    XMLUtil.toXML(node, (XMLSimpleElement)el);
                    continue;
                }
                XMLUtil.toXML(node, (XMLComplexElement)el);
            }
            if (node != parent) {
                parent.appendChild(node);
            }
        }
    }

    public static void toXML(Node parent, XMLComplexElement cel) {
        if (cel.isEmpty() && !cel.isRequired()) {
            return;
        }
        if (parent != null) {
            if (logging) {
                System.out.println("TOXML for " + cel.toName() + ", c=" + cel.getClass().getName());
            }
            Node node = parent;
            if (!(cel instanceof Package)) {
                node = parent.getOwnerDocument().createElement(cel.toName());
            }
            if (cel.toValue() != null && cel.toValue().length() > 0) {
                Node schema;
                if (cel instanceof Condition && !cel.toValue().equals("")) {
                    Text textNode = node.getOwnerDocument().createTextNode(cel.toValue());
                    node.appendChild(textNode);
                }
                if (cel instanceof SchemaType && (schema = XMLUtil.parseSchemaNode(cel.toValue(), false)) != null) {
                    node.appendChild(node.getOwnerDocument().importNode(schema, true));
                }
                if (cel instanceof ExtendedAttribute) {
                    try {
                        Node n = XMLUtil.parseExtendedAttributeContent(cel.toValue());
                        NodeList nl = n.getChildNodes();
                        for (int i = 0; i < nl.getLength(); ++i) {
                            node.appendChild(parent.getOwnerDocument().importNode(nl.item(i), true));
                        }
                    }
                    catch (Exception n) {
                        // empty catch block
                    }
                }
            }
            for (XMLElement el : cel.toElements()) {
                if (el instanceof XMLComplexElement) {
                    XMLUtil.toXML(node, (XMLComplexElement)el);
                    continue;
                }
                if (el instanceof XMLCollection) {
                    XMLUtil.toXML(node, (XMLCollection)el);
                    continue;
                }
                if (el instanceof XMLComplexChoice) {
                    XMLUtil.toXML(node, (XMLComplexChoice)el);
                    continue;
                }
                if (el instanceof XMLSimpleElement) {
                    XMLUtil.toXML(node, (XMLSimpleElement)el);
                    continue;
                }
                XMLUtil.toXML(node, (XMLAttribute)el);
            }
            if (node != parent) {
                parent.appendChild(node);
            }
        }
    }

    public static void toXML(Node parent, XMLComplexChoice el) {
        XMLElement choosen = el.getChoosen();
        if (choosen != null) {
            if (choosen instanceof XMLComplexElement) {
                XMLUtil.toXML(parent, (XMLComplexElement)choosen);
            } else {
                XMLUtil.toXML(parent, (XMLCollection)choosen);
            }
        }
    }

    public static void toXML(Node parent, XMLSimpleElement el) {
        if ((!el.isEmpty() || el.isRequired()) && parent != null) {
            Element node = parent.getOwnerDocument().createElement(el.toName());
            node.appendChild(parent.getOwnerDocument().createTextNode(el.toValue().trim()));
            parent.appendChild(node);
        }
    }

    public static void toXML(Node parent, XMLAttribute el) {
        if ((!el.isEmpty() || el.isRequired()) && parent != null) {
            Attr node = parent.getOwnerDocument().createAttribute(el.toName());
            node.setValue(el.toValue().trim());
            ((Element)parent).setAttributeNode(node);
        }
    }

    public static String getNameSpacePrefix(Node node) {
        String nameSpacePrefix = node.getPrefix();
        nameSpacePrefix = nameSpacePrefix != null ? nameSpacePrefix + ":" : "";
        return nameSpacePrefix;
    }

    public static Node getChildByName(Node parent, String childName) {
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!child.getNodeName().equals(childName)) continue;
            return child;
        }
        return null;
    }

    public static String getId(Node node) {
        try {
            NamedNodeMap nnm = node.getAttributes();
            Node attrib = nnm.getNamedItem("Id");
            String ID = attrib.hasChildNodes() ? attrib.getChildNodes().item(0).getNodeValue() : attrib.getNodeValue();
            return ID.toString();
        }
        catch (Exception ex) {
            return "";
        }
    }

    public static String getContent(Node node, boolean omitXMLDeclaration) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.setOutputProperty("encoding", "UTF-8");
            if (omitXMLDeclaration) {
                transformer.setOutputProperty("omit-xml-declaration", "yes");
            }
            DOMSource source = new DOMSource(node);
            StreamResult result = new StreamResult(baos);
            transformer.transform(source, result);
            String cont = baos.toString("UTF8");
            baos.close();
            return cont;
        }
        catch (Exception ex) {
            return "";
        }
    }

    public static String getChildNodesContent(Node node) {
        String txt = "";
        if (node != null && node.hasChildNodes()) {
            txt = XMLUtil.getContent(node, true);
            try {
                Node fc = node.getFirstChild();
                String fcnc = XMLUtil.getContent(fc, true);
                String closedTag = "</" + node.getNodeName() + ">";
                if (fcnc.trim().length() > 0) {
                    fcnc = fcnc.trim();
                }
                int i1 = txt.indexOf(fcnc);
                int i2 = txt.lastIndexOf(closedTag);
                txt = txt.substring(i1, i2).trim();
            }
            catch (Exception ex) {
                NodeList nl = node.getChildNodes();
                txt = "";
                try {
                    for (int i = 0; i < nl.getLength(); ++i) {
                        Node sn = nl.item(i);
                        if (sn instanceof Element) {
                            txt = txt + XMLUtil.getContent(sn, true);
                            continue;
                        }
                        String nv = sn.getNodeValue();
                        if (i > 0) {
                            txt = txt + nv.substring(1);
                            continue;
                        }
                        if (i == 0 && nv.trim().length() == 0) continue;
                        txt = txt + nv;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return txt;
    }

    public static String getShortClassName(String fullClassName) {
        int lastDot = fullClassName.lastIndexOf(".");
        if (lastDot >= 0) {
            return fullClassName.substring(lastDot + 1, fullClassName.length());
        }
        return fullClassName;
    }

    public static String getExternalPackageId(String extPkgHref) {
        int indBSL = extPkgHref.lastIndexOf("\\");
        int indSL = extPkgHref.lastIndexOf("/");
        int indDotXPDL = extPkgHref.lastIndexOf(".xpdl");
        if (indSL != -1 || indBSL != -1) {
            int ind = indSL;
            if (indBSL > indSL) {
                ind = indBSL;
            }
            extPkgHref = extPkgHref.substring(indSL + 1);
        }
        if (indDotXPDL != -1) {
            extPkgHref = extPkgHref.substring(0, extPkgHref.length() - 5);
        }
        return extPkgHref;
    }

    public static Node parseSchemaNode(String toParse, boolean isFile) {
        Document document = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        try {
            ParsingErrors pErrors = new ParsingErrors();
            DocumentBuilder parser = factory.newDocumentBuilder();
            parser.setErrorHandler(pErrors);
            if (isFile) {
                File f = new File(toParse);
                if (!f.exists()) {
                    throw new Exception();
                }
                document = parser.parse(new InputSource(new FileInputStream(f)));
            } else {
                document = parser.parse(new InputSource(new StringReader(toParse)));
            }
            Set errorMessages = pErrors.getErrorMessages();
            if (errorMessages.size() > 0) {
                System.err.println("Errors in schema type");
            }
        }
        catch (Exception ex) {
            System.err.println("Fatal error while parsing xml schema document");
            return null;
        }
        if (document != null) {
            return document.getDocumentElement();
        }
        return null;
    }

    public static String stringifyExtendedAttributes(ExtendedAttributes extAttribs) throws Exception {
        try {
            ExtendedAttributes easclone = (ExtendedAttributes)extAttribs.clone();
            easclone.setParent(null);
            for (ExtendedAttribute ea : easclone.toElements()) {
                ea.setParent(null);
                ea.get("Name").setParent(null);
                ea.get("Value").setParent(null);
            }
            return XMLUtil.getExtendedAttributesString(easclone);
        }
        catch (Throwable thr) {
            throw new Exception("Can't stringify extended attributes, error=" + thr.getMessage() + " !");
        }
    }

    public static ExtendedAttributes destringyfyExtendedAttributes(String extAttribs) throws Exception {
        ExtendedAttributes extAttr = null;
        if (extAttribs != null && !extAttribs.trim().equals("")) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                DocumentBuilder parser = factory.newDocumentBuilder();
                Document document = null;
                document = parser.parse(new InputSource(new StringReader(extAttribs)));
                extAttr = new ExtendedAttributes(null);
                if (document != null) {
                    XMLUtil.fromXML((Node)document.getDocumentElement(), extAttr);
                }
                return extAttr;
            }
            catch (Throwable thr) {
                thr.printStackTrace();
                throw new Exception("Failed to destringify extended attributes, error=" + thr.getMessage() + " !");
            }
        }
        return extAttr;
    }

    public static Node parseExtendedAttributeContent(String toParse) {
        Document document = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        try {
            ParsingErrors pErrors = new ParsingErrors();
            DocumentBuilder parser = factory.newDocumentBuilder();
            parser.setErrorHandler(pErrors);
            toParse = "<ExtAttribsAddition>" + toParse + "</ExtAttribsAddition>";
            document = parser.parse(new InputSource(new StringReader(toParse)));
            Set errorMessages = pErrors.getErrorMessages();
            if (errorMessages.size() > 0) {
                System.err.println("Errors in ext attribs complex content");
            }
        }
        catch (Exception ex) {
            System.err.println("Fatal error while parsing ext. attributes complex content " + toParse);
            return null;
        }
        if (document != null) {
            return document.getDocumentElement();
        }
        return null;
    }

    public static String getExtendedAttributeValue(String[][] extendedAttributes, String extAttrName) {
        if (extendedAttributes != null) {
            for (int i = 0; i < extendedAttributes.length; ++i) {
                if (!extendedAttributes[i][0].equals(extAttrName)) continue;
                return extendedAttributes[i][1];
            }
        }
        return null;
    }

    public static Package getPackage(XMLElement el) {
        while (!(el instanceof Package) && (el = el.getParent()) != null) {
        }
        return (Package)el;
    }

    public static WorkflowProcess getWorkflowProcess(XMLElement el) {
        while (!(el instanceof WorkflowProcess) && (el = el.getParent()) != null) {
        }
        return (WorkflowProcess)el;
    }

    public static Activity getActivity(XMLElement el) {
        while (!(el instanceof Activity) && (el = el.getParent()) != null) {
        }
        return (Activity)el;
    }

    public static Join getJoin(Activity act) {
        Join j = null;
        TransitionRestrictions trs = act.getTransitionRestrictions();
        if (trs.size() > 0) {
            j = ((TransitionRestriction)trs.get(0)).getJoin();
        }
        return j;
    }

    public static Split getSplit(Activity act) {
        Split s = null;
        TransitionRestrictions trs = act.getTransitionRestrictions();
        if (trs.size() > 0) {
            s = ((TransitionRestriction)trs.get(0)).getSplit();
        }
        return s;
    }

    public static Set getOutgoingTransitions(Activity act) {
        HashSet<Transition> s = new HashSet<Transition>();
        for (Transition t : ((Transitions)((XMLCollectionElement)act.getParent().getParent()).get("Transitions")).toElements()) {
            if (!t.getFrom().equals(act.getId())) continue;
            s.add(t);
        }
        return s;
    }

    public static Set getExceptionalOutgoingTransitions(Activity act) {
        HashSet<Transition> s = new HashSet<Transition>();
        for (Transition t : ((Transitions)((XMLCollectionElement)act.getParent().getParent()).get("Transitions")).toElements()) {
            String ct;
            if (!t.getFrom().equals(act.getId()) || !(ct = t.getCondition().getType()).equals("EXCEPTION") && !ct.equals("DEFAULTEXCEPTION")) continue;
            s.add(t);
        }
        return s;
    }

    public static Set getNonExceptionalOutgoingTransitions(Activity act) {
        HashSet<Transition> s = new HashSet<Transition>();
        for (Transition t : ((Transitions)((XMLCollectionElement)act.getParent().getParent()).get("Transitions")).toElements()) {
            String ct;
            if (!t.getFrom().equals(act.getId()) || (ct = t.getCondition().getType()).equals("EXCEPTION") || ct.equals("DEFAULTEXCEPTION")) continue;
            s.add(t);
        }
        return s;
    }

    public static Set getIncomingTransitions(Activity act) {
        HashSet<Transition> s = new HashSet<Transition>();
        for (Transition t : ((Transitions)((XMLCollectionElement)act.getParent().getParent()).get("Transitions")).toElements()) {
            if (!t.getTo().equals(act.getId())) continue;
            s.add(t);
        }
        return s;
    }

    public static Activity getFromActivity(Transition t) {
        return ((Activities)((XMLCollectionElement)t.getParent().getParent()).get("Activities")).getActivity(t.getFrom());
    }

    public static Activity getToActivity(Transition t) {
        return ((Activities)((XMLCollectionElement)t.getParent().getParent()).get("Activities")).getActivity(t.getTo());
    }

    public static boolean isIdValid(String id) {
        return XMLChar.isValidNmtoken((String)id);
    }

    public static WorkflowProcess getSubflowProcess(XMLInterface xmlInterface, Activity sbflwAct) {
        WorkflowProcess wp;
        block2: {
            Package p;
            SubFlow s;
            String subflowID;
            if (sbflwAct.getActivityType() != 3) {
                return null;
            }
            Package pkg = XMLUtil.getPackage(sbflwAct);
            wp = pkg.getWorkflowProcess(subflowID = (s = sbflwAct.getActivityTypes().getImplementation().getImplementationTypes().getSubFlow()).getId());
            if (wp != null) break block2;
            List l = XMLUtil.getAllExternalPackageIds(xmlInterface, pkg);
            Iterator it = l.iterator();
            while (it.hasNext() && ((p = xmlInterface.getPackageById((String)it.next())) == null || (wp = p.getWorkflowProcess(subflowID)) == null)) {
            }
        }
        return wp;
    }

    public static List getAllExternalPackageIds(XMLInterface xmli, Package pkg) {
        ArrayList<String> l = new ArrayList<String>();
        ArrayList workingList = new ArrayList(pkg.getExternalPackageIds());
        Iterator it = workingList.iterator();
        while (it.hasNext()) {
            Package p = xmli.getPackageById((String)it.next());
            if (p == null) continue;
            l.add(p.getId());
            l.addAll(XMLUtil.getAllExternalPackageIds(xmli, p));
        }
        return l;
    }

    public static Set getSplitOrJoinActivities(Collection acts, int sOrJ) {
        HashSet<Activity> sOrJactivities = new HashSet<Activity>();
        if (acts == null) {
            return sOrJactivities;
        }
        for (Activity act : acts) {
            Iterator iter = sOrJ == 0 ? XMLUtil.getOutgoingTransitions(act).iterator() : XMLUtil.getIncomingTransitions(act).iterator();
            int noOfTrans = 0;
            while (iter.hasNext()) {
                Transition t = (Transition)iter.next();
                ++noOfTrans;
            }
            if (noOfTrans <= true) continue;
            sOrJactivities.add(act);
        }
        return sOrJactivities;
    }

    public static Set getBlockActivities(XMLComplexElement wpOrAs, boolean recursivly) {
        ArrayList allActs = ((Activities)wpOrAs.get("Activities")).toElements();
        HashSet<Activity> bas = new HashSet<Activity>();
        for (Activity act : allActs) {
            String asId;
            ActivitySets ass;
            ActivitySet as;
            BlockActivity ba = act.getActivityTypes().getBlockActivity();
            if (ba == null) continue;
            bas.add(act);
            if (!recursivly || (as = (ass = XMLUtil.getWorkflowProcess(act).getActivitySets()).getActivitySet(asId = ba.getBlockId())) == null) continue;
            bas.addAll(XMLUtil.getBlockActivities(as, true));
        }
        return bas;
    }

    public static int getConformanceClassNo(String conformanceClass) {
        if (conformanceClass.equals("NON_BLOCKED")) {
            return 0;
        }
        if (conformanceClass.equals("LOOP_BLOCKED")) {
            return 1;
        }
        if (conformanceClass.equals("FULL_BLOCKED")) {
            return 2;
        }
        return -1;
    }

    public static String fileToString(String fileName) {
        if (fileName != null) {
            String sFile = new String();
            try {
                FileInputStream fis = new FileInputStream(fileName);
                int noOfBytes = fis.available();
                if (noOfBytes > 0) {
                    byte[] utf8Bytes = new byte[noOfBytes];
                    fis.read(utf8Bytes);
                    sFile = new String(utf8Bytes, "UTF8");
                }
            }
            catch (Exception ex) {
                return null;
            }
            return sFile;
        }
        return null;
    }

    public static String getCurrentDateAndTime() {
        String dateSeparator = "-";
        String timeSeparator = ":";
        GregorianCalendar cal = new GregorianCalendar();
        String dateTime = "";
        dateTime = dateTime + String.valueOf(cal.get(1)) + dateSeparator;
        int mnth = cal.get(2) + 1;
        if (mnth < 10) {
            dateTime = dateTime + "0";
        }
        dateTime = dateTime + String.valueOf(mnth) + dateSeparator;
        int dayOfMnth = cal.get(5);
        if (dayOfMnth < 10) {
            dateTime = dateTime + "0";
        }
        dateTime = dateTime + String.valueOf(dayOfMnth) + " ";
        int hr = cal.get(11);
        int ampm = cal.get(9);
        if (ampm == 1 && hr < 12) {
            hr += 12;
        }
        if (hr < 10) {
            dateTime = dateTime + "0";
        }
        dateTime = dateTime + String.valueOf(hr) + timeSeparator;
        int min = cal.get(12);
        if (min < 10) {
            dateTime = dateTime + "0";
        }
        dateTime = dateTime + String.valueOf(min) + timeSeparator;
        int sec = cal.get(13);
        if (sec < 10) {
            dateTime = dateTime + "0";
        }
        dateTime = dateTime + String.valueOf(sec);
        return dateTime;
    }

    public static int checkParameterMatching(FormalParameters fps, ActualParameters aps) {
        if (fps == null || aps == null || fps.size() != aps.size()) {
            return 1;
        }
        for (int i = 0; i < fps.size(); ++i) {
            String apWRD;
            FormalParameter fp = (FormalParameter)fps.get(i);
            ActualParameter ap = (ActualParameter)aps.get(i);
            String fpMode = fp.getMode();
            if (fpMode.equals("IN")) continue;
            DataType fpdt = fp.getDataType();
            DataTypes fpdtt = fpdt.getDataTypes();
            XMLElement fpType = fpdtt.getChoosen();
            Map idToDFOrFP = XMLUtil.getWorkflowProcess(aps).getAllVariables();
            XMLCollectionElement ce = (XMLCollectionElement)idToDFOrFP.get(apWRD = ap.toValue());
            if (ce == null) {
                return 2;
            }
            XMLElement apType = null;
            DataType apdt = (DataType)ce.get("DataType");
            DataTypes apdtt = apdt.getDataTypes();
            apType = apdtt.getChoosen();
            if (fpType.getClass().equals(apType.getClass())) {
                String apAT;
                String fpAT;
                if (fpType instanceof BasicType && !(fpAT = ((BasicType)fpType).getType()).equals(apAT = ((BasicType)apType).getType())) {
                    return 2;
                }
                if (fpType instanceof EnumerationType) {
                    if (((EnumerationType)fpType).size() != ((EnumerationType)apType).size()) {
                        return 2;
                    }
                    for (int j = 0; j < ((EnumerationType)fpType).size(); ++j) {
                        EnumerationValue evFP = (EnumerationValue)((EnumerationType)fpType).get(j);
                        EnumerationValue evAP = (EnumerationValue)((EnumerationType)apType).get(j);
                        if (evFP.getName().equals(evAP.getName())) continue;
                        return 2;
                    }
                }
                if (!(fpType instanceof DeclaredType) || ((DeclaredType)fpType).getId().equals(((DeclaredType)apType).getId())) continue;
                return 2;
            }
            return 2;
        }
        return 0;
    }

    public static String replaceBackslashesWithSlashes(String repBS) {
        if (repBS != null) {
            int ind = -1;
            while ((ind = repBS.indexOf("\\")) != -1) {
                repBS = repBS.substring(0, ind) + "/" + repBS.substring(ind + 1);
            }
        }
        return repBS;
    }

    public static String getExtendedAttributesString(ExtendedAttributes eas) throws Exception {
        Document document = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder dbuilder = dbf.newDocumentBuilder();
        document = dbuilder.newDocument();
        Element eac = document.createElement("EAC");
        XMLUtil.toXML((Node)eac, eas);
        String cont = XMLUtil.getContent(eac.getFirstChild(), true);
        return XMLUtil.getContent(eac.getFirstChild(), true);
    }

    public static String getExtendedAttributesString(Node node) {
        String nameSpacePrefix = node.getPrefix();
        nameSpacePrefix = nameSpacePrefix != null ? nameSpacePrefix + ":" : "";
        Node eas = XMLUtil.getChildByName(node, nameSpacePrefix + "ExtendedAttributes");
        return XMLUtil.getContent(eas, true);
    }

    public static Set getStartingActivities(XMLCollectionElement procOrASDef) {
        Activities acts = (Activities)procOrASDef.get("Activities");
        HashSet<Activity> starts = new HashSet<Activity>();
        Iterator it = acts.toElements().iterator();
        Transitions ts = (Transitions)procOrASDef.get("Transitions");
        while (it.hasNext()) {
            Transition t;
            Activity act = (Activity)it.next();
            Set trs = XMLUtil.getIncomingTransitions(act);
            if (trs.size() == 0) {
                starts.add(act);
                continue;
            }
            if (trs.size() != 1 || !(t = (Transition)trs.toArray()[0]).getFrom().equals(t.getTo())) continue;
            starts.add(act);
        }
        return starts;
    }

    public static Set getEndingActivities(XMLCollectionElement procOrASDef) {
        Activities acts = (Activities)procOrASDef.get("Activities");
        HashSet<Activity> ends = new HashSet<Activity>();
        Iterator it = acts.toElements().iterator();
        Transitions ts = (Transitions)procOrASDef.get("Transitions");
        while (it.hasNext()) {
            Transition t;
            Activity act = (Activity)it.next();
            Set trs = XMLUtil.getNonExceptionalOutgoingTransitions(act);
            if (trs.size() == 0) {
                ends.add(act);
                continue;
            }
            if (trs.size() != 1 || !(t = (Transition)trs.toArray()[0]).getFrom().equals(t.getTo())) continue;
            ends.add(act);
        }
        return ends;
    }

    public static List getResponsibles(WorkflowProcess wp) {
        ArrayList<Responsible> resp = new ArrayList<Responsible>();
        RedefinableHeader rh = wp.getRedefinableHeader();
        Responsibles rsps = rh.getResponsibles();
        for (Responsible rsp : rsps.toElements()) {
            if (resp.contains(rsp)) continue;
            resp.add(rsp);
        }
        rh = XMLUtil.getPackage(wp).getRedefinableHeader();
        rsps = rh.getResponsibles();
        for (Responsible rsp : rsps.toElements()) {
            if (resp.contains(rsp)) continue;
            resp.add(rsp);
        }
        return resp;
    }

    public static boolean isANDTypeSplitOrJoin(Activity act, int sOrJ) {
        String sjType = "XOR";
        if (sOrJ == 0) {
            Split s = XMLUtil.getSplit(act);
            if (s != null) {
                sjType = s.getType();
            }
        } else {
            Join j = XMLUtil.getJoin(act);
            if (j != null) {
                sjType = j.getType();
            }
        }
        return sjType.equals("AND");
    }

    public static boolean isSubflowSynchronous(Activity sbflwActivityDefinition) {
        String type = "SYNCHR";
        SubFlow subflow = sbflwActivityDefinition.getActivityTypes().getImplementation().getImplementationTypes().getSubFlow();
        type = subflow.getExecution();
        return !type.equals("ASYNCHR");
    }

    public static int getStartMode(Activity act) {
        int ret = 0;
        StartMode startMode = act.getStartMode();
        XMLElement mode = startMode.getStartFinishModes().getChoosen();
        if (mode instanceof Manual) {
            ret = 1;
        }
        return ret;
    }

    public static int getFinishMode(Activity act) {
        int ret = 0;
        FinishMode finishMode = act.getFinishMode();
        XMLElement mode = finishMode.getStartFinishModes().getChoosen();
        if (mode instanceof Manual) {
            ret = 1;
        }
        return ret;
    }

    public static OutputStream packageToStream(Package pkg, OutputStream os) {
        try {
            Document document = null;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder dbuilder = dbf.newDocumentBuilder();
            document = dbuilder.newDocument();
            XMLUtil.toXML(document, pkg);
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.setOutputProperty("encoding", "UTF-8");
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(os);
            transformer.transform(source, result);
            return os;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static List getOrderedOutgoingTransitions(Activity fromActDef, Set outTransitions) {
        HashSet otCopy = new HashSet(outTransitions);
        ArrayList<Transition> orderedOutTransitions = new ArrayList<Transition>();
        HashMap<String, Transition> trIdToTr = new HashMap<String, Transition>();
        for (Transition trans : outTransitions) {
            trIdToTr.put(trans.getId(), trans);
        }
        Split s = XMLUtil.getSplit(fromActDef);
        if (s != null) {
            TransitionRefs trfs = s.getTransitionRefs();
            for (TransitionRef tref : trfs.toElements()) {
                Transition trans = (Transition)trIdToTr.get(tref.getId());
                if (trans == null) continue;
                orderedOutTransitions.add(trans);
                otCopy.remove(trans);
            }
        }
        orderedOutTransitions.addAll(otCopy);
        return orderedOutTransitions;
    }

    public static String createPath(String basedir, String relpath) {
        basedir = XMLUtil.convertToSystemPath(basedir);
        relpath = XMLUtil.convertToSystemPath(relpath);
        return basedir + File.separator + relpath;
    }

    public static String convertToSystemPath(String path) {
        char separatorChar = File.separatorChar;
        char charToReplace = separatorChar == '\\' ? (char)'/' : '\\';
        String systemPath = path.replace(charToReplace, separatorChar);
        return systemPath;
    }

    public static void main(String[] args) throws Throwable {
        long ts = System.currentTimeMillis();
        boolean readExt = false;
        readExt = new Boolean(args[0]);
        for (int i = 1; i < args.length; ++i) {
            Package pkg;
            String inputFile = args[i];
            System.out.println("Handling file " + inputFile);
            long t1 = System.currentTimeMillis();
            XMLInterfaceForJDK13 xmli = new XMLInterfaceForJDK13();
            Package p1 = pkg = XMLUtil.readFromFile(xmli, inputFile, readExt);
            PackageValidator pv = new PackageValidator(xmli, pkg, true, readExt, true, true);
            System.out.println("VALIDATING ...");
            boolean valid = pv.validateAll(true);
            System.out.println("VALID=" + valid);
            long t2 = System.currentTimeMillis();
            pkg.setReadOnly(true);
            XMLUtil.writeToFile(xmli, inputFile + "r", pkg);
            long t3 = System.currentTimeMillis();
            pkg = XMLUtil.clonePackage(pkg);
            pkg.initCaches();
            Package p2 = pkg;
            long t4 = System.currentTimeMillis();
            XMLUtil.writeToFile(xmli, inputFile + "rr", pkg);
            long t5 = System.currentTimeMillis();
            pkg = XMLUtil.clonePackageBySerialization(pkg);
            System.out.println("P1=P2=" + p1.equals(p2) + ", P2=P3=" + p2.equals(pkg));
            long t6 = System.currentTimeMillis();
            XMLUtil.writeToFile(xmli, inputFile + "rrr", pkg);
            long t7 = System.currentTimeMillis();
            System.out.println("TOverall   =" + (t6 - t1));
            System.out.println("TOpenPKG   " + (t2 - t1));
            System.out.println("TSavePKG1  =" + (t3 - t2));
            System.out.println("TClonePkg1 =" + (t4 - t3));
            System.out.println("TSavePKG2  =" + (t5 - t3));
            System.out.println("TClonePkg2 =" + (t6 - t5));
            System.out.println("TSavePKG4  =" + (t7 - t6));
        }
        long te = System.currentTimeMillis();
        System.out.println("Handling of " + (args.length - 1) + " XPDLs lasted " + (te - ts) / 1000L + " sec");
    }

    public static Package readFromFile(XMLInterface xmli, String inputFile, boolean readExt) throws Exception {
        return xmli.openPackage(inputFile, readExt);
    }

    public static void writeToFile(XMLInterface xmli, String outputFile, Package pkg) throws Exception {
        System.out.println("PKGEPS=" + pkg.getExternalPackageIds());
        Document document = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder dbuilder = dbf.newDocumentBuilder();
        document = dbuilder.newDocument();
        FileOutputStream os = new FileOutputStream(outputFile);
        XMLUtil.toXML(document, pkg);
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.setOutputProperty("encoding", "UTF8");
        DOMSource source = new DOMSource(document);
        StreamResult result = new StreamResult(os);
        transformer.transform(source, result);
        os.close();
    }

    public static Package clonePackage(Package pkg) throws Exception {
        Package cloned = (Package)pkg.clone();
        return cloned;
    }

    public static Package clonePackageBySerialization(Package pkg) throws Exception {
        byte[] ser = XMLUtil.serialize(pkg);
        Package cloned = (Package)XMLUtil.deserialize(ser);
        return cloned;
    }

    public static byte[] serialize(Object obj) throws Exception {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream oout = new ObjectOutputStream(bout);
        oout.writeObject(obj);
        oout.flush();
        byte[] array = bout.toByteArray();
        oout.close();
        bout.close();
        return array;
    }

    public static Object deserialize(byte[] array) throws Exception {
        return XMLUtil.deserialize(array, XMLUtil.class.getClassLoader());
    }

    public static Object deserialize(byte[] array, final ClassLoader classLoader) throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(array);
        ObjectInputStream rin = null;
        rin = classLoader != null ? new ObjectInputStream(in){

            @Override
            protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
                return Class.forName(objectStreamClass.getName(), false, classLoader);
            }
        } : new ObjectInputStream(in);
        Object obj = rin.readObject();
        rin.close();
        return obj;
    }

    static {
        logging = false;
    }
}

