/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.xpdl;

import java.util.ArrayList;
import org.enhydra.shark.utilities.SequencedHashMap;
import org.enhydra.shark.xpdl.XMLBaseForCollectionAndComplex;
import org.enhydra.shark.xpdl.XMLCollectionElement;
import org.enhydra.shark.xpdl.XMLComplexChoice;
import org.enhydra.shark.xpdl.XMLComplexElement;
import org.enhydra.shark.xpdl.XMLElement;

public abstract class XMLCollection
extends XMLBaseForCollectionAndComplex {
    public XMLCollection(XMLComplexElement parent, boolean isRequired) {
        super(parent, isRequired);
    }

    public XMLCollection(XMLComplexChoice parent, boolean isRequired) {
        super(parent, isRequired);
    }

    @Override
    public void initCaches() {
        super.initCaches();
        if (this.elements.size() > 0 && this.elements.get(0) instanceof XMLCollectionElement) {
            this.elementMap.clear();
            for (XMLCollectionElement el : this.elements) {
                this.elementMap.put((Object)el.getId(), (Object)el);
            }
        }
        this.cachesInitialized = true;
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.elementMap.clear();
    }

    @Override
    public void add(XMLElement el) {
        if (this.isReadOnly) {
            throw new RuntimeException("Can't set the value of read only element!");
        }
        this.elements.add(el);
    }

    @Override
    public boolean add(int no, XMLElement el) {
        if (this.isReadOnly) {
            throw new RuntimeException("Can't set the value of read only element!");
        }
        if (no < 0 || no > this.size()) {
            return false;
        }
        this.elements.add(no, el);
        return true;
    }

    @Override
    public int remove(XMLElement el) {
        return super.remove(el);
    }

    @Override
    protected XMLElement remove(int no) {
        return super.remove(no);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public XMLCollectionElement getCollectionElement(String id) {
        if (this.isReadOnly && this.cachesInitialized) {
            return (XMLCollectionElement)this.elementMap.get((Object)id);
        }
        for (XMLCollectionElement ce : this.elements) {
            if (!ce.getId().equals(id)) continue;
            return ce;
        }
        return null;
    }

    public boolean containsElement(String id) {
        return this.getCollectionElement(id) != null;
    }

    public void clear() {
        this.elements.clear();
        this.elementMap.clear();
    }

    public abstract XMLElement generateNewElement();

    @Override
    public Object clone() {
        XMLCollection d = (XMLCollection)super.clone();
        d.elements = new ArrayList();
        d.elementMap = new SequencedHashMap();
        d.cachesInitialized = false;
        for (Object obj : this.elements) {
            XMLElement el = (XMLElement)obj;
            XMLElement cl = (XMLElement)el.clone();
            cl.setParent(d);
            d.elements.add(cl);
        }
        return d;
    }
}

