/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.xpdl;

import java.io.File;

public class Path {
    public static final char SEPARATOR = '/';
    public static final char DEVICE_SEPARATOR = ':';
    private String[] segments;
    private String device = null;
    private int separators;
    private static final int HAS_LEADING = 1;
    private static final int IS_UNC = 2;
    private static final int HAS_TRAILING = 4;
    private static final int ALL_SEPARATORS = 7;
    private static final int HASH_MASK = -5;
    private static final String[] NO_SEGMENTS = new String[0];
    private static final String ROOT_STRING = "/";
    public static final Path ROOT = new Path("/");
    private static final String EMPTY_STRING = "";
    public static final Path EMPTY = new Path("");

    private Path(String device, String[] segments, int _separators) {
        this.segments = segments;
        this.device = device;
        this.separators = this.computeHashCode() << 3 | _separators & 7;
    }

    public Path(String fullPath) {
        this.initialize(null, fullPath);
    }

    public Path(String device, String path) {
        this.initialize(device, path);
    }

    private boolean canonicalize() {
        for (String segment : this.segments) {
            if (segment.charAt(0) != '.' || !segment.equals("..") && !segment.equals(".")) continue;
            this.collapseParentReferences();
            if (this.segments.length == 0) {
                this.separators &= 3;
            }
            this.separators = this.separators & 7 | this.computeHashCode() << 3;
            return true;
        }
        return false;
    }

    private void collapseParentReferences() {
        int segmentCount = this.segments.length;
        String[] stack = new String[segmentCount];
        int stackPointer = 0;
        for (int i = 0; i < segmentCount; ++i) {
            String segment = this.segments[i];
            if (segment.equals("..")) {
                if (stackPointer == 0) {
                    if (this.isAbsolute()) continue;
                    stack[stackPointer++] = segment;
                    continue;
                }
                if ("..".equals(stack[stackPointer - 1])) {
                    stack[stackPointer++] = "..";
                    continue;
                }
                --stackPointer;
                continue;
            }
            if (segment.equals(".") && (i != 0 || this.isAbsolute())) continue;
            stack[stackPointer++] = segment;
        }
        if (stackPointer == segmentCount) {
            return;
        }
        String[] newSegments = new String[stackPointer];
        System.arraycopy(stack, 0, newSegments, 0, stackPointer);
        this.segments = newSegments;
    }

    private String collapseSlashes(String path) {
        int length = path.length();
        if (length < 3) {
            return path;
        }
        if (path.indexOf("//", 1) == -1) {
            return path;
        }
        char[] result = new char[path.length()];
        int count = 0;
        boolean hasPrevious = false;
        char[] characters = path.toCharArray();
        for (int index = 0; index < characters.length; ++index) {
            char c = characters[index];
            if (c == '/') {
                if (hasPrevious) {
                    if (this.device != null || index != 1) continue;
                    result[count] = c;
                    ++count;
                    continue;
                }
                hasPrevious = true;
                result[count] = c;
                ++count;
                continue;
            }
            hasPrevious = false;
            result[count] = c;
            ++count;
        }
        return new String(result, 0, count);
    }

    private int computeHashCode() {
        int hash = this.device == null ? 17 : this.device.hashCode();
        int segmentCount = this.segments.length;
        for (int i = 0; i < segmentCount; ++i) {
            hash = hash * 37 + this.segments[i].hashCode();
        }
        return hash;
    }

    private int computeLength() {
        int max;
        int length = 0;
        if (this.device != null) {
            length += this.device.length();
        }
        if ((this.separators & 1) != 0) {
            ++length;
        }
        if ((this.separators & 2) != 0) {
            ++length;
        }
        if ((max = this.segments.length) > 0) {
            for (int i = 0; i < max; ++i) {
                length += this.segments[i].length();
            }
            length += max - 1;
        }
        if ((this.separators & 4) != 0) {
            ++length;
        }
        return length;
    }

    private int computeSegmentCount(String path) {
        int i;
        int len = path.length();
        if (len == 0 || len == 1 && path.charAt(0) == '/') {
            return 0;
        }
        int count = 1;
        int prev = -1;
        while ((i = path.indexOf(47, prev + 1)) != -1) {
            if (i != prev + 1 && i != len) {
                ++count;
            }
            prev = i;
        }
        if (path.charAt(len - 1) == '/') {
            --count;
        }
        return count;
    }

    private String[] computeSegments(String path) {
        int firstPosition;
        int segmentCount = this.computeSegmentCount(path);
        if (segmentCount == 0) {
            return NO_SEGMENTS;
        }
        String[] newSegments = new String[segmentCount];
        int len = path.length();
        int n = firstPosition = path.charAt(0) == '/' ? 1 : 0;
        if (firstPosition == 1 && len > 1 && path.charAt(1) == '/') {
            firstPosition = 2;
        }
        int lastPosition = path.charAt(len - 1) != '/' ? len - 1 : len - 2;
        int next = firstPosition;
        for (int i = 0; i < segmentCount; ++i) {
            int start = next;
            int end = path.indexOf(47, next);
            newSegments[i] = end == -1 ? path.substring(start, lastPosition + 1) : path.substring(start, end);
            next = end + 1;
        }
        return newSegments;
    }

    private void initialize(String device, String fullPath) {
        int len;
        if (fullPath == null) {
            throw new RuntimeException();
        }
        this.device = device;
        String path = fullPath.indexOf(92) == -1 ? fullPath : fullPath.replace('\\', '/');
        int i = path.indexOf(58);
        if (i != -1) {
            if (device == null) {
                this.device = path.substring(0, i + 1);
            }
            path = path.substring(i + 1, path.length());
        }
        if ((len = (path = this.collapseSlashes(path)).length()) < 2) {
            this.separators = len == 1 && path.charAt(0) == '/' ? 1 : 0;
        } else {
            boolean hasLeading = path.charAt(0) == '/';
            boolean isUNC = hasLeading && path.charAt(1) == '/';
            boolean hasTrailing = (!isUNC || len != 2) && path.charAt(len - 1) == '/';
            int n = this.separators = hasLeading ? 1 : 0;
            if (isUNC) {
                this.separators |= 2;
            }
            if (hasTrailing) {
                this.separators |= 4;
            }
        }
        this.segments = this.computeSegments(path);
        if (!this.canonicalize()) {
            this.separators = this.separators & 7 | this.computeHashCode() << 3;
        }
    }

    public boolean isAbsolute() {
        return (this.separators & 1) != 0;
    }

    public int matchingFirstSegments(Path anotherPath) {
        if (anotherPath == null) {
            throw new RuntimeException();
        }
        int anotherPathLen = anotherPath.segmentCount();
        int max = Math.min(this.segments.length, anotherPathLen);
        int count = 0;
        for (int i = 0; i < max; ++i) {
            if (!this.segments[i].equals(anotherPath.segment(i))) {
                return count;
            }
            ++count;
        }
        return count;
    }

    public String segment(int index) {
        if (index >= this.segments.length) {
            return null;
        }
        return this.segments[index];
    }

    public int segmentCount() {
        return this.segments.length;
    }

    public String[] segments() {
        String[] segmentCopy = new String[this.segments.length];
        System.arraycopy(this.segments, 0, segmentCopy, 0, this.segments.length);
        return segmentCopy;
    }

    public Path setDevice(String value) {
        if (value != null && value.indexOf(58) != value.length() - 1) {
            throw new RuntimeException("Last character should be the device separator");
        }
        if (value == this.device || value != null && value.equals(this.device)) {
            return this;
        }
        return new Path(value, this.segments, this.separators);
    }

    public String toOSString() {
        int len;
        int resultSize = this.computeLength();
        if (resultSize <= 0) {
            return EMPTY_STRING;
        }
        char FILE_SEPARATOR = File.separatorChar;
        char[] result = new char[resultSize];
        int offset = 0;
        if (this.device != null) {
            int size = this.device.length();
            this.device.getChars(0, size, result, offset);
            offset += size;
        }
        if ((this.separators & 1) != 0) {
            result[offset++] = FILE_SEPARATOR;
        }
        if ((this.separators & 2) != 0) {
            result[offset++] = FILE_SEPARATOR;
        }
        if ((len = this.segments.length - 1) >= 0) {
            for (int i = 0; i < len; ++i) {
                int size = this.segments[i].length();
                this.segments[i].getChars(0, size, result, offset);
                offset += size;
                result[offset++] = FILE_SEPARATOR;
            }
            int size = this.segments[len].length();
            this.segments[len].getChars(0, size, result, offset);
            offset += size;
        }
        if ((this.separators & 4) != 0) {
            result[offset++] = FILE_SEPARATOR;
        }
        return new String(result);
    }

    public static String getRelativePath(Path fullPath, Path fBasePath) {
        if (fBasePath == null || !Path.hasSameDevice(fullPath, fBasePath)) {
            return fullPath.toOSString();
        }
        int matchingSegments = fBasePath.matchingFirstSegments(fullPath);
        StringBuffer res = new StringBuffer();
        for (int backSegments = fBasePath.segmentCount() - matchingSegments; backSegments > 0; --backSegments) {
            res.append("..");
            res.append(File.separatorChar);
        }
        int segCount = fullPath.segmentCount();
        for (int i = matchingSegments; i < segCount; ++i) {
            if (i > matchingSegments) {
                res.append(File.separatorChar);
            }
            res.append(fullPath.segment(i));
        }
        return res.toString();
    }

    private static boolean hasSameDevice(Path p1, Path p2) {
        String dev = p1.device;
        if (dev == null) {
            return p2.device == null;
        }
        return dev.equals(p2.device);
    }
}

