/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.xpdl;

import java.io.File;
import java.io.FileInputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xerces.parsers.DOMParser;
import org.enhydra.shark.utilities.SequencedHashMap;
import org.enhydra.shark.xpdl.ParsingErrors;
import org.enhydra.shark.xpdl.XMLInterface;
import org.enhydra.shark.xpdl.XMLUtil;
import org.enhydra.shark.xpdl.XPDLEntityResolver;
import org.enhydra.shark.xpdl.elements.ExternalPackage;
import org.enhydra.shark.xpdl.elements.Package;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;

public class XMLInterfaceForJDK13
implements XMLInterface {
    protected Map idToPackages = new SequencedHashMap();
    protected Map xmlFileToPackage = new SequencedHashMap();
    protected Map packageToParentDirectory = new SequencedHashMap();
    protected String mainPackageReference;
    protected Map parsingErrorMessages = new SequencedHashMap();
    protected boolean isValidationON = false;

    @Override
    public void setValidation(boolean isActive) {
        this.isValidationON = isActive;
    }

    @Override
    public void clearParserErrorMessages() {
        this.parsingErrorMessages.clear();
    }

    @Override
    public synchronized boolean isPackageOpened(String pkgId) {
        return this.idToPackages.containsKey(pkgId);
    }

    @Override
    public synchronized Package getPackageById(String pkgId) {
        ArrayList l = (ArrayList)this.idToPackages.get(pkgId);
        Package toRet = null;
        if (l != null) {
            Iterator it = l.iterator();
            int lastVersion = -1;
            while (it.hasNext()) {
                Package p = (Package)it.next();
                String v = p.getInternalVersion();
                int iVer = new Integer(v);
                if (iVer <= lastVersion) continue;
                lastVersion = iVer;
                toRet = p;
            }
        }
        return toRet;
    }

    @Override
    public synchronized Package getPackageByIdAndVersion(String pkgId, String version) {
        ArrayList l = (ArrayList)this.idToPackages.get(pkgId);
        Package toRet = null;
        if (l != null) {
            for (Package p : l) {
                String v = p.getInternalVersion();
                if (!v.equals(version)) continue;
                toRet = p;
                break;
            }
        }
        return toRet;
    }

    @Override
    public synchronized Package getPackageByFilename(String filename) {
        filename = XMLUtil.getCanonicalPath(filename, "", false);
        return (Package)this.xmlFileToPackage.get(filename);
    }

    @Override
    public synchronized Package getExternalPackageByRelativeFilePath(String relativePathToExtPkg, Package rootPkg) {
        File f = new File(relativePathToExtPkg);
        if (!f.isAbsolute()) {
            f = new File(this.getParentDirectory(rootPkg) + File.separator + relativePathToExtPkg);
        }
        if (f.exists()) {
            return this.getPackageByFilename(f.getAbsolutePath());
        }
        return null;
    }

    @Override
    public synchronized String getAbsoluteFilePath(Package pkg) {
        Iterator it = this.xmlFileToPackage.entrySet().iterator();
        String fullPath = null;
        while (it.hasNext()) {
            Map.Entry me = it.next();
            String u = (String)me.getKey();
            Package p = (Package)me.getValue();
            if (!p.equals(pkg)) continue;
            fullPath = u;
            break;
        }
        return fullPath;
    }

    @Override
    public synchronized Collection getAllPackages() {
        ArrayList l = new ArrayList();
        Iterator it = this.idToPackages.values().iterator();
        while (it.hasNext()) {
            l.addAll((ArrayList)it.next());
        }
        return l;
    }

    @Override
    public synchronized Collection getAllPackageIds() {
        return this.idToPackages.keySet();
    }

    @Override
    public Collection getAllPackageVersions(String pkgId) {
        ArrayList<String> l = new ArrayList<String>();
        ArrayList all = (ArrayList)this.idToPackages.get(pkgId);
        if (all != null) {
            Iterator it = all.iterator();
            while (it.hasNext()) {
                l.add(((Package)it.next()).getInternalVersion());
            }
        }
        return l;
    }

    @Override
    public synchronized Collection getAllPackageFilenames() {
        return this.xmlFileToPackage.keySet();
    }

    @Override
    public synchronized boolean doesPackageFileExists(String xmlFile) {
        return new File(xmlFile).exists();
    }

    @Override
    public synchronized String getParentDirectory(Package pkg) {
        return (String)this.packageToParentDirectory.get(pkg);
    }

    @Override
    public Package openPackage(String pkgReference, boolean handleExternalPackages) {
        this.parsingErrorMessages.clear();
        this.mainPackageReference = pkgReference;
        Package pkg = this.openPackageRecursively(pkgReference, handleExternalPackages);
        return pkg;
    }

    public void printDebug() {
        System.out.println("idToPackage=" + this.idToPackages);
        System.out.println("xmlFileToPackage=" + this.xmlFileToPackage);
        System.out.println("packageToWorkingDirectory=" + this.packageToParentDirectory);
    }

    protected Package openPackageRecursively(String pkgReference, boolean handleExternalPackages) {
        Package pkg = null;
        File f = null;
        String oldP = pkgReference;
        String baseDirectory = null;
        if ((pkgReference = XMLUtil.getCanonicalPath(pkgReference, "", false)) == null) {
            HashSet<String> fem = new HashSet<String>();
            fem.add("File does not exist");
            this.parsingErrorMessages.put(oldP, fem);
            return null;
        }
        f = new File(pkgReference);
        try {
            baseDirectory = f.getParentFile().getCanonicalPath();
        }
        catch (Exception ex) {
            baseDirectory = f.getParentFile().getAbsolutePath();
        }
        if (this.xmlFileToPackage.containsKey(pkgReference)) {
            return this.getPackageByFilename(pkgReference);
        }
        pkg = this.parseDocument(pkgReference, true);
        if (pkg != null) {
            String pkgId = pkg.getId();
            if (this.idToPackages.containsKey(pkgId)) {
                if (this.xmlFileToPackage.containsKey(pkgReference)) {
                    return this.getPackageById(pkgId);
                }
                throw new RuntimeException("Can't open two packages with the same Id");
            }
            ArrayList<Package> l = (ArrayList<Package>)this.idToPackages.get(pkgId);
            if (l == null) {
                l = new ArrayList<Package>();
            }
            l.add(pkg);
            this.idToPackages.put(pkgId, l);
            this.xmlFileToPackage.put(pkgReference, pkg);
            try {
                this.packageToParentDirectory.put(pkg, f.getParentFile().getCanonicalPath());
            }
            catch (Exception ex) {
                this.packageToParentDirectory.put(pkg, f.getParentFile().getAbsolutePath());
            }
            Iterator eps = pkg.getExternalPackages().toElements().iterator();
            while (eps.hasNext()) {
                String pathToExtPackage = ((ExternalPackage)eps.next()).getHref();
                String extPkgId = null;
                if (handleExternalPackages) {
                    String ptep = XMLUtil.getCanonicalPath(pathToExtPackage, baseDirectory, false);
                    Package extPkg = this.openPackageRecursively(ptep, handleExternalPackages);
                    extPkgId = extPkg.getId();
                } else {
                    extPkgId = XMLUtil.getExternalPackageId(pathToExtPackage);
                }
                pkg.addExternalPackageMapping(pathToExtPackage, extPkgId);
            }
        } else {
            System.err.println("Problems with opening file " + pkgReference);
        }
        return pkg;
    }

    @Override
    public Package openPackagesFromStreams(List pkgContents, boolean isFileStream) throws Exception {
        Package pkg = null;
        for (int i = 0; i < pkgContents.size(); ++i) {
            byte[] pkgCont = (byte[])pkgContents.get(i);
            Package p = this.openPackageFromStream(pkgCont, isFileStream);
            if (i != 0) continue;
            pkg = p;
        }
        return pkg;
    }

    @Override
    public Package openPackageFromStream(byte[] pkgContent, boolean isFileStream) throws Exception {
        Package pkg = null;
        if (isFileStream) {
            String fileContStr = new String(pkgContent, "UTF8");
            pkg = this.parseDocument(fileContStr, false);
        } else {
            pkg = (Package)XMLUtil.deserialize(pkgContent);
        }
        if (pkg != null) {
            String pkgId = pkg.getId();
            ArrayList<Package> l = (ArrayList<Package>)this.idToPackages.get(pkgId);
            if (l == null) {
                l = new ArrayList<Package>();
            }
            if (!l.contains(pkg)) {
                l.add(pkg);
            }
            this.idToPackages.put(pkgId, l);
            Iterator eps = pkg.getExternalPackages().toElements().iterator();
            while (eps.hasNext()) {
                String pathToExtPackage = ((ExternalPackage)eps.next()).getHref();
                String extPkgId = pkg.getExternalPackageId(pathToExtPackage);
                if (extPkgId != null) continue;
                extPkgId = XMLUtil.getExternalPackageId(pathToExtPackage);
                pkg.addExternalPackageMapping(pathToExtPackage, extPkgId);
            }
        }
        return pkg;
    }

    @Override
    public Package parseDocument(String toParse, boolean isFile) {
        Package pkg = null;
        DOMParser parser = new DOMParser();
        try {
            parser.setFeature("http://apache.org/xml/features/continue-after-fatal-error", true);
            ParsingErrors pErrors = new ParsingErrors();
            parser.setErrorHandler((ErrorHandler)pErrors);
            if (this.isValidationON) {
                parser.setEntityResolver((EntityResolver)new XPDLEntityResolver());
                parser.setFeature("http://xml.org/sax/features/validation", true);
                parser.setFeature("http://apache.org/xml/features/validation/schema", true);
            }
            if (isFile) {
                File f = new File(toParse);
                if (!f.exists()) {
                    f = new File(f.getCanonicalPath());
                }
                parser.parse(new InputSource(new FileInputStream(f)));
            } else {
                parser.parse(new InputSource(new StringReader(toParse)));
            }
            Document document = parser.getDocument();
            Set errorMessages = pErrors.getErrorMessages();
            if (errorMessages.size() > 0) {
                if (isFile) {
                    this.parsingErrorMessages.put(toParse, errorMessages);
                } else {
                    this.parsingErrorMessages.put("", errorMessages);
                }
            }
            if (document != null) {
                pkg = new Package();
                XMLUtil.fromXML(document.getDocumentElement(), pkg);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println("Fatal error while parsing document");
            HashSet<String> fem = new HashSet<String>();
            fem.add("Fatal error while parsing document");
            if (isFile) {
                this.parsingErrorMessages.put(toParse, fem);
            } else {
                this.parsingErrorMessages.put("", fem);
            }
            return null;
        }
        return pkg;
    }

    @Override
    public Map getParsingErrorMessages() {
        return this.parsingErrorMessages;
    }

    @Override
    public synchronized List closePackages(String pkgId) {
        ArrayList l = (ArrayList)this.idToPackages.remove(pkgId);
        if (l != null) {
            for (Package toRemove : l) {
                Iterator it = this.xmlFileToPackage.entrySet().iterator();
                Object keyToRemove = null;
                while (it.hasNext()) {
                    Map.Entry me = it.next();
                    Object key = me.getKey();
                    Object val = me.getValue();
                    if (!val.equals(toRemove)) continue;
                    keyToRemove = key;
                    break;
                }
                if (keyToRemove != null) {
                    this.xmlFileToPackage.remove(keyToRemove);
                }
                this.packageToParentDirectory.remove(toRemove);
            }
        }
        return l;
    }

    @Override
    public synchronized Package closePackageVersion(String pkgId, String pkgVer) {
        ArrayList l = (ArrayList)this.idToPackages.get(pkgId);
        Package toRemove = null;
        if (l != null) {
            for (Package p : l) {
                if (!p.getInternalVersion().equals(pkgVer)) continue;
                toRemove = p;
                break;
            }
            if (toRemove != null) {
                Iterator it = this.xmlFileToPackage.entrySet().iterator();
                Object keyToRemove = null;
                while (it.hasNext()) {
                    Map.Entry me = it.next();
                    Object key = me.getKey();
                    Object val = me.getValue();
                    if (!val.equals(toRemove)) continue;
                    keyToRemove = key;
                    break;
                }
                if (keyToRemove != null) {
                    this.xmlFileToPackage.remove(keyToRemove);
                }
                this.packageToParentDirectory.remove(toRemove);
            }
        }
        return toRemove;
    }

    @Override
    public synchronized void closeAllPackages() {
        this.idToPackages.clear();
        this.xmlFileToPackage.clear();
        this.packageToParentDirectory.clear();
    }

    @Override
    public synchronized String getIdFromFile(String xmlFile) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            DocumentBuilder parser = factory.newDocumentBuilder();
            Document document = null;
            try {
                File f = new File(xmlFile);
                if (!f.exists()) {
                    f = new File(f.getCanonicalPath());
                }
                document = parser.parse(new InputSource(new FileInputStream(f)));
            }
            catch (Exception ex) {
                document = parser.parse(new InputSource(new StringReader(xmlFile)));
            }
            return XMLUtil.getId(document.getDocumentElement());
        }
        catch (Exception ex) {
            return "";
        }
    }

    @Override
    public synchronized void synchronizePackages(XMLInterface xmlInterface) {
        this.closeAllPackages();
        for (Package pkg : xmlInterface.getAllPackages()) {
            String pd;
            String pkgId = pkg.getId();
            ArrayList<Package> l = (ArrayList<Package>)this.idToPackages.get(pkgId);
            if (l == null) {
                l = new ArrayList<Package>();
            }
            l.add(pkg);
            this.idToPackages.put(pkgId, l);
            String fp = xmlInterface.getAbsoluteFilePath(pkg);
            if (fp != null) {
                this.xmlFileToPackage.put(fp, pkg);
            }
            if ((pd = xmlInterface.getParentDirectory(pkg)) == null) continue;
            this.packageToParentDirectory.put(pkg, pd);
        }
    }
}

