/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.xpdl.elements;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.enhydra.shark.xpdl.XMLAttribute;
import org.enhydra.shark.xpdl.XMLCollectionElement;
import org.enhydra.shark.xpdl.XMLUtil;
import org.enhydra.shark.xpdl.elements.Activities;
import org.enhydra.shark.xpdl.elements.Activity;
import org.enhydra.shark.xpdl.elements.ActivitySet;
import org.enhydra.shark.xpdl.elements.ActivitySets;
import org.enhydra.shark.xpdl.elements.Application;
import org.enhydra.shark.xpdl.elements.Applications;
import org.enhydra.shark.xpdl.elements.DataField;
import org.enhydra.shark.xpdl.elements.DataFields;
import org.enhydra.shark.xpdl.elements.ExtendedAttributes;
import org.enhydra.shark.xpdl.elements.FormalParameter;
import org.enhydra.shark.xpdl.elements.FormalParameters;
import org.enhydra.shark.xpdl.elements.Participant;
import org.enhydra.shark.xpdl.elements.Participants;
import org.enhydra.shark.xpdl.elements.ProcessHeader;
import org.enhydra.shark.xpdl.elements.RedefinableHeader;
import org.enhydra.shark.xpdl.elements.Transition;
import org.enhydra.shark.xpdl.elements.Transitions;
import org.enhydra.shark.xpdl.elements.WorkflowProcesses;

public class WorkflowProcess
extends XMLCollectionElement {
    protected transient ArrayList startingActivities;
    protected transient ArrayList endingActivities;

    public WorkflowProcess(WorkflowProcesses parent) {
        super(parent, true);
    }

    @Override
    protected void fillStructure() {
        XMLAttribute attrName = new XMLAttribute(this, "Name", false);
        XMLAttribute attrAccessLevel = new XMLAttribute(this, "AccessLevel", false, new String[]{"", "PUBLIC", "PRIVATE"}, 0);
        ProcessHeader refProcessHeader = new ProcessHeader(this);
        RedefinableHeader refRedefinableHeader = new RedefinableHeader(this);
        FormalParameters refFormalParameters = new FormalParameters(this);
        DataFields refDataFields = new DataFields(this);
        Participants refParticipants = new Participants(this);
        Applications refApplications = new Applications(this);
        ActivitySets refActivitySets = new ActivitySets(this);
        Activities refActivities = new Activities(this);
        Transitions refTransitions = new Transitions(this);
        ExtendedAttributes refExtendedAttributes = new ExtendedAttributes(this);
        super.fillStructure();
        this.add(attrName);
        this.add(attrAccessLevel);
        this.add(refProcessHeader);
        this.add(refRedefinableHeader);
        this.add(refFormalParameters);
        this.add(refDataFields);
        this.add(refParticipants);
        this.add(refApplications);
        this.add(refActivitySets);
        this.add(refActivities);
        this.add(refTransitions);
        this.add(refExtendedAttributes);
    }

    @Override
    public void initCaches() {
        super.initCaches();
        for (Activity act : this.getActivities().toElements()) {
            Transition t;
            ArrayList trsI = act.getIncomingTransitions();
            ArrayList trsNEO = act.getNonExceptionalOutgoingTransitions();
            if (trsI.size() == 0) {
                this.startingActivities.add(act);
            } else if (trsI.size() == 1 && (t = (Transition)trsI.get(0)).getFrom().equals(t.getTo())) {
                this.startingActivities.add(act);
            }
            if (trsNEO.size() == 0) {
                this.endingActivities.add(act);
                continue;
            }
            if (trsNEO.size() != 1 || !(t = (Transition)trsNEO.get(0)).getFrom().equals(t.getTo())) continue;
            this.endingActivities.add(act);
        }
    }

    @Override
    public void clearCaches() {
        this.startingActivities = new ArrayList();
        this.endingActivities = new ArrayList();
        super.clearCaches();
    }

    public ArrayList getStartingActivities() {
        if (!this.isReadOnly) {
            throw new RuntimeException("This method can be used only in read-only mode!");
        }
        return this.startingActivities;
    }

    public ArrayList getEndingActivities() {
        if (!this.isReadOnly) {
            throw new RuntimeException("This method can be used only in read-only mode!");
        }
        return this.endingActivities;
    }

    public Map getAllVariables() {
        HashMap<String, XMLCollectionElement> m = new HashMap<String, XMLCollectionElement>();
        for (DataField df : this.getDataFields().toElements()) {
            m.put(df.getId(), df);
        }
        for (DataField df : XMLUtil.getPackage(this).getDataFields().toElements()) {
            if (m.containsKey(df.getId())) continue;
            m.put(df.getId(), df);
        }
        for (FormalParameter fp : this.getFormalParameters().toElements()) {
            if (m.containsKey(fp.getId())) continue;
            m.put(fp.getId(), fp);
        }
        return m;
    }

    public Application getApplication(String Id) {
        return this.getApplications().getApplication(Id);
    }

    public Participant getParticipant(String Id) {
        return this.getParticipants().getParticipant(Id);
    }

    public DataField getDataField(String Id) {
        return this.getDataFields().getDataField(Id);
    }

    public FormalParameter getFormalParameter(String Id) {
        return this.getFormalParameters().getFormalParameter(Id);
    }

    public ActivitySet getActivitySet(String Id) {
        return this.getActivitySets().getActivitySet(Id);
    }

    public Activity getActivity(String Id) {
        return this.getActivities().getActivity(Id);
    }

    public Transition getTransition(String Id) {
        return this.getTransitions().getTransition(Id);
    }

    public String getName() {
        return this.get("Name").toValue();
    }

    public void setName(String name) {
        this.set("Name", name);
    }

    public XMLAttribute getAccessLevelAttribute() {
        return (XMLAttribute)this.get("AccessLevel");
    }

    public String getAccessLevel() {
        return this.getAccessLevelAttribute().toValue();
    }

    public void setAccessLevelNONE() {
        this.getAccessLevelAttribute().setValue("");
    }

    public void setAccessLevelPUBLIC() {
        this.getAccessLevelAttribute().setValue("PUBLIC");
    }

    public void setAccessLevelPRIVATE() {
        this.getAccessLevelAttribute().setValue("PRIVATE");
    }

    public Applications getApplications() {
        return (Applications)this.get("Applications");
    }

    public DataFields getDataFields() {
        return (DataFields)this.get("DataFields");
    }

    public ExtendedAttributes getExtendedAttributes() {
        return (ExtendedAttributes)this.get("ExtendedAttributes");
    }

    public ProcessHeader getProcessHeader() {
        return (ProcessHeader)this.get("ProcessHeader");
    }

    public Participants getParticipants() {
        return (Participants)this.get("Participants");
    }

    public RedefinableHeader getRedefinableHeader() {
        return (RedefinableHeader)this.get("RedefinableHeader");
    }

    public Activities getActivities() {
        return (Activities)this.get("Activities");
    }

    public Transitions getTransitions() {
        return (Transitions)this.get("Transitions");
    }

    public ActivitySets getActivitySets() {
        return (ActivitySets)this.get("ActivitySets");
    }

    public FormalParameters getFormalParameters() {
        return (FormalParameters)this.get("FormalParameters");
    }
}

