/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.xpdl.elements;

import java.util.Collection;
import java.util.Map;
import org.enhydra.shark.utilities.SequencedHashMap;
import org.enhydra.shark.xpdl.XMLAttribute;
import org.enhydra.shark.xpdl.XMLComplexElement;
import org.enhydra.shark.xpdl.elements.Application;
import org.enhydra.shark.xpdl.elements.Applications;
import org.enhydra.shark.xpdl.elements.ConformanceClass;
import org.enhydra.shark.xpdl.elements.DataField;
import org.enhydra.shark.xpdl.elements.DataFields;
import org.enhydra.shark.xpdl.elements.ExtendedAttributes;
import org.enhydra.shark.xpdl.elements.ExternalPackages;
import org.enhydra.shark.xpdl.elements.Namespaces;
import org.enhydra.shark.xpdl.elements.PackageHeader;
import org.enhydra.shark.xpdl.elements.Participant;
import org.enhydra.shark.xpdl.elements.Participants;
import org.enhydra.shark.xpdl.elements.RedefinableHeader;
import org.enhydra.shark.xpdl.elements.Script;
import org.enhydra.shark.xpdl.elements.TypeDeclaration;
import org.enhydra.shark.xpdl.elements.TypeDeclarations;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.enhydra.shark.xpdl.elements.WorkflowProcesses;

public class Package
extends XMLComplexElement {
    protected Namespaces namespaces;
    protected String internalVersion = "-1";
    protected SequencedHashMap extPkgRefsToIds = new SequencedHashMap();

    public Package() {
        super(null, true);
        this.namespaces = new Namespaces(this);
    }

    @Override
    protected void fillStructure() {
        XMLAttribute attrId = new XMLAttribute(this, "Id", true);
        XMLAttribute attrName = new XMLAttribute(this, "Name", false);
        PackageHeader refPackageHeader = new PackageHeader(this);
        RedefinableHeader refRedefinableHeader = new RedefinableHeader(this);
        ConformanceClass refConformanceClass = new ConformanceClass(this);
        Script refScript = new Script(this);
        ExternalPackages refExternalPackages = new ExternalPackages(this);
        TypeDeclarations refTypeDeclarations = new TypeDeclarations(this);
        Participants refParticipants = new Participants(this);
        Applications refApplications = new Applications(this);
        DataFields refDataFields = new DataFields(this);
        WorkflowProcesses refWorkflowProcesses = new WorkflowProcesses(this);
        ExtendedAttributes refExtendedAttributes = new ExtendedAttributes(this);
        this.add(attrId);
        this.add(attrName);
        this.add(refPackageHeader);
        this.add(refRedefinableHeader);
        this.add(refConformanceClass);
        this.add(refScript);
        this.add(refExternalPackages);
        this.add(refTypeDeclarations);
        this.add(refParticipants);
        this.add(refApplications);
        this.add(refDataFields);
        this.add(refWorkflowProcesses);
        this.add(refExtendedAttributes);
    }

    public String getInternalVersion() {
        return this.internalVersion;
    }

    public void setInternalVersion(String internalVersion) {
        this.internalVersion = internalVersion;
    }

    public void addExternalPackageMapping(String epRef, String epId) {
        this.extPkgRefsToIds.put((Object)epRef, (Object)epId);
    }

    public String getExternalPackageId(String epRef) {
        return (String)this.extPkgRefsToIds.get((Object)epRef);
    }

    public Collection getExternalPackageIds() {
        return this.extPkgRefsToIds.values();
    }

    public WorkflowProcess getWorkflowProcess(String Id) {
        return this.getWorkflowProcesses().getWorkflowProcess(Id);
    }

    public Application getApplication(String Id) {
        return this.getApplications().getApplication(Id);
    }

    public Participant getParticipant(String Id) {
        return this.getParticipants().getParticipant(Id);
    }

    public DataField getDataField(String Id) {
        return this.getDataFields().getDataField(Id);
    }

    public TypeDeclaration getTypeDeclaration(String Id) {
        return this.getTypeDeclarations().getTypeDeclaration(Id);
    }

    public String getId() {
        return this.get("Id").toValue();
    }

    public void setId(String id) {
        this.set("Id", id);
    }

    public String getName() {
        return this.get("Name").toValue();
    }

    public void setName(String name) {
        this.set("Name", name);
    }

    public Applications getApplications() {
        return (Applications)this.get("Applications");
    }

    public ConformanceClass getConformanceClass() {
        return (ConformanceClass)this.get("ConformanceClass");
    }

    public DataFields getDataFields() {
        return (DataFields)this.get("DataFields");
    }

    public ExtendedAttributes getExtendedAttributes() {
        return (ExtendedAttributes)this.get("ExtendedAttributes");
    }

    public ExternalPackages getExternalPackages() {
        return (ExternalPackages)this.get("ExternalPackages");
    }

    public PackageHeader getPackageHeader() {
        return (PackageHeader)this.get("PackageHeader");
    }

    public Participants getParticipants() {
        return (Participants)this.get("Participants");
    }

    public RedefinableHeader getRedefinableHeader() {
        return (RedefinableHeader)this.get("RedefinableHeader");
    }

    public Script getScript() {
        return (Script)this.get("Script");
    }

    public TypeDeclarations getTypeDeclarations() {
        return (TypeDeclarations)this.get("TypeDeclarations");
    }

    public WorkflowProcesses getWorkflowProcesses() {
        return (WorkflowProcesses)this.get("WorkflowProcesses");
    }

    public Namespaces getNamespaces() {
        return this.namespaces;
    }

    @Override
    public Object clone() {
        Package d = (Package)super.clone();
        d.namespaces = (Namespaces)this.namespaces.clone();
        d.extPkgRefsToIds = new SequencedHashMap((Map)this.extPkgRefsToIds);
        d.clearCaches();
        if (d.isReadOnly) {
            d.initCaches();
        }
        return d;
    }

    @Override
    public boolean equals(Object e) {
        boolean equals = super.equals(e);
        if (equals) {
            Package el = (Package)e;
            return this.namespaces.equals(el.namespaces) && this.internalVersion.equals(el.internalVersion);
        }
        return false;
    }
}

