/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.xpdl.elements;

import java.util.ArrayList;
import org.enhydra.shark.xpdl.XMLCollectionElement;
import org.enhydra.shark.xpdl.elements.Activities;
import org.enhydra.shark.xpdl.elements.Activity;
import org.enhydra.shark.xpdl.elements.ActivitySets;
import org.enhydra.shark.xpdl.elements.Transition;
import org.enhydra.shark.xpdl.elements.Transitions;

public class ActivitySet
extends XMLCollectionElement {
    protected transient ArrayList startingActivities;
    protected transient ArrayList endingActivities;

    public ActivitySet(ActivitySets parent) {
        super(parent, true);
    }

    @Override
    protected void fillStructure() {
        Activities refActivities = new Activities(this);
        Transitions refTransitions = new Transitions(this);
        super.fillStructure();
        this.add(refActivities);
        this.add(refTransitions);
    }

    @Override
    public void initCaches() {
        super.initCaches();
        for (Activity act : this.getActivities().toElements()) {
            Transition t;
            ArrayList trsI = act.getIncomingTransitions();
            ArrayList trsNEO = act.getNonExceptionalOutgoingTransitions();
            if (trsI.size() == 0) {
                this.startingActivities.add(act);
            } else if (trsI.size() == 1 && (t = (Transition)trsI.get(0)).getFrom().equals(t.getTo())) {
                this.startingActivities.add(act);
            }
            if (trsNEO.size() == 0) {
                this.endingActivities.add(act);
                continue;
            }
            if (trsNEO.size() != 1 || !(t = (Transition)trsNEO.get(0)).getFrom().equals(t.getTo())) continue;
            this.endingActivities.add(act);
        }
    }

    @Override
    public void clearCaches() {
        this.startingActivities = new ArrayList();
        this.endingActivities = new ArrayList();
        super.clearCaches();
    }

    public ArrayList getStartingActivities() {
        if (!this.isReadOnly) {
            throw new RuntimeException("This method can be used only in read-only mode!");
        }
        return this.startingActivities;
    }

    public ArrayList getEndingActivities() {
        if (!this.isReadOnly) {
            throw new RuntimeException("This method can be used only in read-only mode!");
        }
        return this.endingActivities;
    }

    public Activity getActivity(String Id) {
        return this.getActivities().getActivity(Id);
    }

    public Transition getTransition(String Id) {
        return this.getTransitions().getTransition(Id);
    }

    public Activities getActivities() {
        return (Activities)this.get("Activities");
    }

    public Transitions getTransitions() {
        return (Transitions)this.get("Transitions");
    }
}

