/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.xpdl;

import java.util.HashSet;
import java.util.Set;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ParsingErrors
implements ErrorHandler {
    Set errorMessages = new HashSet();

    @Override
    public void warning(SAXParseException ex) {
        this.store(ex, "[Warning]");
    }

    @Override
    public void error(SAXParseException ex) {
        this.store(ex, "[Error]");
    }

    @Override
    public void fatalError(SAXParseException ex) throws SAXException {
        this.store(ex, "[Fatal Error]");
    }

    public Set getErrorMessages() {
        return this.errorMessages;
    }

    public void clearErrors() {
        this.errorMessages.clear();
    }

    void store(SAXParseException ex, String type) {
        String errorString = type + " at line number " + ex.getLineNumber() + ": " + ex.getMessage() + "\n";
        this.errorMessages.add(errorString);
    }
}

