/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.xpdl;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.enhydra.shark.utilities.SequencedHashMap;
import org.enhydra.shark.xpdl.GraphChecker;
import org.enhydra.shark.xpdl.XMLCollection;
import org.enhydra.shark.xpdl.XMLCollectionElement;
import org.enhydra.shark.xpdl.XMLComplexElement;
import org.enhydra.shark.xpdl.XMLElement;
import org.enhydra.shark.xpdl.XMLInterface;
import org.enhydra.shark.xpdl.XMLInterfaceForJDK13;
import org.enhydra.shark.xpdl.XMLUtil;
import org.enhydra.shark.xpdl.elements.Activities;
import org.enhydra.shark.xpdl.elements.Activity;
import org.enhydra.shark.xpdl.elements.ActivitySet;
import org.enhydra.shark.xpdl.elements.ActualParameters;
import org.enhydra.shark.xpdl.elements.Application;
import org.enhydra.shark.xpdl.elements.ApplicationTypes;
import org.enhydra.shark.xpdl.elements.BlockActivity;
import org.enhydra.shark.xpdl.elements.DataField;
import org.enhydra.shark.xpdl.elements.DataType;
import org.enhydra.shark.xpdl.elements.Deadline;
import org.enhydra.shark.xpdl.elements.DeclaredType;
import org.enhydra.shark.xpdl.elements.FormalParameter;
import org.enhydra.shark.xpdl.elements.FormalParameters;
import org.enhydra.shark.xpdl.elements.Join;
import org.enhydra.shark.xpdl.elements.Package;
import org.enhydra.shark.xpdl.elements.PackageHeader;
import org.enhydra.shark.xpdl.elements.Participant;
import org.enhydra.shark.xpdl.elements.RedefinableHeader;
import org.enhydra.shark.xpdl.elements.Responsible;
import org.enhydra.shark.xpdl.elements.Responsibles;
import org.enhydra.shark.xpdl.elements.Split;
import org.enhydra.shark.xpdl.elements.SubFlow;
import org.enhydra.shark.xpdl.elements.Tool;
import org.enhydra.shark.xpdl.elements.Tools;
import org.enhydra.shark.xpdl.elements.Transition;
import org.enhydra.shark.xpdl.elements.TransitionRef;
import org.enhydra.shark.xpdl.elements.TransitionRefs;
import org.enhydra.shark.xpdl.elements.Transitions;
import org.enhydra.shark.xpdl.elements.TypeDeclaration;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.w3c.dom.Document;

public class PackageValidator {
    protected static final String CURRENT_XPDL_VERSION = "1.0";
    protected XMLInterface xmlInterface;
    protected Package pkg;
    protected boolean getExistingSchemaValidationErrors;
    protected boolean checkExternalPackages;
    protected boolean allowUndefinedStart;
    protected boolean allowUndefinedEnd;
    protected Map xpdlSchemaValidationErrors = new HashMap();
    protected Map graphsConnectionErrors = new HashMap();
    protected Map basicGraphConnectionErrors = new HashMap();
    protected Map graphsConformanceErrors = new HashMap();
    protected Map basicGraphsConformanceErrors = new HashMap();
    protected Map logicErrors = new HashMap();
    protected Map basicLogicErrors = new HashMap();

    public Map getXPDLSchemaValidationErrors() {
        return this.xpdlSchemaValidationErrors;
    }

    public Map getGraphsConnectionErrors(XMLComplexElement pkgOrWpOrAs) {
        return (Map)this.graphsConnectionErrors.get(pkgOrWpOrAs);
    }

    public String getBasicGraphConnectionError(XMLComplexElement pkgOrWpOrAs) {
        return (String)this.basicGraphConnectionErrors.get(pkgOrWpOrAs);
    }

    public Map getGraphConformanceErrors(XMLComplexElement pkgOrWpOrAs) {
        return (Map)this.graphsConformanceErrors.get(pkgOrWpOrAs);
    }

    public List getBasicGraphConformanceErrors(XMLComplexElement pkgOrWpOrAs) {
        return (List)this.basicGraphsConformanceErrors.get(pkgOrWpOrAs);
    }

    public Map getLogicErrors(XMLComplexElement pkgOrWpOrAs) {
        return (Map)this.logicErrors.get(pkgOrWpOrAs);
    }

    public String getBasicLogicError(XMLComplexElement pkgOrWpOrAs) {
        return (String)this.basicLogicErrors.get(pkgOrWpOrAs);
    }

    public PackageValidator(XMLInterface xmlInterface, Package pkg, boolean getExistingSchemaValidationErrors, boolean checkExternalPackages, boolean allowUndefinedStart, boolean allowUndefinedEnd) {
        this.xmlInterface = xmlInterface;
        this.pkg = pkg;
        this.getExistingSchemaValidationErrors = getExistingSchemaValidationErrors;
        this.checkExternalPackages = checkExternalPackages;
        this.allowUndefinedStart = allowUndefinedStart;
        this.allowUndefinedEnd = allowUndefinedEnd;
    }

    public boolean validateAll(boolean fullCheck) {
        try {
            boolean isValid = this.validateAgainstXPDLSchema();
            if (fullCheck || isValid) {
                boolean bl = isValid = this.checkPackage(fullCheck) && isValid;
            }
            if (fullCheck || isValid) {
                boolean bl = isValid = this.checkGraphConnections(fullCheck) && isValid;
            }
            if (fullCheck || isValid) {
                isValid = this.checkGraphConformance(fullCheck) && isValid;
            }
            return isValid;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public boolean validateAgainstXPDLSchema() {
        if (this.getExistingSchemaValidationErrors) {
            this.xpdlSchemaValidationErrors = this.xmlInterface.getParsingErrorMessages();
            return this.xpdlSchemaValidationErrors.size() <= 0;
        }
        try {
            Document document = null;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder dbuilder = dbf.newDocumentBuilder();
            document = dbuilder.newDocument();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XMLUtil.toXML(document, this.pkg);
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.setOutputProperty("encoding", "UTF-8");
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(baos);
            transformer.transform(source, result);
            this.xmlInterface.clearParserErrorMessages();
            this.xmlInterface.parseDocument(baos.toString("UTF8"), false);
            baos.close();
            this.xpdlSchemaValidationErrors = this.xmlInterface.getParsingErrorMessages();
            if (this.xpdlSchemaValidationErrors.size() > 0) {
                return false;
            }
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public boolean checkPackage(boolean fullCheck) {
        HashMap<Package, String> les = new HashMap<Package, String>();
        this.logicErrors.put(this.pkg, les);
        this.basicLogicErrors.remove(this.pkg);
        boolean isPackageValid = true;
        boolean invalidId = false;
        if (!this.isIdValid(this.pkg.getId())) {
            isPackageValid = false;
            invalidId = true;
            les.put(this.pkg, XMLUtil.getLanguageDependentString("ErrorPackageIdIsNotValid"));
        }
        if (fullCheck || isPackageValid) {
            this.checkPackageHeader(fullCheck);
        }
        if (fullCheck || isPackageValid) {
            boolean bl = isPackageValid = this.checkRedefinableHeader(this.pkg, fullCheck) && isPackageValid;
        }
        if (fullCheck || isPackageValid) {
            boolean bl = isPackageValid = this.checkConformanceClass(fullCheck) && isPackageValid;
        }
        if (fullCheck || isPackageValid) {
            boolean bl = isPackageValid = this.checkScript(fullCheck) && isPackageValid;
        }
        if ((fullCheck || isPackageValid) && this.checkExternalPackages) {
            boolean bl = isPackageValid = this.checkExternalPackages(fullCheck) && isPackageValid;
        }
        if (fullCheck || isPackageValid) {
            boolean bl = isPackageValid = this.checkCollection("TypeDeclarations", this.pkg, fullCheck) && isPackageValid;
        }
        if (fullCheck || isPackageValid) {
            boolean bl = isPackageValid = this.checkCollection("Participants", this.pkg, fullCheck) && isPackageValid;
        }
        if (fullCheck || isPackageValid) {
            boolean bl = isPackageValid = this.checkCollection("Applications", this.pkg, fullCheck) && isPackageValid;
        }
        if (fullCheck || isPackageValid) {
            isPackageValid = this.checkCollection("DataFields", this.pkg, fullCheck) && isPackageValid;
        }
        boolean areProcessesValid = true;
        if (fullCheck || isPackageValid) {
            areProcessesValid = this.checkCollection("WorkflowProcesses", this.pkg, fullCheck);
            boolean bl = isPackageValid = areProcessesValid && isPackageValid;
        }
        if (!isPackageValid) {
            if (invalidId) {
                this.basicLogicErrors.put(this.pkg, XMLUtil.getLanguageDependentString("ErrorPackageIdIsNotValid"));
            } else if (!areProcessesValid) {
                this.basicLogicErrors.put(this.pkg, XMLUtil.getLanguageDependentString("ErrorOneOrMoreProcessesHaveLogicErrors"));
            } else {
                this.basicLogicErrors.put(this.pkg, les.values().toArray()[0]);
            }
        }
        return isPackageValid;
    }

    public boolean checkPackageHeader(boolean fullCheck) {
        PackageHeader phdr = this.pkg.getPackageHeader();
        String xpdlv = "XPDLVersion";
        if (!phdr.getXPDLVersion().equals(CURRENT_XPDL_VERSION)) {
            Map les = this.getLogicErrors(this.pkg);
            les.put(phdr, XMLUtil.getLanguageDependentString("ErrorInvalidXPDLVersion"));
            return false;
        }
        return true;
    }

    public boolean checkRedefinableHeader(XMLComplexElement pkgOrWp, boolean fullCheck) {
        boolean isValid = true;
        RedefinableHeader rh = (RedefinableHeader)pkgOrWp.get("RedefinableHeader");
        for (Responsible r : ((Responsibles)rh.get("Responsibles")).toElements()) {
            Participant p;
            String rv = r.toValue();
            if (pkgOrWp instanceof Package) {
                p = XMLUtil.getPackage(r).getParticipant(rv);
            } else {
                p = XMLUtil.getWorkflowProcess(r).getParticipant(rv);
                if (p == null) {
                    p = XMLUtil.getPackage(r).getParticipant(rv);
                }
            }
            if (p == null) {
                Package pkg;
                List l = XMLUtil.getAllExternalPackageIds(this.xmlInterface, this.pkg);
                Iterator itp = l.iterator();
                while (itp.hasNext() && ((pkg = this.xmlInterface.getPackageById((String)itp.next())) == null || (p = pkg.getParticipant(rv)) == null)) {
                }
            }
            if (p != null) continue;
            isValid = false;
            Map les = this.getLogicErrors(pkgOrWp);
            les.put(rh, XMLUtil.getLanguageDependentString("ErrorOneOrMoreResponsibleParticipantsDoNotExist"));
            break;
        }
        return isValid;
    }

    public boolean checkConformanceClass(boolean fullCheck) {
        return true;
    }

    public boolean checkScript(boolean fullCheck) {
        return true;
    }

    public boolean checkExternalPackages(boolean fullCheck) {
        boolean isValid = true;
        Map les = this.getLogicErrors(this.pkg);
        Iterator it = this.pkg.getExternalPackageIds().iterator();
        while (it.hasNext() && (fullCheck || isValid)) {
            Package p = this.xmlInterface.getPackageById((String)it.next());
            PackageValidator pv = new PackageValidator(this.xmlInterface, p, this.getExistingSchemaValidationErrors, false, this.allowUndefinedStart, this.allowUndefinedEnd);
            if (pv.validateAll(false)) continue;
            isValid = false;
            if (les == null) continue;
            les.put(p, XMLUtil.getLanguageDependentString("ErrorInvalidExternalPackage"));
        }
        return isValid;
    }

    public boolean checkCollection(String colName, XMLComplexElement cOwner, boolean fullCheck) {
        boolean isValid = true;
        Iterator it = ((XMLCollection)cOwner.get(colName)).toElements().iterator();
        while (it.hasNext() && (fullCheck || isValid)) {
            isValid = this.checkCollectionElement((XMLCollectionElement)it.next(), fullCheck) && isValid;
        }
        return isValid;
    }

    public boolean checkCollectionElement(XMLCollectionElement ce, boolean fullCheck) {
        Map les;
        XMLElement firstOwner;
        boolean isValid = true;
        if (!this.isIdValid(ce.getId())) {
            isValid = false;
            firstOwner = ce.getParent().getParent();
            les = firstOwner instanceof ApplicationTypes ? this.getLogicErrors((XMLComplexElement)((ApplicationTypes)firstOwner).getParent().getParent().getParent()) : this.getLogicErrors((XMLComplexElement)firstOwner);
            les.put(ce, XMLUtil.getLanguageDependentString("ErrorIdIsNotValid"));
        }
        if ((fullCheck || isValid) && !PackageValidator.isUniqueId((XMLCollection)ce.getParent(), ce.getId())) {
            isValid = false;
            firstOwner = ce.getParent().getParent();
            les = firstOwner instanceof ApplicationTypes ? this.getLogicErrors((XMLComplexElement)((ApplicationTypes)firstOwner).getParent().getParent()) : this.getLogicErrors((XMLComplexElement)firstOwner);
            String msg = (String)les.get(ce);
            msg = this.prepareMessageString(msg);
            msg = msg + XMLUtil.getLanguageDependentString("ErrorIdIsNotUnique");
            les.put(ce, msg);
        }
        if (fullCheck || isValid) {
            if (ce instanceof TypeDeclaration) {
                isValid = this.checkTypeDeclaration((TypeDeclaration)ce, fullCheck) && isValid;
            } else if (ce instanceof Participant) {
                isValid = this.checkParticipant((Participant)ce, fullCheck) && isValid;
            } else if (ce instanceof Application) {
                isValid = this.checkApplication((Application)ce, fullCheck) && isValid;
            } else if (ce instanceof DataField) {
                isValid = this.checkDataField((DataField)ce, fullCheck) && isValid;
            } else if (ce instanceof FormalParameter) {
                isValid = this.checkFormalParameter((FormalParameter)ce, fullCheck) && isValid;
            } else if (ce instanceof WorkflowProcess) {
                isValid = this.checkWorkflowProcess((WorkflowProcess)ce, fullCheck) && isValid;
            } else if (ce instanceof ActivitySet) {
                isValid = this.checkActivitySet((ActivitySet)ce, fullCheck) && isValid;
            } else if (ce instanceof Activity) {
                isValid = this.checkActivity((Activity)ce, fullCheck) && isValid;
            } else if (ce instanceof Transition) {
                isValid = this.checkTransition((Transition)ce, fullCheck) && isValid;
            }
        }
        return isValid;
    }

    public boolean checkTypeDeclaration(TypeDeclaration td, boolean fullCheck) {
        return true;
    }

    public boolean checkParticipant(Participant p, boolean fullCheck) {
        return true;
    }

    public boolean checkApplication(Application app, boolean fullCheck) {
        boolean isValid = true;
        if (app.getApplicationTypes().getChoosen() instanceof FormalParameters) {
            FormalParameters fps = app.getApplicationTypes().getFormalParameters();
            Iterator it = fps.toElements().iterator();
            while (it.hasNext() && (fullCheck || isValid)) {
                isValid = this.checkCollectionElement((XMLCollectionElement)it.next(), fullCheck) && isValid;
            }
        }
        return isValid;
    }

    public boolean checkDataField(DataField df, boolean fullCheck) {
        return this.checkDataType(df, fullCheck);
    }

    public boolean checkFormalParameter(FormalParameter fp, boolean fullCheck) {
        return this.checkDataType(fp, fullCheck);
    }

    public boolean checkDataType(XMLCollectionElement dfOrFp, boolean fullCheck) {
        TypeDeclaration td;
        boolean isValid = true;
        DataType xpdlType = (DataType)dfOrFp.get("DataType");
        XMLElement type = xpdlType.getDataTypes().getChoosen();
        if (type instanceof DeclaredType && (td = this.pkg.getTypeDeclaration(((DeclaredType)type).getId())) == null) {
            isValid = false;
            XMLElement firstOwner = dfOrFp.getParent().getParent();
            Map les = dfOrFp instanceof DataField ? this.getLogicErrors((XMLComplexElement)firstOwner) : (firstOwner instanceof ApplicationTypes ? this.getLogicErrors((XMLComplexElement)((ApplicationTypes)firstOwner).getParent().getParent()) : this.getLogicErrors((XMLComplexElement)firstOwner));
            String msg = (String)les.get(dfOrFp);
            msg = this.prepareMessageString(msg);
            msg = msg + XMLUtil.getLanguageDependentString("ErrorNonExistingDeclaredTypeReference");
            les.put(dfOrFp, msg);
        }
        return isValid;
    }

    public boolean checkWorkflowProcess(WorkflowProcess wp, boolean fullCheck) {
        HashMap<WorkflowProcess, String> les = new HashMap<WorkflowProcess, String>();
        this.logicErrors.put(wp, les);
        this.basicLogicErrors.remove(wp);
        boolean notDefined = false;
        boolean isValid = this.checkProcessHeader(wp, fullCheck);
        if (fullCheck || isValid) {
            boolean bl = isValid = this.checkRedefinableHeader(wp, fullCheck) && isValid;
        }
        if (fullCheck || isValid) {
            boolean bl = isValid = this.checkCollection("FormalParameters", wp, fullCheck) && isValid;
        }
        if (fullCheck || isValid) {
            boolean bl = isValid = this.checkCollection("DataFields", wp, fullCheck) && isValid;
        }
        if (fullCheck || isValid) {
            boolean bl = isValid = this.checkCollection("Participants", wp, fullCheck) && isValid;
        }
        if (fullCheck || isValid) {
            boolean bl = isValid = this.checkCollection("Applications", wp, fullCheck) && isValid;
        }
        if (fullCheck || isValid) {
            boolean bl = isValid = this.checkCollection("ActivitySets", wp, fullCheck) && isValid;
        }
        if (fullCheck || isValid) {
            if (wp.getActivities().toElements().size() == 0) {
                isValid = false;
                notDefined = true;
                les.put(wp, XMLUtil.getLanguageDependentString("ErrorProcessIsNotDefined"));
            } else {
                boolean bl = isValid = this.checkCollection("Activities", wp, fullCheck) && isValid;
            }
        }
        if (fullCheck || isValid) {
            boolean bl = isValid = this.checkCollection("Transitions", wp, fullCheck) && isValid;
        }
        if (!isValid) {
            this.basicLogicErrors.put(wp, les.values().toArray()[0]);
            Map pkgles = this.getLogicErrors(this.pkg);
            if (pkgles != null) {
                if (notDefined) {
                    pkgles.put(wp, XMLUtil.getLanguageDependentString("ErrorProcessIsNotDefined"));
                } else {
                    pkgles.put(wp, XMLUtil.getLanguageDependentString("ErrorProcessContainsOneOrMoreLogicErrors"));
                }
            }
        }
        return isValid;
    }

    public boolean checkProcessHeader(WorkflowProcess wp, boolean fullCheck) {
        return true;
    }

    public boolean checkActivitySet(ActivitySet as, boolean fullCheck) {
        HashMap<ActivitySet, String> les = new HashMap<ActivitySet, String>();
        this.logicErrors.put(as, les);
        this.basicLogicErrors.remove(as);
        boolean isValid = true;
        boolean notDefined = false;
        if (as.getActivities().toElements().size() == 0) {
            isValid = false;
            notDefined = true;
            les.put(as, XMLUtil.getLanguageDependentString("ErrorBlockActivityIsNotDefined"));
        } else {
            isValid = this.checkCollection("Activities", as, fullCheck);
        }
        if (fullCheck || isValid) {
            boolean bl = isValid = this.checkCollection("Transitions", as, fullCheck) && isValid;
        }
        if (!isValid) {
            this.basicLogicErrors.put(as, this.getLogicErrors(as).values().toArray()[0]);
            Map wples = this.getLogicErrors(XMLUtil.getWorkflowProcess(as));
            Activity blockActivity = this.findBlockActivity(as);
            if (wples != null && blockActivity != null) {
                if (notDefined) {
                    wples.put(blockActivity, XMLUtil.getLanguageDependentString("ErrorBlockActivityIsNotDefined"));
                } else {
                    wples.put(blockActivity, XMLUtil.getLanguageDependentString("ErrorInnerLogicError"));
                }
            } else if (wples != null) {
                wples.put(as, XMLUtil.getLanguageDependentString("ErrorBlockActivityIsNotDefined"));
            }
        }
        return isValid;
    }

    public boolean checkActivity(Activity act, boolean fullCheck) {
        Join join;
        boolean isValid = this.checkActivityPerformer(act, fullCheck);
        if (!fullCheck && !isValid) {
            return false;
        }
        int actType = act.getActivityType();
        if (actType == 4) {
            isValid = this.checkActivityBlock(act, fullCheck) && isValid;
        } else if (actType == 2) {
            isValid = this.checkActivityTools(act, fullCheck) && isValid;
        } else if (actType == 3) {
            boolean bl = isValid = this.checkActivitySubFlow(act, fullCheck) && isValid;
        }
        if (!fullCheck && !isValid) {
            return false;
        }
        Transitions trans = (Transitions)((XMLCollectionElement)act.getParent().getParent()).get("Transitions");
        Set outTrans = XMLUtil.getOutgoingTransitions(act);
        Set inTrans = XMLUtil.getIncomingTransitions(act);
        boolean bl = isValid = this.checkActivityDeadlines(act, fullCheck) && isValid;
        if (!fullCheck && !isValid) {
            return false;
        }
        Map les = this.getLogicErrors((XMLComplexElement)act.getParent().getParent());
        String msg = (String)les.get(act);
        Split split = XMLUtil.getSplit(act);
        if ((split == null || split.getType().length() == 0) && outTrans.size() > 1) {
            isValid = false;
            msg = this.prepareMessageString(msg);
            msg = msg + XMLUtil.getLanguageDependentString("ErrorMultipleOutgoingTransitionsWithoutSplitTypeDefined");
            les.put(act, msg);
        }
        if (!fullCheck && !isValid) {
            return false;
        }
        if (split != null) {
            TransitionRefs tRfs = split.getTransitionRefs();
            if (tRfs.size() != outTrans.size() && outTrans.size() > 1 && !split.getType().equals("AND")) {
                isValid = false;
                msg = this.prepareMessageString(msg);
                msg = msg + XMLUtil.getLanguageDependentString("ErrorNumberOfActivitiesOutgoingTransitionsAndTransitionRefsIsNotSame");
                les.put(act, msg);
            }
            if (!fullCheck && !isValid) {
                return false;
            }
            Iterator tRefs = tRfs.toElements().iterator();
            boolean invalidTref = false;
            while (tRefs.hasNext()) {
                String transitionId = ((TransitionRef)tRefs.next()).getId();
                Transition t = trans.getTransition(transitionId);
                if (t != null && outTrans.contains(t)) continue;
                isValid = false;
                invalidTref = true;
            }
            if (invalidTref) {
                msg = this.prepareMessageString(msg);
                msg = msg + XMLUtil.getLanguageDependentString("ErrorTransitionRefIsNotValid");
                les.put(act, msg);
            }
            if (!fullCheck && !isValid) {
                return false;
            }
        }
        if (((join = XMLUtil.getJoin(act)) == null || join.getType().length() == 0) && inTrans.size() > 1) {
            isValid = false;
            msg = this.prepareMessageString(msg);
            msg = msg + XMLUtil.getLanguageDependentString("ErrorMultipleIncomingTransitionsWithoutJoinTypeDefined");
            les.put(act, msg);
        }
        if (!fullCheck && !isValid) {
            return false;
        }
        isValid = this.checkMultipleOtherwiseOrDefaultExceptionTransitions(act, fullCheck) && isValid;
        return isValid;
    }

    public boolean checkActivityPerformer(Activity act, boolean fullCheck) {
        boolean isValid = true;
        String performer = act.getPerformer().trim();
        int actType = act.getActivityType();
        boolean hasToCheck = true;
        if (actType != 1 || actType != 2) {
            hasToCheck = false;
        }
        if (hasToCheck && performer.length() > 0) {
            isValid = false;
            Map les = this.getLogicErrors((XMLComplexElement)act.getParent().getParent());
            String msg = (String)les.get(act);
            msg = this.prepareMessageString(msg);
            msg = msg + XMLUtil.getLanguageDependentString("ErrorActivityCannotHavePerformer");
            les.put(act, msg);
        }
        return isValid;
    }

    public boolean checkActivityTools(Activity act, boolean fullCheck) {
        boolean isValid = true;
        boolean nonExistingToolReference = false;
        Tools tools = act.getActivityTypes().getImplementation().getImplementationTypes().getTools();
        Iterator it = tools.toElements().iterator();
        while (it.hasNext() && (fullCheck || isValid)) {
            Tool tool = (Tool)it.next();
            String toolID = tool.getId();
            if (toolID == null || toolID.equals("")) {
                isValid = false;
                nonExistingToolReference = true;
            }
            if (!isValid && !fullCheck) break;
            WorkflowProcess wp = XMLUtil.getWorkflowProcess(act);
            Application app = null;
            if (toolID != null) {
                app = wp.getApplication(toolID);
                if (app == null) {
                    app = this.pkg.getApplication(toolID);
                }
                if (app == null) {
                    Package p;
                    List l = XMLUtil.getAllExternalPackageIds(this.xmlInterface, this.pkg);
                    Iterator ita = l.iterator();
                    while (ita.hasNext() && ((p = this.xmlInterface.getPackageById((String)ita.next())) == null || (app = p.getApplication(toolID)) == null)) {
                    }
                }
            }
            try {
                isValid = this.checkParameterMappings(tool, app, fullCheck) && isValid;
            }
            catch (Exception exception) {}
        }
        if (!isValid) {
            Map les = this.getLogicErrors((XMLComplexElement)act.getParent().getParent());
            String msg = (String)les.get(act);
            msg = this.prepareMessageString(msg);
            msg = nonExistingToolReference ? msg + XMLUtil.getLanguageDependentString("ErrorNonExistingToolReference") : msg + XMLUtil.getLanguageDependentString("ErrorToolsFormalAndActualParametersDoNotMatch");
            les.put(act, msg);
        }
        return isValid;
    }

    public boolean checkActivitySubFlow(Activity act, boolean fullCheck) {
        boolean isValid = true;
        boolean nonExistingProcessReference = false;
        boolean notAllowedProcessReference = false;
        SubFlow s = act.getActivityTypes().getImplementation().getImplementationTypes().getSubFlow();
        String subflowID = s.getId();
        if (subflowID == null || subflowID.trim().equals("")) {
            isValid = false;
            nonExistingProcessReference = true;
        }
        Package pkg = XMLUtil.getPackage(act);
        WorkflowProcess wp = null;
        if (isValid && (wp = pkg.getWorkflowProcess(subflowID)) == null) {
            Package p;
            List l = XMLUtil.getAllExternalPackageIds(this.xmlInterface, pkg);
            Iterator it = l.iterator();
            while (it.hasNext() && ((p = this.xmlInterface.getPackageById((String)it.next())) == null || (wp = p.getWorkflowProcess(subflowID)) == null)) {
            }
        }
        if ((fullCheck || isValid) && wp != null) {
            try {
                isValid = this.checkParameterMappings(s, wp, fullCheck) && isValid;
            }
            catch (Exception l) {
                // empty catch block
            }
        }
        if (!isValid) {
            Map les = this.getLogicErrors((XMLComplexElement)act.getParent().getParent());
            String msg = (String)les.get(act);
            msg = this.prepareMessageString(msg);
            msg = nonExistingProcessReference ? msg + XMLUtil.getLanguageDependentString("ErrorNonExistingProcessReference") : (nonExistingProcessReference ? msg + XMLUtil.getLanguageDependentString("ErrorNotAllowedProcessReference") : msg + XMLUtil.getLanguageDependentString("ErrorSubFlowFormalAndActualParametersDoNotMatch"));
            les.put(act, msg);
        }
        return isValid;
    }

    public boolean checkActivityBlock(Activity act, boolean fullCheck) {
        boolean isValid = true;
        BlockActivity blk = act.getActivityTypes().getBlockActivity();
        String blockId = blk.getBlockId();
        ActivitySet as = XMLUtil.getWorkflowProcess(act).getActivitySet(blockId);
        if (as == null || act.getParent().getParent().equals(as)) {
            isValid = false;
            Map les = this.getLogicErrors((XMLComplexElement)act.getParent().getParent());
            String msg = (String)les.get(act);
            msg = this.prepareMessageString(msg);
            msg = as == null ? msg + XMLUtil.getLanguageDependentString("ErrorNonExistingActivitySetReference") : msg + XMLUtil.getLanguageDependentString("ErrorNotAllowedActivitySetReference");
            les.put(act, msg);
        }
        return isValid;
    }

    public boolean checkActivityDeadlines(Activity act, boolean fullCheck) {
        boolean isValid = true;
        ArrayList deadlines = act.getDeadlines().toElements();
        if (deadlines.size() == 0) {
            return isValid;
        }
        Iterator dls = deadlines.iterator();
        int syncCount = 0;
        while (dls.hasNext()) {
            Deadline dl = (Deadline)dls.next();
            if (!dl.getExecution().equals("SYNCHR")) continue;
            ++syncCount;
        }
        Map les = this.getLogicErrors((XMLComplexElement)act.getParent().getParent());
        String msg = (String)les.get(act);
        if (syncCount > 1) {
            isValid = false;
            msg = this.prepareMessageString(msg);
            msg = msg + XMLUtil.getLanguageDependentString("ErrorActivityCanHaveOnlyOneSynchronousDeadline");
            les.put(act, msg);
        }
        if (!fullCheck && !isValid) {
            return false;
        }
        if (XMLUtil.getExceptionalOutgoingTransitions(act).size() == 0) {
            isValid = false;
            msg = this.prepareMessageString(msg);
            msg = msg + XMLUtil.getLanguageDependentString("ErrorDeadlineExceptionIsNotHandledByAnyOutgoingTransitionWithExceptionOrDefaultExceptionConditionType");
            les.put(act, msg);
        }
        return isValid;
    }

    public boolean checkMultipleOtherwiseOrDefaultExceptionTransitions(Activity act, boolean fullCheck) {
        Set outTrans = XMLUtil.getOutgoingTransitions(act);
        boolean foundOtherwise = false;
        boolean foundMultipleOtherwise = false;
        boolean foundDefaultException = false;
        boolean foundMultipleDefaultException = false;
        for (Transition t : outTrans) {
            String ct = t.getCondition().getType();
            if (ct.equals("OTHERWISE")) {
                if (foundOtherwise) {
                    foundMultipleOtherwise = true;
                    if (!foundMultipleDefaultException && fullCheck) continue;
                    break;
                }
                foundOtherwise = true;
                continue;
            }
            if (!ct.equals("DEFAULTEXCEPTION")) continue;
            if (foundDefaultException) {
                foundMultipleDefaultException = true;
                if (!foundMultipleOtherwise && fullCheck) continue;
                break;
            }
            foundDefaultException = true;
        }
        if (foundMultipleOtherwise || foundMultipleDefaultException) {
            Map les = this.getLogicErrors((XMLComplexElement)act.getParent().getParent());
            String msg = (String)les.get(act);
            msg = this.prepareMessageString(msg);
            if (foundMultipleDefaultException && foundMultipleOtherwise) {
                msg = msg + XMLUtil.getLanguageDependentString("ErrorMoreThenOneOTHERWISEAndDEFAULTEXCEPTIONTypeOutgoingTransition");
            } else if (foundMultipleOtherwise) {
                msg = msg + XMLUtil.getLanguageDependentString("ErrorMoreThenOneOTHERWISETypeOutgoingTransition");
            } else if (foundMultipleDefaultException) {
                msg = msg + XMLUtil.getLanguageDependentString("ErrorMoreThenOneDEFAULTEXCEPTIONTypeOutgoingTransition");
            }
            les.put(act, msg);
            return false;
        }
        return true;
    }

    public boolean checkParameterMappings(XMLComplexElement toolOrSbflw, XMLComplexElement appOrWp, boolean fullCheck) {
        FormalParameters fps;
        if (appOrWp instanceof WorkflowProcess) {
            fps = ((WorkflowProcess)appOrWp).getFormalParameters();
        } else {
            ApplicationTypes ats = ((Application)appOrWp).getApplicationTypes();
            if (ats.getChoosen() instanceof FormalParameters) {
                fps = ats.getFormalParameters();
            } else {
                return true;
            }
        }
        ActualParameters aps = (ActualParameters)toolOrSbflw.get("ActualParameters");
        int pm = XMLUtil.checkParameterMatching(fps, aps);
        return pm == 0;
    }

    public boolean checkTransition(Transition transition, boolean fullCheck) {
        boolean isValid = true;
        Map les = this.getLogicErrors((XMLComplexElement)transition.getParent().getParent());
        String msg = (String)les.get(transition);
        if (XMLUtil.getFromActivity(transition) == null) {
            isValid = false;
            msg = this.prepareMessageString(msg);
            msg = msg + XMLUtil.getLanguageDependentString("ErrorNonExistingFromActivityReference");
        }
        if (XMLUtil.getToActivity(transition) == null) {
            isValid = false;
            msg = this.prepareMessageString(msg);
            msg = msg + XMLUtil.getLanguageDependentString("ErrorNonExistingToActivityReference");
        }
        if (!isValid) {
            les.put(transition, msg);
        }
        return isValid;
    }

    public boolean isIdValid(String id) {
        return XMLUtil.isIdValid(id);
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static boolean isUniqueId(XMLCollection xmlCol, String id) {
        int idCnt = 0;
        Iterator it = xmlCol.toElements().iterator();
        while (it.hasNext()) {
            try {
                XMLCollectionElement xmlce = (XMLCollectionElement)it.next();
                String cId = xmlce.getId();
                if (!cId.equals(id) || ++idCnt <= 1) continue;
                return false;
            }
            catch (ClassCastException cce) {
                return true;
            }
        }
        return true;
    }

    public static void main(String[] args) {
        try {
            XMLInterfaceForJDK13 xmlI = new XMLInterfaceForJDK13();
            Package pkg = xmlI.parseDocument(args[0], true);
            PackageValidator validator = new PackageValidator(null, pkg, false, true, false, false);
            if (validator.validateAll(false)) {
                System.out.println(args[0] + " is a valid XPDL package");
            } else {
                System.out.println(args[0] + " is not a valid XPDL package");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    public static void printIM(boolean[][] im, List acts) {
        if (im != null) {
            for (int i = 0; i < im.length; ++i) {
                for (int j = 0; j < im[i].length; ++j) {
                    System.out.print(acts.get(i) + "->" + acts.get(j) + "=" + im[i][j] + " ");
                }
                System.out.println();
            }
        } else {
            System.out.println("Passed array is null !!!");
        }
    }

    public static void printIM2(boolean[][] im, List acts) {
        System.out.println("Activities are" + acts);
        if (im != null) {
            for (int i = 0; i < im.length; ++i) {
                for (int j = 0; j < im[i].length; ++j) {
                    System.out.print((im[i][j] ? "1" : "0") + " ");
                }
                System.out.println();
            }
        } else {
            System.out.println("Passed array is null !!!");
        }
    }

    public boolean checkGraphConformance(boolean fullCheck) {
        boolean areGraphsConformant = true;
        HashMap<WorkflowProcess, String> graphConformanceErrors = new HashMap<WorkflowProcess, String>();
        ArrayList<String> basicGraphConformanceErrors = new ArrayList<String>();
        for (WorkflowProcess wp : this.pkg.getWorkflowProcesses().toElements()) {
            if (this.checkGraphConformance(wp, fullCheck)) continue;
            areGraphsConformant = false;
            if (!fullCheck) break;
            String msg = "";
            Iterator bces = this.getBasicGraphConformanceErrors(wp).iterator();
            while (bces.hasNext()) {
                msg = msg + bces.next().toString() + "<br>";
            }
            graphConformanceErrors.put(wp, msg);
        }
        if (!areGraphsConformant) {
            basicGraphConformanceErrors.add(XMLUtil.getLanguageDependentString("ErrorOneOrMoreProcessesDoNotSatisfyGraphConformance"));
        }
        this.basicGraphsConformanceErrors.put(this.pkg, basicGraphConformanceErrors);
        this.graphsConformanceErrors.put(this.pkg, graphConformanceErrors);
        return areGraphsConformant;
    }

    public boolean checkGraphConformance(XMLCollectionElement wpOrAs, boolean fullCheck) {
        Activity act2;
        HashMap<Activity, String> graphConformanceErrors = new HashMap<Activity, String>();
        ArrayList<String> basicGraphConformanceErrors = new ArrayList<String>();
        ArrayList allActs = ((XMLCollection)wpOrAs.get("Activities")).toElements();
        Package pkg = XMLUtil.getPackage(wpOrAs);
        String conformanceClass = pkg.getConformanceClass().getGraphConformance();
        int ct = XMLUtil.getConformanceClassNo(conformanceClass);
        Activities acts = (Activities)wpOrAs.get("Activities");
        SequencedHashMap activities = acts.toElementMap();
        if (activities.size() == 0) {
            this.graphsConformanceErrors.put(wpOrAs, graphConformanceErrors);
            this.basicGraphsConformanceErrors.put(wpOrAs, basicGraphConformanceErrors);
            return true;
        }
        boolean isGraphConformant = true;
        Set splitActs = XMLUtil.getSplitOrJoinActivities(activities.values(), 0);
        Set joinActs = XMLUtil.getSplitOrJoinActivities(activities.values(), 1);
        HashSet noSplitActs = new HashSet(activities.values());
        noSplitActs.removeAll(splitActs);
        GraphChecker gc = null;
        if (ct > 0 && (isGraphConformant || fullCheck)) {
            boolean[][] incidenceMatrix = this.createIncidenceMatrix(activities);
            if (incidenceMatrix == null) {
                basicGraphConformanceErrors.add("Unexpected error");
                this.graphsConformanceErrors.put(wpOrAs, graphConformanceErrors);
                this.basicGraphsConformanceErrors.put(wpOrAs, basicGraphConformanceErrors);
                return false;
            }
            gc = new GraphChecker(incidenceMatrix);
            boolean loopError = false;
            if (fullCheck) {
                int[] loopNodes = gc.getCyclicNodes();
                if (loopNodes != null) {
                    isGraphConformant = false;
                    loopError = true;
                    for (int i = 0; i < loopNodes.length; ++i) {
                        act2 = (Activity)activities.get(loopNodes[i]);
                        graphConformanceErrors.put(act2, XMLUtil.getLanguageDependentString("ErrorLoopContainedActivity"));
                    }
                }
            } else {
                loopError = gc.isGraphCyclic();
                if (loopError) {
                    isGraphConformant = false;
                }
            }
            if (loopError) {
                basicGraphConformanceErrors.add(XMLUtil.getLanguageDependentString("ErrorTheGraphIsCyclic"));
            }
        }
        if (ct == 2 && (isGraphConformant || fullCheck)) {
            if (XMLUtil.getStartingActivities(wpOrAs).size() != 1) {
                isGraphConformant = false;
                basicGraphConformanceErrors.add(XMLUtil.getLanguageDependentString("ErrorThereMustBeExactlyOneStartingActivityInFullBlockedMode"));
            }
            if ((isGraphConformant || fullCheck) && XMLUtil.getEndingActivities(wpOrAs).size() != 1) {
                isGraphConformant = false;
                basicGraphConformanceErrors.add(XMLUtil.getLanguageDependentString("ErrorThereMustBeExactlyOneEndingActivityInFullBlockedMode"));
            }
            boolean smerr = false;
            if ((isGraphConformant || fullCheck) && splitActs.size() != joinActs.size()) {
                if (splitActs.size() > joinActs.size()) {
                    basicGraphConformanceErrors.add(XMLUtil.getLanguageDependentString("ErrorTheNumberOfSplitsAndJoinsIsNotTheSame-MoreSplits"));
                } else {
                    basicGraphConformanceErrors.add(XMLUtil.getLanguageDependentString("ErrorTheNumberOfSplitsAndJoinsIsNotTheSame-MoreJoins"));
                }
                isGraphConformant = false;
                smerr = true;
            }
            if ((isGraphConformant || fullCheck) && !smerr && this.getNoOfANDSplitsOrJoins(splitActs, 0) != this.getNoOfANDSplitsOrJoins(joinActs, 1)) {
                basicGraphConformanceErrors.add(XMLUtil.getLanguageDependentString("ErrorOneOrMoreSplitsDoNotHaveCorrespondingJoinBecauseOfTypeMismatch"));
                isGraphConformant = false;
            }
            if (isGraphConformant || fullCheck) {
                String msg;
                Iterator it = splitActs.iterator();
                boolean andSplitError = false;
                boolean xorSplitError = false;
                while (it.hasNext()) {
                    act2 = (Activity)it.next();
                    if (XMLUtil.isANDTypeSplitOrJoin(act2, 0)) {
                        if (this.checkANDSplit(act2)) continue;
                        isGraphConformant = false;
                        andSplitError = true;
                        msg = (String)graphConformanceErrors.get(act2);
                        msg = this.prepareMessageString(msg);
                        msg = msg + XMLUtil.getLanguageDependentString("ErrorOneOrMoreConditionalOutgoingTransitions");
                        graphConformanceErrors.put(act2, msg);
                        if (fullCheck) continue;
                        break;
                    }
                    if (this.checkXORSplit(act2)) continue;
                    isGraphConformant = false;
                    xorSplitError = true;
                    msg = (String)graphConformanceErrors.get(act2);
                    msg = this.prepareMessageString(msg);
                    msg = msg + XMLUtil.getLanguageDependentString("ErrorMissingOTHERWISETypeOutgoingTransition");
                    graphConformanceErrors.put(act2, msg);
                    if (fullCheck) continue;
                    break;
                }
                for (Activity act2 : noSplitActs) {
                    if (this.checkXORSplit(act2)) continue;
                    isGraphConformant = false;
                    xorSplitError = true;
                    msg = (String)graphConformanceErrors.get(act2);
                    msg = this.prepareMessageString(msg);
                    msg = msg + XMLUtil.getLanguageDependentString("ErrorMissingOTHERWISETypeOutgoingTransition");
                    graphConformanceErrors.put(act2, msg);
                    if (fullCheck) continue;
                    break;
                }
                if (andSplitError) {
                    basicGraphConformanceErrors.add(XMLUtil.getLanguageDependentString("ErrorOneOrMoreANDSplitsHaveConditionalOutgoingTransitions"));
                }
                if (xorSplitError) {
                    basicGraphConformanceErrors.add(XMLUtil.getLanguageDependentString("ErrorOneOrMoreXORSplitsWithConditionalTransitionsDoNotHaveOTHERWISETransition"));
                }
            }
            if (isGraphConformant || fullCheck) {
                boolean noCorrespondingJoinError = false;
                for (Activity act3 : splitActs) {
                    String msg;
                    int splitIndex = activities.indexOf((Object)act3);
                    if (splitIndex == -1) {
                        basicGraphConformanceErrors.add("Unexpected error");
                        isGraphConformant = false;
                        if (fullCheck) continue;
                        break;
                    }
                    int ji = gc.getJoinIndex(splitIndex);
                    if (ji < 0) {
                        isGraphConformant = false;
                        noCorrespondingJoinError = true;
                        msg = (String)graphConformanceErrors.get(act3);
                        msg = this.prepareMessageString(msg);
                        msg = msg + XMLUtil.getLanguageDependentString("ErrorThereIsNoCorrespondingJoinActivity");
                        graphConformanceErrors.put(act3, msg);
                        if (fullCheck) continue;
                        break;
                    }
                    if (XMLUtil.isANDTypeSplitOrJoin(act3, 0) == XMLUtil.isANDTypeSplitOrJoin((Activity)activities.get(ji), 1)) continue;
                    isGraphConformant = false;
                    noCorrespondingJoinError = true;
                    msg = (String)graphConformanceErrors.get(act3);
                    msg = this.prepareMessageString(msg);
                    msg = XMLUtil.isANDTypeSplitOrJoin(act3, ji) ? msg + XMLUtil.getLanguageDependentString("ErrorTheCorrespondingJoinActivityDoesNotHaveTheSameType-ANDXOR") : msg + XMLUtil.getLanguageDependentString("ErrorTheCorrespondingJoinActivityDoesNotHaveTheSameType-XORAND");
                    graphConformanceErrors.put(act3, msg);
                    if (fullCheck) continue;
                    break;
                }
                if (noCorrespondingJoinError) {
                    basicGraphConformanceErrors.add(XMLUtil.getLanguageDependentString("ErrorOneOrMoreSplitsDoNotHaveCorrespondingJoin"));
                }
            }
        }
        if (isGraphConformant || fullCheck) {
            Set blockActivities = XMLUtil.getBlockActivities(wpOrAs, false);
            boolean innerConformanceError = false;
            for (Activity act4 : blockActivities) {
                BlockActivity ba = act4.getActivityTypes().getBlockActivity();
                String asId = ba.getBlockId();
                ActivitySet as = XMLUtil.getWorkflowProcess(act4).getActivitySet(asId);
                if (as == null || this.checkGraphConformance(as, false)) continue;
                isGraphConformant = false;
                innerConformanceError = true;
                String msg = (String)graphConformanceErrors.get(ba);
                msg = this.prepareMessageString(msg);
                msg = msg + XMLUtil.getLanguageDependentString("ErrorInnerGraphConformanceError");
                graphConformanceErrors.put(act4, msg);
                graphConformanceErrors.put(act4, msg);
                if (fullCheck) continue;
                break;
            }
            if (innerConformanceError) {
                basicGraphConformanceErrors.add(XMLUtil.getLanguageDependentString("ErrorOneOrMoreBlockActivitiesAreNotValid"));
            }
        }
        this.graphsConformanceErrors.put(wpOrAs, graphConformanceErrors);
        this.basicGraphsConformanceErrors.put(wpOrAs, basicGraphConformanceErrors);
        return isGraphConformant;
    }

    protected boolean[][] createIncidenceMatrix(SequencedHashMap sortedMap) {
        int size = sortedMap.size();
        boolean[][] incidenceMatrix = new boolean[size][size];
        for (int indAct = 0; indAct < size; ++indAct) {
            Activity a = (Activity)sortedMap.get(indAct);
            HashSet oas = new HashSet();
            for (Transition t : XMLUtil.getOutgoingTransitions(a)) {
                String aOut = t.getTo();
                int indOut = sortedMap.indexOf((Object)aOut);
                if (indOut == -1) {
                    return null;
                }
                incidenceMatrix[indAct][indOut] = true;
            }
        }
        return incidenceMatrix;
    }

    protected int getNoOfANDSplitsOrJoins(Set acts, int sOrJ) {
        int no = 0;
        for (Activity act : acts) {
            if (sOrJ == 0 && XMLUtil.isANDTypeSplitOrJoin(act, 0)) {
                ++no;
                continue;
            }
            if (sOrJ != 1 || !XMLUtil.isANDTypeSplitOrJoin(act, 0)) continue;
            ++no;
        }
        return no;
    }

    protected boolean checkANDSplit(Activity act) {
        return !this.hasAnyPostcondition(act);
    }

    protected boolean checkXORSplit(Activity act) {
        if (this.hasAnyPostcondition(act)) {
            Set ots = XMLUtil.getOutgoingTransitions(act);
            for (Transition t : ots) {
                if (!t.getCondition().getType().equals("OTHERWISE")) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    protected boolean hasAnyPostcondition(Activity act) {
        Set outL = XMLUtil.getOutgoingTransitions(act);
        Iterator it = outL.iterator();
        while (it.hasNext()) {
            if (((Transition)it.next()).getCondition().toValue().equals("")) continue;
            return true;
        }
        return false;
    }

    public boolean checkGraphConnections(boolean fullCheck) {
        this.basicGraphConnectionErrors.remove(this.pkg);
        this.graphsConnectionErrors.remove(this.pkg);
        boolean areWellConnected = true;
        HashMap<WorkflowProcess, String> connectionErrorMessages = new HashMap<WorkflowProcess, String>();
        for (WorkflowProcess wp : this.pkg.getWorkflowProcesses().toElements()) {
            if (this.checkGraphConnections(wp, false)) continue;
            areWellConnected = false;
            if (!fullCheck) break;
            String msg = this.getBasicGraphConnectionError(wp);
            if (msg == null) {
                msg = "";
            }
            connectionErrorMessages.put(wp, msg);
        }
        if (!areWellConnected) {
            String basicGraphConnectionError = XMLUtil.getLanguageDependentString("InformationOneOrMoreProcessesHaveImproperlyConnectedElements");
            this.basicGraphConnectionErrors.put(this.pkg, basicGraphConnectionError);
        }
        this.graphsConnectionErrors.put(this.pkg, connectionErrorMessages);
        return areWellConnected;
    }

    public boolean checkGraphConnections(XMLCollectionElement wpOrAs, boolean fullCheck) {
        String msg;
        if (wpOrAs == null) {
            return false;
        }
        this.basicGraphConnectionErrors.remove(wpOrAs);
        this.graphsConnectionErrors.remove(wpOrAs);
        boolean isWellConnected = true;
        boolean basicError = false;
        HashMap<XMLCollectionElement, String> connectionErrorMessages = new HashMap<XMLCollectionElement, String>();
        Transitions ts = (Transitions)wpOrAs.get("Transitions");
        ArrayList acts = ((Activities)wpOrAs.get("Activities")).toElements();
        if (acts == null || acts.size() == 0) {
            this.graphsConnectionErrors.put(wpOrAs, connectionErrorMessages);
            return true;
        }
        Set startActs = null;
        Set endActs = null;
        if ((fullCheck || isWellConnected) && (startActs = XMLUtil.getStartingActivities(wpOrAs)).size() == 0 && (!this.allowUndefinedStart || wpOrAs instanceof ActivitySet)) {
            isWellConnected = false;
            basicError = true;
            msg = (String)connectionErrorMessages.get(wpOrAs);
            msg = this.prepareMessageString(msg);
            msg = msg + XMLUtil.getLanguageDependentString("ErrorStartingActivityDoesNotExist");
            connectionErrorMessages.put(wpOrAs, msg);
        }
        if ((fullCheck || isWellConnected) && (endActs = XMLUtil.getEndingActivities(wpOrAs)).size() == 0 && (!this.allowUndefinedEnd || wpOrAs instanceof ActivitySet)) {
            isWellConnected = false;
            basicError = true;
            msg = (String)connectionErrorMessages.get(wpOrAs);
            msg = this.prepareMessageString(msg);
            msg = msg + XMLUtil.getLanguageDependentString("ErrorEndingActivityDoesNotExist");
            connectionErrorMessages.put(wpOrAs, msg);
        }
        if (fullCheck || isWellConnected) {
            for (Activity act : acts) {
                String cem = this.checkActivityConnection(act, ts, startActs, endActs, fullCheck);
                if (cem == null) continue;
                connectionErrorMessages.put(act, cem);
                isWellConnected = false;
                if (fullCheck) continue;
                break;
            }
        }
        if (!isWellConnected) {
            if (basicError) {
                this.basicGraphConnectionErrors.put(wpOrAs, connectionErrorMessages.get(wpOrAs));
            } else {
                this.basicGraphConnectionErrors.put(wpOrAs, XMLUtil.getLanguageDependentString("InformationOneOrMoreElementsAreNotProperlyConnected"));
            }
        }
        this.graphsConnectionErrors.put(wpOrAs, connectionErrorMessages);
        return isWellConnected;
    }

    public String checkActivityConnection(Activity act, Transitions ts, Set startActs, Set endActs, boolean fullCheck) {
        String connectionErrorMsg = "";
        if (act.getActivityTypes().getChoosen() instanceof BlockActivity) {
            BlockActivity ba = act.getActivityTypes().getBlockActivity();
            String asId = ba.getBlockId();
            ActivitySet as = XMLUtil.getWorkflowProcess(act).getActivitySet(asId);
            if (as != null && !this.checkGraphConnections(as, false)) {
                connectionErrorMsg = connectionErrorMsg + XMLUtil.getLanguageDependentString("ErrorInnerTransitionError") + "; ";
            }
        }
        if (connectionErrorMsg.length() == 0) {
            connectionErrorMsg = null;
        }
        return connectionErrorMsg;
    }

    protected Activity findBlockActivity(ActivitySet as) {
        String asId = as.getId();
        WorkflowProcess wp = XMLUtil.getWorkflowProcess(as);
        Set bas = XMLUtil.getBlockActivities(wp, true);
        for (Activity a : bas) {
            String baId = a.getActivityTypes().getBlockActivity().getBlockId();
            if (!baId.equals(asId)) continue;
            return a;
        }
        return null;
    }

    protected String prepareMessageString(String msg) {
        msg = msg != null ? msg + "; " : "";
        return msg;
    }
}

