/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.utilities;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.Vector;
import org.enhydra.shark.api.RootException;
import org.enhydra.shark.utilities.TraverseException;

public class MiscUtilities {
    public static void traverse(File f, Collection c, FileFilter filter) throws TraverseException {
        if (!f.exists()) {
            return;
        }
        if (f.isDirectory()) {
            File[] children = f.listFiles(filter);
            if (children == null) {
                throw new TraverseException(String.format("Could not list files of directory [%s] (no directory permissions?)", f.getAbsolutePath()));
            }
            for (int i = 0; i < children.length; ++i) {
                MiscUtilities.traverse(children[i], c, filter);
            }
        } else {
            c.add(f);
        }
    }

    public static byte[] serialize(Object obj) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream oout = new ObjectOutputStream(bout);
        oout.writeObject(obj);
        oout.flush();
        byte[] array = bout.toByteArray();
        oout.close();
        bout.close();
        return array;
    }

    public static Object deserialize(byte[] array) throws Throwable {
        ObjectInputStream rin = new ObjectInputStream(new ByteArrayInputStream(array));
        Object obj = rin.readObject();
        rin.close();
        return obj;
    }

    public static long getAbsoluteTimeInUTCFormat() {
        return System.currentTimeMillis();
    }

    public static String[] tokenize(String input, String boundary) {
        if (input == null) {
            input = "";
        }
        Vector<String> v = new Vector<String>();
        StringTokenizer t = new StringTokenizer(input, boundary);
        while (t.hasMoreTokens()) {
            v.addElement(t.nextToken());
        }
        String[] cmd = new String[v.size()];
        for (int i = 0; i < cmd.length; ++i) {
            cmd[i] = (String)v.elementAt(i);
        }
        return cmd;
    }

    public static String getTimeDiff(long tStart, long tEnd) {
        long sec = 1000L;
        long min = sec * 60L;
        long hour = min * 60L;
        long day = hour * 24L;
        long month = day * 30L;
        long year = 365L * day;
        long diffInMills = tEnd - tStart;
        if (diffInMills < min) {
            return String.valueOf(diffInMills / sec) + " [s]";
        }
        if (diffInMills < hour) {
            long m = diffInMills / min;
            long s = (diffInMills - m * min) / sec;
            return String.valueOf(m) + " [min] " + String.valueOf(s) + " [s]";
        }
        if (diffInMills < day) {
            long h = diffInMills / hour;
            long m = (diffInMills - h * hour) / min;
            long s = (diffInMills - h * hour - m * min) / sec;
            return String.valueOf(h) + " [h] " + String.valueOf(m) + " [min] " + String.valueOf(s) + " [s]";
        }
        if (diffInMills < month) {
            long d = diffInMills / day;
            long h = (diffInMills - d * day) / hour;
            long m = (diffInMills - d * day - h * hour) / min;
            long s = (diffInMills - d * day - h * hour - m * min) / sec;
            return String.valueOf(d) + " [d] " + String.valueOf(h) + " [h] " + String.valueOf(m) + " [min] " + String.valueOf(s) + " [s]";
        }
        if (diffInMills < year) {
            long mn = diffInMills / month;
            long d = (diffInMills - mn * month) / day;
            long h = (diffInMills - mn * month - d * day) / hour;
            long m = (diffInMills - mn * month - d * day - h * hour) / min;
            long s = (diffInMills - mn * month - d * day - h * hour - m * min) / sec;
            return String.valueOf(mn) + " [m] " + String.valueOf(d) + " [d] " + String.valueOf(h) + " [h] " + String.valueOf(m) + " [min] " + String.valueOf(s) + " [s]";
        }
        long y = diffInMills / year;
        long mn = (diffInMills - y * year) / month;
        long d = (diffInMills - y * year - mn * month) / day;
        long h = (diffInMills - y * year - mn * month - d * day) / hour;
        long m = (diffInMills - y * year - mn * month - d * day - h * hour) / min;
        long s = (diffInMills - y * year - mn * month - d * day - h * hour - m * min) / sec;
        return String.valueOf(y) + " [y] " + String.valueOf(mn) + " [m] " + String.valueOf(d) + " [d] " + String.valueOf(h) + " [h] " + String.valueOf(m) + " [min] " + String.valueOf(s) + " [s]";
    }

    public static void copyFile(String src, String dest) throws IOException {
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dest);
        byte[] buffer = new byte[1024];
        int read = -1;
        while ((read = in.read(buffer, 0, 1024)) != -1) {
            out.write(buffer, 0, read);
        }
        out.flush();
        out.close();
        in.close();
    }

    public static String convertMillisecondsToDateAndTimeString(long cdt) {
        String dateSeparator = "-";
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(new Date(cdt));
        int YYYY = cal.get(1);
        int MM = cal.get(2) + 1;
        int DD = cal.get(5);
        int HH = cal.get(11);
        int mm = cal.get(12);
        int ss = cal.get(13);
        int mmmm = cal.get(14);
        String dateTime = "";
        dateTime = dateTime + String.valueOf(YYYY) + dateSeparator;
        if (MM < 10) {
            dateTime = dateTime + "0";
        }
        dateTime = dateTime + String.valueOf(MM) + dateSeparator;
        if (DD < 10) {
            dateTime = dateTime + "0";
        }
        dateTime = dateTime + String.valueOf(DD) + dateSeparator;
        if (cal.get(9) == 1 && HH < 12) {
            HH += 12;
        }
        if (HH < 10) {
            dateTime = dateTime + "0";
        }
        dateTime = dateTime + String.valueOf(HH) + dateSeparator;
        if (mm < 10) {
            dateTime = dateTime + "0";
        }
        dateTime = dateTime + String.valueOf(mm) + dateSeparator;
        if (ss < 10) {
            dateTime = dateTime + "0";
        }
        dateTime = dateTime + String.valueOf(ss) + dateSeparator;
        dateTime = mmmm < 10 ? dateTime + "000" : (mmmm < 100 ? dateTime + "00" : dateTime + "0");
        dateTime = dateTime + String.valueOf(mmmm);
        return dateTime;
    }

    public static long convertDateAndTimeStringToMilliseconds(String dateTime) {
        String dateSeparator = "-";
        String[] dts = MiscUtilities.tokenize(dateTime, dateSeparator);
        if (dts == null || dts.length != 7) {
            return -1L;
        }
        int YYYY = Integer.parseInt(dts[0]);
        int MM = Integer.parseInt(dts[1]);
        int DD = Integer.parseInt(dts[2]);
        int HH = Integer.parseInt(dts[3]);
        int mm = Integer.parseInt(dts[4]);
        int ss = Integer.parseInt(dts[5]);
        int mmmm = Integer.parseInt(dts[6]);
        GregorianCalendar cal = new GregorianCalendar(YYYY, MM, DD, HH, mm, ss);
        long time = cal.getTime().getTime() + (long)mmmm;
        return time;
    }

    public static boolean isEmptyString(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static final boolean isComplexWRD(Object wrd) {
        return !(wrd instanceof Long) && !(wrd instanceof Double) && !(wrd instanceof Boolean) && !(wrd instanceof Date) && !(wrd instanceof String);
    }

    public static Object cloneWRD(Object wrd) throws Throwable {
        if (!MiscUtilities.isComplexWRD(wrd)) {
            return wrd;
        }
        if (wrd == null) {
            return null;
        }
        Object ret = null;
        if (wrd instanceof Cloneable) {
            Class<?> cls = wrd.getClass();
            try {
                Method mth = cls.getMethod("clone", null);
                ret = mth.invoke(wrd, null);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
        if (ret == null) {
            byte[] serVal = MiscUtilities.serialize(wrd);
            ret = MiscUtilities.deserialize(serVal);
        }
        return ret;
    }

    public static String passwordDigest(String password) throws RootException {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] passwd = md.digest(password.getBytes());
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < passwd.length; ++i) {
                int current = passwd[i];
                for (int j = 0; j < 2; ++j) {
                    int nibble = 0xF & (1 == j ? current : current >> 4);
                    buffer.append(Character.forDigit(nibble, 16));
                }
            }
            return buffer.toString();
        }
        catch (Exception e) {
            throw new RootException((Throwable)e);
        }
    }

    public static String replaceAll(String input, String forReplace, String replaceWith) {
        if (input == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        boolean hasMore = true;
        while (hasMore) {
            int start = input.indexOf(forReplace);
            int end = start + forReplace.length();
            if (start != -1) {
                result.append(input.substring(0, start) + replaceWith);
                input = input.substring(end);
                continue;
            }
            hasMore = false;
            result.append(input);
        }
        if (result.toString().equals("")) {
            return input;
        }
        return result.toString();
    }
}

