/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.utilities;

import java.util.HashMap;
import java.util.Map;

public class SizeLimitedToolAgentMap
extends HashMap {
    private int maximumSize = 0x7FFFFFFE;

    public SizeLimitedToolAgentMap() {
        System.out.println("Tool agent map created, maximum number of mappings is " + this.maximumSize);
    }

    public SizeLimitedToolAgentMap(int maxSize) {
        this();
        this.maximumSize = maxSize < 0 ? 0x7FFFFFFE : maxSize;
        System.out.println("Tool agent map created, maximum number of mappings is " + this.maximumSize);
    }

    public SizeLimitedToolAgentMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        System.out.println("Tool agent map created, maximum number of mappings is " + this.maximumSize);
    }

    public SizeLimitedToolAgentMap(int initialCapacity, float loadFactor, int maxSize) {
        this(initialCapacity, loadFactor);
        this.maximumSize = maxSize;
        System.out.println("Tool agent map created, maximum number of mappings is " + this.maximumSize);
    }

    public SizeLimitedToolAgentMap(Map m) {
        this.maximumSize = m.size() + 1;
        this.putAll(m);
        System.out.println("Tool agent map created, maximum number of mappings is " + this.maximumSize);
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        int mapSize = this.size();
        if (mapSize >= this.maximumSize) {
            System.err.println("Tool agent map can't accept more mappings - the maximum no. of mappings is " + this.maximumSize + " !");
            return null;
        }
        System.out.println("New mapping added to tool agent map, tool agent map currently has " + (mapSize + 1) + " mappings !");
        return super.put(key, value);
    }

    @Override
    public synchronized void putAll(Map t) {
        for (Map.Entry entry : t.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public synchronized Object remove(Object key) {
        return super.remove(key);
    }

    public int getMaximumSize() {
        return this.maximumSize;
    }
}

