/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.utilities.dods;

import com.lutris.appserver.server.sql.CoreDO;
import com.lutris.appserver.server.sql.DBTransaction;
import com.lutris.appserver.server.sql.Transaction;
import com.lutris.dods.builder.generator.dataobject.GenericDO;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.enhydra.shark.api.TransactionException;

public class Buffer {
    private static final List order = Arrays.asList("class org.enhydra.shark.instancepersistence.data.ActivityStateDO", "class org.enhydra.shark.instancepersistence.data.ProcessStateDO", "class org.enhydra.shark.instancepersistence.data.ResourceDO", "class org.enhydra.shark.instancepersistence.data.ProcessDefinitionDO", "class org.enhydra.shark.instancepersistence.data.ProcessDO", "class org.enhydra.shark.instancepersistence.data.ProcessDataDO", "class org.enhydra.shark.instancepersistence.data.ProcessDataWOBDO", "class org.enhydra.shark.instancepersistence.data.ProcessDataBLOBDO", "class org.enhydra.shark.instancepersistence.data.ActivityDO", "class org.enhydra.shark.instancepersistence.data.ActivityDataDO", "class org.enhydra.shark.instancepersistence.data.ActivityDataWOBDO", "class org.enhydra.shark.instancepersistence.data.ActivityDataBLOBDO", "class org.enhydra.shark.instancepersistence.data.ProcessRequesterDO", "class org.enhydra.shark.eventaudit.data.EventTypeDO", "class org.enhydra.shark.eventaudit.data.ProcessStateEventAuditDO", "class org.enhydra.shark.eventaudit.data.ActivityStateEventAuditDO", "class org.enhydra.shark.eventaudit.data.StateEventAuditDO", "class org.enhydra.shark.eventaudit.data.CreateProcessEventAuditDO", "class org.enhydra.shark.eventaudit.data.AssignmentEventAuditDO", "class org.enhydra.shark.eventaudit.data.DataEventAuditDO", "class org.enhydra.shark.eventaudit.data.OldEventAuditDataDO", "class org.enhydra.shark.eventaudit.data.NewEventAuditDataDO", "class org.enhydra.shark.eventaudit.data.OldEventAuditDataWOBDO", "class org.enhydra.shark.eventaudit.data.OldEventAuditDataBLOBDO", "class org.enhydra.shark.eventaudit.data.NewEventAuditDataWOBDO", "class org.enhydra.shark.eventaudit.data.NewEventAuditDataBLOBDO");
    private Map<String, Set<CoreDO>> storage;
    private Map<String, Set<CoreDO>> erasage;
    private Map<String, Set<CoreDO>> readage;
    protected DBTransaction transaction;
    private boolean readOnly = false;
    private static ArrayList empty = new ArrayList(1);

    public Buffer(DBTransaction dbt) throws NullPointerException {
        this.transaction = dbt;
        this.storage = new HashMap<String, Set<CoreDO>>();
        this.erasage = new HashMap<String, Set<CoreDO>>();
        this.readage = new HashMap<String, Set<CoreDO>>();
    }

    public void clear() {
        this.storage.clear();
        this.erasage.clear();
        this.readage.clear();
    }

    public void clear(String type) {
        this.storage.remove(type);
        this.erasage.remove(type);
        this.readage.remove(type);
    }

    public void store(CoreDO aDO) {
        if (null != aDO) {
            this.store(aDO, aDO.getClass().toString());
        }
    }

    public void erase(CoreDO aDO) {
        if (null != aDO) {
            this.erase(aDO, aDO.getClass().toString());
        }
    }

    public void _read(CoreDO aDO) {
        if (null != aDO) {
            this._read(aDO, aDO.getClass().toString());
        }
    }

    public void store(CoreDO aDO, String type) {
        if (this.readOnly) {
            throw new IllegalStateException("Buffer is [readonly] - cannot store DO object");
        }
        Set<CoreDO> l = this.storage.computeIfAbsent(type, k -> new LinkedHashSet());
        l.add(aDO);
        l = this.readage.get(type);
        if (null != l) {
            l.remove(aDO);
        }
    }

    public void erase(CoreDO aDO, String type) {
        if (this.readOnly) {
            throw new IllegalStateException("Buffer is [readonly] - cannot erase DO object");
        }
        Set l = this.readage.get(type);
        if (null != l) {
            l.remove(aDO);
        }
        if (null != (l = this.storage.get(type))) {
            l.remove(aDO);
        }
        if (aDO.isPersistent()) {
            l = this.erasage.computeIfAbsent(type, k -> new LinkedHashSet());
            l.add(aDO);
        }
    }

    public void erase(Set s) {
        if (null != s && s.size() > 0) {
            for (CoreDO cDO : s) {
                this.erase(cDO, cDO.getClass().toString());
            }
        }
    }

    public void _read(CoreDO aDO, String type) {
        Set l = this.readage.computeIfAbsent(type, k -> new LinkedHashSet());
        l.add(aDO);
    }

    public Iterator iterator4type(String type) {
        Set<CoreDO> s = this.storage.get(type);
        Set<CoreDO> r = this.readage.get(type);
        ArrayList l = new ArrayList();
        l = (ArrayList)empty.clone();
        if (null != r) {
            l.addAll(r);
        }
        if (null != s) {
            l.addAll(s);
        }
        return l.iterator();
    }

    public Iterator iterator4typeDeleted(String type) {
        Set<CoreDO> e = this.erasage.get(type);
        ArrayList l = new ArrayList();
        l = (ArrayList)empty.clone();
        if (null != e) {
            l.addAll(e);
        }
        return l.iterator();
    }

    private void iterateType(String type) throws TransactionException {
        Set<CoreDO> ret = this.storage.get(type);
        if (null != ret) {
            for (CoreDO aDO : ret) {
                this.transaction.insert((Transaction)aDO);
            }
        }
    }

    private boolean deleteType(String type) throws TransactionException {
        boolean hasDeletedEntities = false;
        Set<CoreDO> ret = this.erasage.get(type);
        if (null != ret) {
            for (GenericDO genericDO : ret) {
                try {
                    genericDO.delete();
                    hasDeletedEntities = true;
                }
                catch (Exception e) {
                    throw new TransactionException((Throwable)e);
                }
            }
        }
        return hasDeletedEntities;
    }

    public void write() throws TransactionException {
        for (String type : order) {
            this.iterateType(type);
        }
        boolean write = this.deleteType("class org.enhydra.shark.instancepersistence.data.AssignmentDO");
        if (write) {
            try {
                this.transaction.write();
            }
            catch (SQLException e) {
                throw new TransactionException((Throwable)e);
            }
        }
        this.iterateType("class org.enhydra.shark.instancepersistence.data.AssignmentDO");
        this.iterateType("class org.enhydra.shark.instancepersistence.data.DeadlineDO");
        write = this.deleteType("class org.enhydra.shark.instancepersistence.data.DeadlineDO");
        this.iterateType("class org.enhydra.shark.instancepersistence.data.AndJoinEntryDO");
        write = this.deleteType("class org.enhydra.shark.instancepersistence.data.AndJoinEntryDO") || write;
        write = this.deleteType("class org.enhydra.shark.instancepersistence.data.ProcessRequesterDO") || write;
        write = this.deleteType("class org.enhydra.shark.instancepersistence.data.ActivityDataBLOBDO") || write;
        write = this.deleteType("class org.enhydra.shark.instancepersistence.data.ActivityDataWOBDO") || write;
        boolean bl = write = this.deleteType("class org.enhydra.shark.instancepersistence.data.ActivityDataDO") || write;
        if (write) {
            try {
                this.transaction.write();
            }
            catch (SQLException e) {
                throw new TransactionException((Throwable)e);
            }
        }
        write = this.deleteType("class org.enhydra.shark.instancepersistence.data.ActivityDO");
        write = this.deleteType("class org.enhydra.shark.instancepersistence.data.ProcessDataBLOBDO") || write;
        write = this.deleteType("class org.enhydra.shark.instancepersistence.data.ProcessDataWOBDO") || write;
        boolean bl2 = write = this.deleteType("class org.enhydra.shark.instancepersistence.data.ProcessDataDO") || write;
        if (write) {
            try {
                this.transaction.write();
            }
            catch (SQLException e) {
                throw new TransactionException((Throwable)e);
            }
        }
        if (write = this.deleteType("class org.enhydra.shark.instancepersistence.data.ProcessDO")) {
            try {
                this.transaction.write();
            }
            catch (SQLException e) {
                throw new TransactionException((Throwable)e);
            }
        }
        this.deleteType("class org.enhydra.shark.instancepersistence.data.ProcessDefinitionDO");
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }
}

