/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.utilities.dods;

import com.lutris.appserver.server.sql.DBTransaction;
import com.lutris.appserver.server.sql.DatabaseManager;
import com.lutris.appserver.server.sql.StandardDatabaseManager;
import com.lutris.logging.Log4jLogger;
import com.lutris.logging.LogChannel;
import com.lutris.util.Config;
import com.lutris.util.ConfigFile;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.PropertyConfigurator;
import org.enhydra.dods.DODS;
import org.enhydra.shark.api.RootException;
import org.enhydra.shark.utilities.dods.CounterDO;
import org.enhydra.shark.utilities.dods.CounterQuery;

public class DODSUtilities {
    public static final String NULL_VALUE_FOR_PROCID = "~@#proc_id#@~";
    private static Map counterCachesSizes = new HashMap();
    private static Map counterCachesMax = new HashMap();
    private static Map counterCachesCurrent = new HashMap();
    private static Map counterCachesNext = new HashMap();
    private static Properties props;
    private static final String COUNTER_CACHE_PREFFIX = "DODS.IdGenerator.";
    private static final String COUNTER_CACHE_POSTFIX = ".CacheSize";
    private static final String COUNTER_DEFAULT_CACHE = "DODS.defaults.IdGenerator.CacheSize";
    private static final long DEFAULT_CACHE_SIZE = 100L;
    private static int allocTryCount;

    private DODSUtilities() {
    }

    public static synchronized BigDecimal getNext(String objectName) throws RootException {
        if (objectName == null) {
            throw new RootException("Object name parameter can't be null");
        }
        try {
            if (counterCachesNext.get(objectName) == null || counterCachesMax.get(objectName) == null || counterCachesNext.get(objectName).equals(counterCachesMax.get(objectName))) {
                DODSUtilities.updateCaches(objectName);
            }
            counterCachesCurrent.put(objectName, counterCachesNext.get(objectName));
            counterCachesNext.put(objectName, ((BigDecimal)counterCachesNext.get(objectName)).add(new BigDecimal("1")));
            return (BigDecimal)counterCachesCurrent.get(objectName);
        }
        catch (Exception e) {
            throw new RootException("Counter Id Allocator failed to allocate object id.", (Throwable)e);
        }
    }

    private static void updateCaches(String objectName) throws RootException {
        DBTransaction trans = null;
        for (int iTry = 0; iTry < allocTryCount; ++iTry) {
            try {
                BigDecimal dbNext;
                trans = DODS.getDatabaseManager().createTransaction();
                CounterQuery qryCounter = new CounterQuery(trans);
                qryCounter.requireUniqueInstance();
                qryCounter.setQueryName(objectName);
                CounterDO doCounter = qryCounter.getNextDO();
                if (doCounter == null) {
                    doCounter = CounterDO.createVirgin(trans);
                    doCounter.setName(objectName);
                    dbNext = new BigDecimal("1");
                } else {
                    dbNext = doCounter.getThe_number();
                }
                BigDecimal dbLast = dbNext;
                dbNext = dbNext.add(BigDecimal.valueOf(DODSUtilities.getCacheSize(objectName)));
                doCounter.setThe_number(dbNext);
                doCounter.save(trans);
                trans.commit();
                trans.release();
                counterCachesNext.put(objectName, dbLast);
                counterCachesMax.put(objectName, dbNext);
                return;
            }
            catch (Exception e) {
                if (trans == null) continue;
                trans.release();
                continue;
            }
        }
        throw new RootException("Can't allocate Id for object table " + objectName);
    }

    private static long getCacheSize(String objectName) {
        long cacheSize = -1L;
        Object cs = counterCachesSizes.get(objectName);
        if (cs == null) {
            String propName = COUNTER_CACHE_PREFFIX + objectName + COUNTER_CACHE_POSTFIX;
            String cSize = props.getProperty(propName);
            String defCSize = props.getProperty(COUNTER_DEFAULT_CACHE);
            if (cSize != null) {
                try {
                    cacheSize = Long.parseLong(cSize);
                    if (cacheSize <= 0L) {
                        cacheSize = -1L;
                        System.err.println("Wrong value for " + objectName + " cache size");
                    }
                }
                catch (Exception ex) {
                    cacheSize = -1L;
                    System.err.println("Wrong value for " + objectName + " cache size");
                }
            }
            if (cacheSize == -1L) {
                if (defCSize != null) {
                    try {
                        cacheSize = Long.parseLong(defCSize);
                        if (cacheSize <= 0L) {
                            cacheSize = 100L;
                            System.err.println("Wrong value for default cache size, using default size 100");
                        }
                    }
                    catch (Exception ex) {
                        cacheSize = 100L;
                        System.err.println("Wrong value for default cache size, using default size 100");
                    }
                } else {
                    cacheSize = 100L;
                }
            }
            counterCachesSizes.put(objectName, new Long(cacheSize));
        } else {
            cacheSize = (Long)cs;
        }
        return cacheSize;
    }

    public static synchronized void init(final Properties props) throws RootException {
        if (DODSUtilities.props == null) {
            DODSUtilities.props = new Properties(props);
        }
        if (null == DODS.getDatabaseManager()) {
            Log4jLogger enhydraLogger = new Log4jLogger(true){

                public void configure(String s) {
                    PropertyConfigurator.configure((Properties)props);
                }
            };
            DODS.registerDefaultLogChannel((LogChannel)enhydraLogger.getChannel("DatabaseManager"));
            DODS.setThreading((boolean)false);
            try {
                StringWriter sw = new StringWriter();
                for (Map.Entry<Object, Object> me : props.entrySet()) {
                    String key = ((String)me.getKey()).trim();
                    if (!key.startsWith("DatabaseManager.")) continue;
                    sw.write(key + " = " + me.getValue() + "\n");
                }
                ByteArrayInputStream baris = new ByteArrayInputStream(sw.getBuffer().toString().getBytes());
                ConfigFile cf = new ConfigFile((InputStream)baris);
                Config dmConfig = new Config(cf.getConfig().getSection("DatabaseManager"));
                StandardDatabaseManager dbMgr = new StandardDatabaseManager(dmConfig);
                DODS.registerDefault((DatabaseManager)dbMgr);
            }
            catch (Exception e) {
                throw new RootException("DODS init problem.", (Throwable)e);
            }
        }
    }

    static {
        allocTryCount = 50;
    }
}

