package org.enhydra.shark.utilities.dods;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.enhydra.shark.api.TransactionException;

import com.lutris.appserver.server.sql.CoreDO;
import com.lutris.appserver.server.sql.DBTransaction;
import com.lutris.dods.builder.generator.dataobject.GenericDO;

public class Buffer {
   private static final List order = Arrays.asList(new String[]{
            //working objects
            "class org.enhydra.shark.instancepersistence.data.ActivityStateDO",
               "class org.enhydra.shark.instancepersistence.data.ProcessStateDO",
               "class org.enhydra.shark.instancepersistence.data.ResourceDO",
               "class org.enhydra.shark.instancepersistence.data.ProcessDefinitionDO",
               "class org.enhydra.shark.instancepersistence.data.ProcessDO",
               "class org.enhydra.shark.instancepersistence.data.ProcessDataDO",
               "class org.enhydra.shark.instancepersistence.data.ProcessDataWOBDO",
               "class org.enhydra.shark.instancepersistence.data.ProcessDataBLOBDO",
               "class org.enhydra.shark.instancepersistence.data.ActivityDO",
               "class org.enhydra.shark.instancepersistence.data.ActivityDataDO",
               "class org.enhydra.shark.instancepersistence.data.ActivityDataWOBDO",
               "class org.enhydra.shark.instancepersistence.data.ActivityDataBLOBDO",
               //"class org.enhydra.shark.instancepersistence.data.AndJoinEntryDO",
               //"class org.enhydra.shark.instancepersistence.data.DeadlineDO",
               //"class org.enhydra.shark.instancepersistence.data.AssignmentDO",
               "class org.enhydra.shark.instancepersistence.data.ProcessRequesterDO",
               // event audits
               "class org.enhydra.shark.eventaudit.data.EventTypeDO",
               "class org.enhydra.shark.eventaudit.data.ProcessStateEventAuditDO",
               "class org.enhydra.shark.eventaudit.data.ActivityStateEventAuditDO",
               "class org.enhydra.shark.eventaudit.data.StateEventAuditDO",
               "class org.enhydra.shark.eventaudit.data.CreateProcessEventAuditDO",
               "class org.enhydra.shark.eventaudit.data.AssignmentEventAuditDO",
               "class org.enhydra.shark.eventaudit.data.DataEventAuditDO",
               "class org.enhydra.shark.eventaudit.data.OldEventAuditDataDO",
               "class org.enhydra.shark.eventaudit.data.NewEventAuditDataDO",
               "class org.enhydra.shark.eventaudit.data.OldEventAuditDataWOBDO",
               "class org.enhydra.shark.eventaudit.data.OldEventAuditDataBLOBDO",
               "class org.enhydra.shark.eventaudit.data.NewEventAuditDataWOBDO",
               "class org.enhydra.shark.eventaudit.data.NewEventAuditDataBLOBDO"
         });

   private Map<String, Set<CoreDO>> storage;
   private Map<String, Set<CoreDO>> erasage;
   private Map<String, Set<CoreDO>> readage;
   protected DBTransaction transaction;
   
   // PWFL-1432 START
   private boolean readOnly = false;
   // PWFL-1432 END

   public Buffer(DBTransaction dbt) throws NullPointerException {
      transaction = dbt;
      storage = new HashMap<>();
      erasage = new HashMap<>();
      readage = new HashMap<>();
   }

   public void clear() {
      storage.clear();
      erasage.clear();
      readage.clear();
   }

   public void clear(String type) {
      storage.remove(type);
      erasage.remove(type);
      readage.remove(type);
   }

   public void store(CoreDO aDO) {
      if (null != aDO)
         store(aDO, aDO.getClass().toString());
   }

   public void erase(CoreDO aDO) {
      if (null != aDO)
         erase(aDO, aDO.getClass().toString());
   }

   public void _read(CoreDO aDO) {
      if (null != aDO)
         _read(aDO, aDO.getClass().toString());
   }

   public void store(CoreDO aDO, String type) {
       
       // PWFL-1432 START
       if(readOnly){
           throw new IllegalStateException( "Buffer is [readonly] - cannot store DO object" );
       }
       // PWFL-1432 END
       
      //System.err.println("__store__ "+ type +" "+aDO.toString());
      Set<CoreDO> l = storage.computeIfAbsent( type, k -> new LinkedHashSet<>() );
      l.add(aDO);
      l = readage.get(type);
      if ( null != l )
         l.remove(aDO);
   }

   public void erase(CoreDO aDO, String type) {
       // PWFL-1432 START
       if(readOnly){
           throw new IllegalStateException( "Buffer is [readonly] - cannot erase DO object" );
       }
       // PWFL-1432 END
       
       
      //System.err.println("__erase__ "+ type +" "+aDO.get_OId());
      Set<CoreDO> l = readage.get(type);
      if ( null != l )
         l.remove(aDO);
      l = storage.get(type);
      if ( null != l )
         l.remove(aDO);

      if (aDO.isPersistent()) {
         l = erasage.computeIfAbsent( type, k -> new LinkedHashSet<>() );
         l.add(aDO);
      }
   }

   public void erase(Set s) {
      if (null != s && s.size() > 0) {
         Iterator it=s.iterator();
         while (it.hasNext()) {
            CoreDO cDO=(CoreDO)it.next();
            erase(cDO,cDO.getClass().toString());
         }
      }
   }

   public void _read(CoreDO aDO, String type) {
      //System.err.println("___read__ "+ type +" "+aDO.get_OId());
      Set<CoreDO> l = readage.computeIfAbsent( type, k -> new LinkedHashSet<>() );
      l.add(aDO);
   }

   private static ArrayList empty = new ArrayList(1);
   public Iterator iterator4type(String type) {
      Set<CoreDO> s = storage.get(type);
      //List e = (List)erasage.get(type);
      Set<CoreDO> r = readage.get(type);
      List<CoreDO> l = new ArrayList<>();
      l = (ArrayList)empty.clone();
      if (null != r) {
         l.addAll(r);
      }
      if (null != s) {
         l.addAll(s);
      }
      return l.iterator();
   }

   public Iterator iterator4typeDeleted(String type) {
      Set<CoreDO> e = erasage.get(type);
      List<CoreDO> l = new ArrayList<>();
      l = (ArrayList)empty.clone();
      if (null != e) {
         l.addAll(e);
      }
      return l.iterator();
   }

   private void iterateType(String type) throws TransactionException {
      Set<CoreDO> ret = storage.get(type);
      if (null != ret) {
         for (Iterator<CoreDO> it = ret.iterator(); it.hasNext();) {
            CoreDO aDO = it.next();
            transaction.insert(aDO);
            //System.err.print("*");
         }
      }
   }

   private boolean deleteType(String type) throws TransactionException {
      boolean hasDeletedEntities=false;
      Set<CoreDO> ret = erasage.get(type);
      if (null != ret) {
         for (Iterator it = ret.iterator(); it.hasNext();) {
            GenericDO aDO = (GenericDO)it.next();
            //transaction.delete(aDO);
            //if (aDO.isPersistent()) {
            try {
               //System.out.println("Deleting obj "+aDO);
               aDO.delete();
               hasDeletedEntities=true;
            } catch (Exception e) {
               throw new TransactionException(e);
            }
            //}
         }
      }
      return hasDeletedEntities;
   }

   public void write() throws TransactionException {
      for (Iterator it = order.iterator(); it.hasNext();) {
         String type = (String)it.next();
         //System.err.print("\n__ "+ type +" ");
         iterateType(type);
         //System.err.println(type +" __");
      }

      // this must be done first because of assignment reevaluation, but it
      boolean write=deleteType("class org.enhydra.shark.instancepersistence.data.AssignmentDO");
      if (write) {
         try {
            transaction.write();
         } catch (SQLException e) {
            throw new TransactionException(e);
         }
      }
      iterateType("class org.enhydra.shark.instancepersistence.data.AssignmentDO");

      iterateType("class org.enhydra.shark.instancepersistence.data.DeadlineDO");
      write=deleteType("class org.enhydra.shark.instancepersistence.data.DeadlineDO");

      iterateType("class org.enhydra.shark.instancepersistence.data.AndJoinEntryDO");
      write=deleteType("class org.enhydra.shark.instancepersistence.data.AndJoinEntryDO") || write;

      write=deleteType("class org.enhydra.shark.instancepersistence.data.ProcessRequesterDO") || write;
      write=deleteType("class org.enhydra.shark.instancepersistence.data.ActivityDataBLOBDO") || write;
      write=deleteType("class org.enhydra.shark.instancepersistence.data.ActivityDataWOBDO") || write;
      write=deleteType("class org.enhydra.shark.instancepersistence.data.ActivityDataDO") || write;

      if (write) {
         try {
            transaction.write();
         } catch (SQLException e) {
            throw new TransactionException(e);
         }
      }
      write=deleteType("class org.enhydra.shark.instancepersistence.data.ActivityDO");
      write=deleteType("class org.enhydra.shark.instancepersistence.data.ProcessDataBLOBDO") || write;
      write=deleteType("class org.enhydra.shark.instancepersistence.data.ProcessDataWOBDO") || write;
      write=deleteType("class org.enhydra.shark.instancepersistence.data.ProcessDataDO") || write;

      //TODO: read instancepersistnce option for deleting???
      if (write) {
         try {
            transaction.write();
         } catch (SQLException e) {
            throw new TransactionException(e);
         }
      }

      write=deleteType("class org.enhydra.shark.instancepersistence.data.ProcessDO");
      if (write) {
         try {
            transaction.write();
         } catch (SQLException e) {
            throw new TransactionException(e);
         }
      }
      deleteType("class org.enhydra.shark.instancepersistence.data.ProcessDefinitionDO");

   }

   // PWFL-1432 START
   public void setReadOnly( boolean readOnly )
   {
       this.readOnly = readOnly;
   }

   public boolean isReadOnly()
   {
       return readOnly;
   }
   // PWFL-1432 END
   
}


