/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.usertransaction;

import com.lutris.appserver.server.sql.DBTransaction;
import org.enhydra.shark.api.TransactionException;
import org.enhydra.shark.api.UserTransaction;
import org.enhydra.shark.usertransaction.DODSUserTransactionFactory;

public class SharkDODSUserTransaction
implements UserTransaction {
    private static int noOfCreations = 0;
    private static int noOfCommits = 0;
    private static int noOfRollbacks = 0;
    private static int noOfReleases = 0;
    private DBTransaction transaction;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public SharkDODSUserTransaction(DBTransaction transaction) {
        if (DODSUserTransactionFactory._debug_) {
            Class<SharkDODSUserTransaction> clazz = SharkDODSUserTransaction.class;
            // MONITORENTER : org.enhydra.shark.usertransaction.SharkDODSUserTransaction.class
            System.out.println("CREATING User T No" + ++noOfCreations);
            // MONITOREXIT : clazz
        }
        this.transaction = transaction;
    }

    public DBTransaction getDODSTransaction() {
        return this.transaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void commit() throws TransactionException {
        Class<SharkDODSUserTransaction> clazz;
        if (DODSUserTransactionFactory._debug_) {
            clazz = SharkDODSUserTransaction.class;
            // MONITORENTER : org.enhydra.shark.usertransaction.SharkDODSUserTransaction.class
            System.out.println("COMMITING User T ");
            // MONITOREXIT : clazz
        }
        try {
            this.transaction.commit();
            if (!DODSUserTransactionFactory._debug_) return;
            clazz = SharkDODSUserTransaction.class;
            // MONITORENTER : org.enhydra.shark.usertransaction.SharkDODSUserTransaction.class
            System.out.println("COMMITED User T No" + ++noOfCommits);
            // MONITOREXIT : clazz
            return;
        }
        catch (Exception ex) {
            throw new TransactionException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void rollback() throws TransactionException {
        try {
            if (!DODSUserTransactionFactory._debug_) return;
            Class<SharkDODSUserTransaction> clazz = SharkDODSUserTransaction.class;
            synchronized (SharkDODSUserTransaction.class) {
                System.out.println("ROLLING BACK User T" + ++noOfRollbacks);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
        catch (Exception ex) {
            if (!DODSUserTransactionFactory._debug_) throw new TransactionException((Throwable)ex);
            System.out.println("ROLLING BACK FAILED");
            throw new TransactionException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void release() throws TransactionException {
        try {
            this.transaction.release();
            if (!DODSUserTransactionFactory._debug_) return;
            Class<SharkDODSUserTransaction> clazz = SharkDODSUserTransaction.class;
            synchronized (SharkDODSUserTransaction.class) {
                System.out.println("RELEASE User T " + ++noOfReleases);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
        catch (Exception ex) {
            if (!DODSUserTransactionFactory._debug_) throw new TransactionException((Throwable)ex);
            System.out.println("RELEASE User T FAILED");
            throw new TransactionException((Throwable)ex);
        }
    }

    public static synchronized void info() {
        if (noOfCreations != noOfReleases) {
            System.err.println("PANIC!!!\nI've lost user transaction counts.");
        }
        System.err.println("UTCRE=" + noOfCreations + ", UTCOMM=" + noOfCommits + ", UTROLL=" + noOfRollbacks + ", UTREL=" + noOfReleases);
    }
}

