/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.transaction;

import com.lutris.appserver.server.sql.DBTransaction;
import java.util.HashMap;
import java.util.Map;
import org.enhydra.shark.api.RootException;
import org.enhydra.shark.api.TransactionException;
import org.enhydra.shark.api.internal.transaction.SharkInternalTransaction;
import org.enhydra.shark.api.internal.working.WfProcessInternal;
import org.enhydra.shark.api.internal.working.WfResourceInternal;
import org.enhydra.shark.transaction.DODSTransactionFactory;
import org.enhydra.shark.utilities.dods.Buffer;

public class SharkDODSTransaction
extends Buffer
implements SharkInternalTransaction {
    private Map processes = new HashMap();
    private Map resources = new HashMap();
    private static int noOfCreations = 0;
    private static int noOfCommits = 0;
    private static int noOfRollbacks = 0;
    private static int noOfReleases = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SharkDODSTransaction(DBTransaction transaction) {
        super(transaction);
        if (!DODSTransactionFactory._debug_) return;
        Class<SharkDODSTransaction> clazz = SharkDODSTransaction.class;
        synchronized (SharkDODSTransaction.class) {
            System.out.println("CREATING T No" + ++noOfCreations);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public DBTransaction getDODSTransaction() {
        return this.transaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void commit() throws TransactionException {
        Class<SharkDODSTransaction> clazz;
        if (DODSTransactionFactory._debug_) {
            clazz = SharkDODSTransaction.class;
            // MONITORENTER : org.enhydra.shark.transaction.SharkDODSTransaction.class
            System.out.println("COMMITING T ");
            // MONITOREXIT : clazz
        }
        try {
            this.write();
            this.transaction.commit();
            if (!DODSTransactionFactory._debug_) return;
            clazz = SharkDODSTransaction.class;
            // MONITORENTER : org.enhydra.shark.transaction.SharkDODSTransaction.class
            System.out.println("COMMITED T No" + ++noOfCommits);
            // MONITOREXIT : clazz
            return;
        }
        catch (Exception ex) {
            throw new TransactionException((Throwable)ex);
        }
        finally {
            this.processes.clear();
            this.resources.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void rollback() throws TransactionException {
        try {
            if (!DODSTransactionFactory._debug_) return;
            Class<SharkDODSTransaction> clazz = SharkDODSTransaction.class;
            synchronized (SharkDODSTransaction.class) {
                System.out.println("ROLLING BACK T " + ++noOfRollbacks);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
        catch (Exception ex) {
            if (!DODSTransactionFactory._debug_) throw new TransactionException((Throwable)ex);
            System.out.println("ROLLING BACK FAILED");
            throw new TransactionException((Throwable)ex);
        }
        finally {
            this.processes.clear();
            this.resources.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void release() throws TransactionException {
        try {
            this.clear();
            this.transaction.release();
            if (!DODSTransactionFactory._debug_) return;
            Class<SharkDODSTransaction> clazz = SharkDODSTransaction.class;
            synchronized (SharkDODSTransaction.class) {
                System.out.println("RELEASE T " + ++noOfReleases);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
        catch (Exception ex) {
            if (!DODSTransactionFactory._debug_) throw new TransactionException((Throwable)ex);
            System.out.println("RELEASE FAILED");
            throw new TransactionException((Throwable)ex);
        }
        finally {
            this.processes.clear();
            this.resources.clear();
        }
    }

    public static synchronized void info() {
        if (noOfCreations != noOfReleases) {
            System.err.println("PANIC!!!\nI've lost transcaton counts.");
        }
        System.err.println("CRE=" + noOfCreations + ", COMM=" + noOfCommits + ", ROLL=" + noOfRollbacks + ", REL=" + noOfReleases);
    }

    public void addToTransaction(String procId, WfProcessInternal proc) throws RootException {
        this.processes.put(procId, proc);
    }

    public void addToTransaction(String resUname, WfResourceInternal res) throws RootException {
        this.resources.put(resUname, res);
    }

    public void removeProcess(String procId) throws RootException {
        this.processes.remove(procId);
    }

    public void removeResource(String resUname) throws RootException {
        this.resources.remove(resUname);
    }

    public WfProcessInternal getProcess(String procId) throws RootException {
        return (WfProcessInternal)this.processes.get(procId);
    }

    public WfResourceInternal getResource(String resUname) throws RootException {
        return (WfResourceInternal)this.resources.get(resUname);
    }
}

