/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.toolagent;

import EDU.oswego.cs.dl.util.concurrent.Channel;
import EDU.oswego.cs.dl.util.concurrent.LinkedQueue;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.enhydra.shark.api.internal.working.CallbackUtilities;
import org.enhydra.shark.toolagent.ToolAgentCmdProxy;

class SingletonPooledExecutor
extends PooledExecutor {
    private static final Object classLock = SingletonPooledExecutor.class;
    private static final String SHUTDOWN_HOOK_THREAD_NAME = "SingletonPooledExecShutdownHook";
    private static boolean s_shutdown = false;
    private static Thread s_shutdownHook;
    private static SingletonPooledExecutor m_spe;
    private static CallbackUtilities m_cus;
    private Map m_assIdToCount = new HashMap();
    private String m_sharkUsername;
    private String m_sharkPassword;

    private SingletonPooledExecutor(LinkedQueue queue, int threadPoolSize) {
        super((Channel)queue, threadPoolSize);
    }

    public String getSharkUsername() {
        return this.m_sharkUsername;
    }

    public String getSharkPassword() {
        return this.m_sharkPassword;
    }

    private void info(String infoString) {
        if (null != m_cus) {
            m_cus.info(infoString);
        } else {
            System.out.println(infoString);
        }
    }

    private void error(String infoString) {
        if (null != m_cus) {
            m_cus.error(infoString);
        } else {
            System.out.println(infoString);
        }
    }

    private static void shutdown() {
        s_shutdown = true;
        if (null != m_spe) {
            m_spe.shutdownNow();
            try {
                int remainingThreads;
                long timeout = 2000L;
                if (!m_spe.awaitTerminationAfterShutdown(2000L) && 0 != (remainingThreads = m_spe.getPoolSize())) {
                    m_spe.info("Threads remaining during shutdown: " + remainingThreads);
                }
                List pendingTasks = m_spe.drain();
                for (ToolAgentCmdProxy obj : pendingTasks) {
                    m_spe.info("Pending task: " + obj.toString());
                    obj.cancel();
                }
            }
            catch (Exception ex) {
                m_spe.error("Exception during thread pool shutdown: " + ex.toString());
            }
            m_spe = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SingletonPooledExecutor getInstance(CallbackUtilities cus) throws Exception {
        Object object = classLock;
        synchronized (object) {
            if (null == m_spe) {
                try {
                    m_cus = cus;
                    int threadPoolSize = 3;
                    try {
                        String threadPoolSizeStr = cus.getProperty("SchedulerToolAgent.threadPoolSize", Integer.toString(3));
                        threadPoolSize = Integer.parseInt(threadPoolSizeStr);
                    }
                    catch (Exception threadPoolSizeStr) {
                        // empty catch block
                    }
                    String sharkUsername = cus.getProperty("SchedulerToolAgent.sharkUsername", "admin");
                    String sharkPassword = cus.getProperty("SchedulerToolAgent.sharkPassword", "enhydra");
                    s_shutdownHook = new Thread(){

                        @Override
                        public void run() {
                            SingletonPooledExecutor.shutdown();
                        }
                    };
                    s_shutdownHook.setName(SHUTDOWN_HOOK_THREAD_NAME);
                    Runtime.getRuntime().addShutdownHook(s_shutdownHook);
                    m_spe = new SingletonPooledExecutor(new LinkedQueue(), threadPoolSize);
                    m_spe.waitWhenBlocked();
                    m_spe.createThreads(threadPoolSize);
                    SingletonPooledExecutor.m_spe.m_sharkUsername = sharkUsername;
                    SingletonPooledExecutor.m_spe.m_sharkPassword = sharkPassword;
                }
                catch (Exception ex) {
                    String errorMsg = "Exception during thread pool init " + ex.toString();
                    if (null != m_cus) {
                        m_cus.error(errorMsg);
                    } else {
                        System.out.println(errorMsg);
                    }
                    if (null != s_shutdownHook) {
                        Runtime.getRuntime().removeShutdownHook(s_shutdownHook);
                    }
                    s_shutdownHook = null;
                    if (null != m_spe) {
                        SingletonPooledExecutor.shutdown();
                    }
                    throw ex;
                }
            }
            return m_spe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ToolAgentCmdProxy cmdProxy) throws InterruptedException {
        Map map = this.m_assIdToCount;
        synchronized (map) {
            Object assId = cmdProxy.getAssId();
            Integer curCnt = null == assId ? null : (Integer)this.m_assIdToCount.get(assId);
            int assIdCnt = null == curCnt ? 1 : curCnt + 1;
            this.m_assIdToCount.put(assId, new Integer(assIdCnt));
        }
        super.execute((Runnable)cmdProxy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateCompleteCount(ToolAgentCmdProxy cmdProxy) {
        int returnCnt;
        Map map = this.m_assIdToCount;
        synchronized (map) {
            Integer curCnt;
            Object assId = cmdProxy.getAssId();
            Integer n = curCnt = null == assId ? null : (Integer)this.m_assIdToCount.get(assId);
            if (null == curCnt) {
                this.error("Unable to find cmd count for assId " + assId.toString());
                int n2 = -1;
            }
            returnCnt = Math.max(curCnt - 1, 0);
            this.m_assIdToCount.put(assId, new Integer(returnCnt));
        }
        return returnCnt;
    }

    static {
        m_spe = null;
        m_cus = null;
    }
}

