/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.toolagent;

import org.enhydra.shark.api.RootError;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.internal.toolagent.AppParameter;
import org.enhydra.shark.api.internal.toolagent.ApplicationBusy;
import org.enhydra.shark.api.internal.toolagent.ApplicationNotDefined;
import org.enhydra.shark.api.internal.toolagent.ApplicationNotStarted;
import org.enhydra.shark.api.internal.toolagent.ConnectFailed;
import org.enhydra.shark.api.internal.toolagent.SessionHandle;
import org.enhydra.shark.api.internal.toolagent.ToolAgent;
import org.enhydra.shark.api.internal.toolagent.ToolAgentGeneralException;
import org.enhydra.shark.toolagent.AbstractToolAgent;
import org.enhydra.shark.toolagent.ToolAgentLoader;
import org.enhydra.shark.xpdl.elements.ExtendedAttribute;
import org.enhydra.shark.xpdl.elements.ExtendedAttributes;

public class DefaultToolAgent
extends AbstractToolAgent {
    private static final String TOOL_AGENT_CLASS_EXT_ATTR_NAME = "ToolAgentClass";
    private String taClass;
    private String callingAppName;
    private Integer callingAppMode;
    private Object appInputParameters;

    @Override
    public void invokeApplication(SharkTransaction t, long handle, String applicationName, String procInstId, String assId, AppParameter[] parameters, Integer appMode) throws ApplicationNotStarted, ApplicationNotDefined, ApplicationBusy, ToolAgentGeneralException {
        super.invokeApplication(t, handle, applicationName, procInstId, assId, parameters, appMode);
        try {
            SessionHandle taShandle;
            this.status = 0L;
            String extAttribs = (String)parameters[0].the_value;
            this.readParamsFromExtAttributes(extAttribs);
            Class cls = null;
            try {
                cls = Class.forName(this.taClass);
            }
            catch (ClassNotFoundException cnfe1) {
                cls = ToolAgentLoader.load(this.cus, this.taClass);
            }
            ToolAgent ta = (ToolAgent)cls.newInstance();
            ta.configure(this.cus);
            try {
                taShandle = ta.connect(t, this.username, this.password, this.engineName, this.scope, this.appTool);
            }
            catch (ConnectFailed cf) {
                this.cus.error("Default Tool Agent - connection to Tool agent " + this.taClass + " failed !");
                throw cf;
            }
            ta.invokeApplication(t, taShandle.getHandle(), this.callingAppName, procInstId, assId, parameters, this.callingAppMode);
            this.status = ta.requestAppStatus(t, taShandle.getHandle(), procInstId, assId, parameters);
            this.appInputParameters = ta.resolveInputParameters();
            ta.disconnect(t, taShandle);
        }
        catch (ClassNotFoundException cnf) {
            this.cus.error("DefaultToolAgent - application " + this.appName + " terminated incorrectly, can't find class: " + cnf);
            throw new ApplicationNotDefined("Can't find class " + this.taClass, (Throwable)cnf);
        }
        catch (NoClassDefFoundError ncdfe) {
            this.cus.error("DefaultToolAgent - application " + this.appName + " terminated incorrectly, can't find class definition: " + ncdfe);
            throw new ApplicationNotDefined("Class " + this.appName + " can't be executed", (Throwable)ncdfe);
        }
        catch (Throwable ex) {
            this.cus.error("DefaultToolAgent - application " + this.appName + " terminated incorrectly: " + ex);
            this.status = -1L;
            if (ex instanceof ToolAgentGeneralException) {
                throw (ToolAgentGeneralException)ex;
            }
            if (ex instanceof ApplicationNotStarted) {
                throw (ApplicationNotStarted)ex;
            }
            if (ex instanceof ApplicationNotDefined) {
                throw (ApplicationNotDefined)ex;
            }
            if (ex instanceof ApplicationBusy) {
                throw (ApplicationBusy)ex;
            }
            throw new RootError("Unexpected error", ex);
        }
    }

    public Object resolveInputParameters() {
        return this.appInputParameters;
    }

    @Override
    public String getInfo(SharkTransaction t) throws ToolAgentGeneralException {
        String i = "It is used to execute other tool agents based on XPDL extended attributes\nof appropriate Application definition. It is called by kernel if there are\nno mapping information for some XPDL Application definition";
        return i;
    }

    @Override
    protected ExtendedAttributes readParamsFromExtAttributes(String extAttribs) throws Exception {
        String oldAppName = this.appName;
        Integer oldAppMode = this.appMode;
        ExtendedAttributes eas = super.readParamsFromExtAttributes(extAttribs);
        this.callingAppName = this.appName;
        this.callingAppMode = this.appMode;
        this.appName = oldAppName;
        this.appMode = oldAppMode;
        ExtendedAttribute ea = eas.getFirstExtendedAttributeForName(TOOL_AGENT_CLASS_EXT_ATTR_NAME);
        if (ea != null) {
            this.taClass = ea.getVValue();
        }
        return eas;
    }
}

