/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.toolagent;

import java.util.ArrayList;
import org.enhydra.shark.api.RootException;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.internal.toolagent.AppParameter;
import org.enhydra.shark.api.internal.toolagent.ApplicationBusy;
import org.enhydra.shark.api.internal.toolagent.ApplicationNotDefined;
import org.enhydra.shark.api.internal.toolagent.ApplicationNotStarted;
import org.enhydra.shark.api.internal.toolagent.ApplicationNotStopped;
import org.enhydra.shark.api.internal.toolagent.ConnectFailed;
import org.enhydra.shark.api.internal.toolagent.InvalidProcessInstance;
import org.enhydra.shark.api.internal.toolagent.InvalidSessionHandle;
import org.enhydra.shark.api.internal.toolagent.InvalidToolAgentHandle;
import org.enhydra.shark.api.internal.toolagent.InvalidWorkitem;
import org.enhydra.shark.api.internal.toolagent.SessionHandle;
import org.enhydra.shark.api.internal.toolagent.ToolAgent;
import org.enhydra.shark.api.internal.toolagent.ToolAgentGeneralException;
import org.enhydra.shark.api.internal.working.CallbackUtilities;
import org.enhydra.shark.toolagent.SessionHandleImpl;
import org.enhydra.shark.utilities.SizeLimitedToolAgentMap;
import org.enhydra.shark.xpdl.XMLUtil;
import org.enhydra.shark.xpdl.elements.ExtendedAttribute;
import org.enhydra.shark.xpdl.elements.ExtendedAttributes;
import org.enhydra.shark.xpdl.elements.Tool;

public abstract class AbstractToolAgent
implements ToolAgent {
    public static final long APP_STATUS_INVALID = -1L;
    public static final long APP_STATUS_RUNNING = 0L;
    public static final long APP_STATUS_ACTIVE = 1L;
    public static final long APP_STATUS_WAITING = 2L;
    public static final long APP_STATUS_TERMINATED = 3L;
    public static final long APP_STATUS_FINISHED = 4L;
    public static final String APP_NAME_EXT_ATTR_NAME = "AppName";
    public static final String APP_MODE_EXT_ATTR_NAME = "AppMode";
    protected String username;
    protected String password;
    protected String engineName;
    protected String scope;
    protected SessionHandle shandle;
    protected long handle;
    protected String appName;
    protected String procInstId;
    protected String assId;
    protected AppParameter[] parameters;
    protected Integer appMode;
    protected long status = 1L;
    protected CallbackUtilities cus;
    protected static SizeLimitedToolAgentMap extAttributes = null;
    protected Tool appTool;

    public void configure(CallbackUtilities cus) throws RootException {
        this.cus = cus;
        if (extAttributes == null) {
            int eacs = -1;
            try {
                eacs = Integer.parseInt(cus.getProperty("AbstractToolAgent.extAttribsCacheSize", "-1"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            extAttributes = new SizeLimitedToolAgentMap(eacs);
        }
    }

    public SessionHandle connect(SharkTransaction t, String userId, String password, String engineName, String scope) throws ConnectFailed, ToolAgentGeneralException {
        return this.connect(t, userId, password, engineName, scope, null);
    }

    public SessionHandle connect(SharkTransaction t, String userId, String password, String engineName, String scope, Tool tool) throws ConnectFailed, ToolAgentGeneralException {
        this.username = userId;
        this.password = password;
        this.engineName = engineName;
        this.scope = scope;
        this.shandle = new SessionHandleImpl(0L, "");
        this.appTool = tool;
        return this.shandle;
    }

    public void disconnect(SharkTransaction t, SessionHandle shandle) throws InvalidSessionHandle, ToolAgentGeneralException {
        if (!this.shandle.equals(shandle)) {
            throw new InvalidSessionHandle();
        }
    }

    public void invokeApplication(SharkTransaction t, long handle, String applicationName, String procInstId, String assId, AppParameter[] parameters, Integer appMode) throws ApplicationNotStarted, ApplicationNotDefined, ApplicationBusy, ToolAgentGeneralException {
        this.handle = handle;
        this.appName = applicationName;
        this.procInstId = procInstId;
        this.assId = assId;
        this.parameters = parameters;
        this.appMode = appMode;
        this.status = 1L;
    }

    public long requestAppStatus(SharkTransaction t, long handle, String procInstId, String assId, AppParameter[] parameters) throws ApplicationBusy, InvalidToolAgentHandle, InvalidWorkitem, InvalidProcessInstance, ToolAgentGeneralException {
        if (this.handle == handle) {
            if (this.status != 4L && this.status != 3L && this.status != -1L) {
                throw new ApplicationBusy();
            }
            if (this.status != -1L) {
                AbstractToolAgent.copyParams(this.getReturnParameters(), parameters);
            }
            return this.status;
        }
        throw new InvalidToolAgentHandle("TA " + this.getClass().getName() + " - Can't find app for [handle=" + handle + ",pId=" + procInstId + ",assId=" + assId + "]");
    }

    public void terminateApp(SharkTransaction t, long handle, String procInstId, String assId) throws ApplicationNotStopped, InvalidWorkitem, InvalidProcessInstance, ApplicationBusy, ToolAgentGeneralException {
        this.cus.info("Terminating tool agent applications not implemented !!!");
        throw new ApplicationNotStopped();
    }

    public String getInfo(SharkTransaction t) throws ToolAgentGeneralException {
        return "";
    }

    protected ExtendedAttributes readParamsFromExtAttributes(String extAttribs) throws Exception {
        ExtendedAttribute ea;
        ExtendedAttributes eas = (ExtendedAttributes)extAttributes.get((Object)extAttribs);
        if (eas == null) {
            if (extAttribs != null && !extAttribs.trim().equals("")) {
                try {
                    eas = XMLUtil.destringyfyExtendedAttributes((String)extAttribs);
                    eas.setReadOnly(true);
                    eas.initCaches();
                }
                catch (Throwable ex) {
                    System.out.println("FAiled to destr");
                    this.cus.warn("AbstractToolAgent -> " + ex.getMessage());
                }
            }
            extAttributes.put((Object)extAttribs, (Object)eas);
        }
        if ((ea = eas.getFirstExtendedAttributeForName(APP_NAME_EXT_ATTR_NAME)) != null) {
            this.appName = ea.getVValue();
        }
        if ((ea = eas.getFirstExtendedAttributeForName(APP_MODE_EXT_ATTR_NAME)) != null) {
            try {
                this.appMode = new Integer(Integer.parseInt(ea.getVValue()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return eas;
    }

    protected AppParameter[] getReturnParameters() {
        ArrayList<AppParameter> returnValues = new ArrayList<AppParameter>();
        if (this.parameters != null) {
            for (int i = 0; i < this.parameters.length; ++i) {
                if (!this.parameters[i].the_mode.equals("OUT") && !this.parameters[i].the_mode.equals("INOUT")) continue;
                returnValues.add(this.parameters[i]);
            }
        }
        AppParameter[] retParameters = returnValues.toArray(new AppParameter[returnValues.size()]);
        return retParameters;
    }

    public static void copyParams(AppParameter[] taApps, AppParameter[] apps) {
        if (taApps != null) {
            for (int i = 0; i < taApps.length; ++i) {
                AppParameter taApp = taApps[i];
                for (int j = 0; j < apps.length; ++j) {
                    if (!apps[j].the_actual_name.equals(taApp.the_actual_name)) continue;
                    apps[j].the_value = taApp.the_value;
                }
            }
        }
    }
}

