package org.enhydra.shark.toolagent;

import lombok.experimental.Delegate;
import org.enhydra.shark.api.RootException;
import org.enhydra.shark.api.internal.toolagent.ToolAgent;

import java.util.concurrent.Callable;

/**
 * Od wersji 1.3.10, ta klasa jest jedynie wrapperem na implementację
 * zapewnianą przez wtyczkę shark-axis-provider.
 * Bez wtyczki tool agent rzuca wyjątek.
 * 
 * Dokonywane w ten sposób ze względu na podatności w Axis 1.4, który nie ma zamiennika ani aktualizacji.
 */
public class SOAPToolAgent
    implements ToolAgent
{

    private static Callable<ToolAgent> SOAP_TOOL_AGENT_PROVIDER = null;

    @Delegate
    private final ToolAgent soapToolAgentImplementation;

    public SOAPToolAgent()
        throws RootException
    {
        soapToolAgentImplementation = instantiateImplementation();
    }

    private static synchronized ToolAgent instantiateImplementation()
        throws RootException
    {
        if ( SOAP_TOOL_AGENT_PROVIDER == null )
        {
            throw new RootException( "No implementation provider for soap tool agent" );
        }

        try
        {
            return SOAP_TOOL_AGENT_PROVIDER.call();
        }
        catch ( Exception e )
        {
            throw new RootException( "Failed to instantiate soap tool agent by provider", e );
        }
    }

    public static synchronized void registerImplementationProvider( Callable<ToolAgent> soapToolAgentProvider )
    {
        if ( SOAP_TOOL_AGENT_PROVIDER != null )
        {
            throw new IllegalStateException( "Soap tool agent provider already registered" );
        }

        SOAP_TOOL_AGENT_PROVIDER = soapToolAgentProvider;
    }

    public static synchronized void unregisterImplementationProvider()
    {
        if ( SOAP_TOOL_AGENT_PROVIDER == null )
        {
            throw new IllegalStateException( "Soap tool agent provider already unregistered" );
        }

        SOAP_TOOL_AGENT_PROVIDER = null;
    }

}

